/*
 * Decompiled with CFR 0.152.
 */
package org.nick.abe;

import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

public class AndroidBackup {
    private static final int BACKUP_MANIFEST_VERSION = 1;
    private static final String BACKUP_FILE_HEADER_MAGIC = "ANDROID BACKUP\n";
    private static final int BACKUP_FILE_V1 = 1;
    private static final int BACKUP_FILE_V2 = 2;
    private static final int BACKUP_FILE_V3 = 3;
    private static final int BACKUP_FILE_V4 = 4;
    private static final int BACKUP_FILE_V5 = 5;
    private static final String ENCRYPTION_MECHANISM = "AES/CBC/PKCS5Padding";
    private static final int PBKDF2_HASH_ROUNDS = 10000;
    private static final int PBKDF2_KEY_SIZE = 256;
    private static final int MASTER_KEY_SIZE = 256;
    private static final int PBKDF2_SALT_SIZE = 512;
    private static final String ENCRYPTION_ALGORITHM_NAME = "AES-256";
    private static final boolean DEBUG = false;
    private static final SecureRandom random = new SecureRandom();

    private AndroidBackup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractAsTar(String backupFilename, String filename, String password) {
        try {
            InputStream in;
            InputStream rawInStream = AndroidBackup.getInputStream(backupFilename);
            InputStream cipherStream = null;
            if (Files.size(Paths.get(backupFilename, new String[0])) == 0L) {
                throw new IllegalStateException("File too small in size");
            }
            String magic = AndroidBackup.readHeaderLine(rawInStream);
            String versionStr = AndroidBackup.readHeaderLine(rawInStream);
            int version = Integer.parseInt(versionStr);
            if (version < 1 || version > 5) {
                throw new IllegalArgumentException("Don't know how to process version " + versionStr);
            }
            String compressed = AndroidBackup.readHeaderLine(rawInStream);
            boolean isCompressed = Integer.parseInt(compressed) == 1;
            String encryptionAlg = AndroidBackup.readHeaderLine(rawInStream);
            boolean isEncrypted = false;
            if (encryptionAlg.equals(ENCRYPTION_ALGORITHM_NAME)) {
                String userSaltHex;
                byte[] userSalt;
                isEncrypted = true;
                if (Cipher.getMaxAllowedKeyLength("AES") < 256) {
                    System.err.println("WARNING: Maximum allowed key-length seems smaller than needed. Please check that unlimited strength cryptography is available, see README.md for details");
                }
                if (password == null || "".equals(password)) {
                    Console console = System.console();
                    if (console != null) {
                        System.err.println("This backup is encrypted, please provide the password");
                        password = new String(console.readPassword("Password: ", new Object[0]));
                    } else {
                        throw new IllegalArgumentException("Backup encrypted but password not specified");
                    }
                }
                if ((userSalt = AndroidBackup.hexToByteArray(userSaltHex = AndroidBackup.readHeaderLine(rawInStream))).length != 64) {
                    throw new IllegalArgumentException("Invalid salt length: " + userSalt.length);
                }
                String ckSaltHex = AndroidBackup.readHeaderLine(rawInStream);
                byte[] ckSalt = AndroidBackup.hexToByteArray(ckSaltHex);
                int rounds = Integer.parseInt(AndroidBackup.readHeaderLine(rawInStream));
                String userIvHex = AndroidBackup.readHeaderLine(rawInStream);
                String masterKeyBlobHex = AndroidBackup.readHeaderLine(rawInStream);
                Cipher c = Cipher.getInstance(ENCRYPTION_MECHANISM);
                SecretKey userKey = AndroidBackup.buildPasswordKey(password, userSalt, rounds, false);
                byte[] IV = AndroidBackup.hexToByteArray(userIvHex);
                IvParameterSpec ivSpec = new IvParameterSpec(IV);
                c.init(2, (Key)new SecretKeySpec(userKey.getEncoded(), "AES"), ivSpec);
                byte[] mkCipher = AndroidBackup.hexToByteArray(masterKeyBlobHex);
                byte[] mkBlob = c.doFinal(mkCipher);
                int offset = 0;
                byte len = mkBlob[offset++];
                IV = Arrays.copyOfRange(mkBlob, offset, offset + len);
                offset += len;
                len = mkBlob[offset++];
                byte[] mk = Arrays.copyOfRange(mkBlob, offset, offset + len);
                offset += len;
                len = mkBlob[offset++];
                byte[] mkChecksum = Arrays.copyOfRange(mkBlob, offset, offset + len);
                boolean useUtf = version >= 2;
                byte[] calculatedCk = AndroidBackup.makeKeyChecksum(mk, ckSalt, rounds, useUtf);
                System.err.printf("Calculated MK checksum (use UTF-8: %s): %s\n", useUtf, AndroidBackup.toHex(calculatedCk));
                if (!Arrays.equals(calculatedCk, mkChecksum)) {
                    System.err.println("Checksum does not match.");
                    calculatedCk = AndroidBackup.makeKeyChecksum(mk, ckSalt, rounds, !useUtf);
                    System.err.printf("Calculated MK checksum (use UTF-8: %s): %s\n", useUtf, AndroidBackup.toHex(calculatedCk));
                }
                if (Arrays.equals(calculatedCk, mkChecksum)) {
                    ivSpec = new IvParameterSpec(IV);
                    c.init(2, (Key)new SecretKeySpec(mk, "AES"), ivSpec);
                    cipherStream = new CipherInputStream(rawInStream, c);
                }
            }
            if (isEncrypted && cipherStream == null) {
                throw new IllegalStateException("Invalid password or master key checksum.");
            }
            double fileSize = new File(backupFilename).length();
            double percentDone = -1.0;
            OutputStream out = null;
            InputStream baseStream = isEncrypted ? cipherStream : rawInStream;
            Inflater inf = null;
            if (isCompressed) {
                inf = new Inflater();
                in = new InflaterInputStream(baseStream, inf);
            } else {
                in = baseStream;
            }
            try {
                int read;
                out = AndroidBackup.getOutputStream(filename);
                byte[] buff = new byte[10240];
                long totalRead = 0L;
                while ((read = in.read(buff)) > 0) {
                    out.write(buff, 0, read);
                    long bytesRead = inf == null ? (totalRead += (long)read) : inf.getBytesRead();
                    double currentPercent = Math.round((double)bytesRead / fileSize * 100.0);
                    if (currentPercent == percentDone) continue;
                    System.err.printf("%.0f%% ", currentPercent);
                    percentDone = currentPercent;
                }
                System.err.printf("\n%d bytes written to %s.\n", totalRead, filename);
            }
            finally {
                in.close();
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void packTar(String tarFilename, String backupFilename, String password, boolean isKitKat) {
        boolean encrypting = password != null && !"".equals(password);
        boolean compressing = true;
        StringBuilder headerbuf = new StringBuilder(1024);
        headerbuf.append(BACKUP_FILE_HEADER_MAGIC);
        headerbuf.append(isKitKat ? 2 : 1);
        headerbuf.append(compressing ? "\n1\n" : "\n0\n");
        OutputStream out = null;
        try {
            int read;
            OutputStream ofstream;
            InputStream in = AndroidBackup.getInputStream(tarFilename);
            OutputStream finalOutput = ofstream = AndroidBackup.getOutputStream(backupFilename);
            if (encrypting) {
                finalOutput = AndroidBackup.emitAesBackupHeader(headerbuf, finalOutput, password, isKitKat);
            } else {
                headerbuf.append("none\n");
            }
            byte[] header = headerbuf.toString().getBytes(StandardCharsets.UTF_8);
            ofstream.write(header);
            if (compressing) {
                Deflater deflater = new Deflater(9);
                finalOutput = new DeflaterOutputStream(finalOutput, deflater, true);
            }
            out = finalOutput;
            byte[] buff = new byte[10240];
            int totalRead = 0;
            while ((read = in.read(buff)) > 0) {
                out.write(buff, 0, read);
                totalRead += read;
            }
            System.err.printf("%d bytes written to %s.\n", totalRead, backupFilename);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static InputStream getInputStream(String filename) throws IOException {
        if (filename.equals("-")) {
            return System.in;
        }
        return new FileInputStream(filename);
    }

    private static OutputStream getOutputStream(String filename) throws IOException {
        if (filename.equals("-")) {
            return System.out;
        }
        return new FileOutputStream(filename);
    }

    private static byte[] randomBytes(int bits) {
        byte[] array = new byte[bits / 8];
        random.nextBytes(array);
        return array;
    }

    private static OutputStream emitAesBackupHeader(StringBuilder headerbuf, OutputStream ofstream, String encryptionPassword, boolean useUtf8) throws Exception {
        byte[] newUserSalt = AndroidBackup.randomBytes(512);
        SecretKey userKey = AndroidBackup.buildPasswordKey(encryptionPassword, newUserSalt, 10000, useUtf8);
        byte[] masterPw = new byte[32];
        random.nextBytes(masterPw);
        byte[] checksumSalt = AndroidBackup.randomBytes(512);
        Cipher c = Cipher.getInstance(ENCRYPTION_MECHANISM);
        SecretKeySpec masterKeySpec = new SecretKeySpec(masterPw, "AES");
        c.init(1, masterKeySpec);
        CipherOutputStream finalOutput = new CipherOutputStream(ofstream, c);
        headerbuf.append(ENCRYPTION_ALGORITHM_NAME);
        headerbuf.append('\n');
        headerbuf.append(AndroidBackup.toHex(newUserSalt));
        headerbuf.append('\n');
        headerbuf.append(AndroidBackup.toHex(checksumSalt));
        headerbuf.append('\n');
        headerbuf.append(10000);
        headerbuf.append('\n');
        Cipher mkC = Cipher.getInstance(ENCRYPTION_MECHANISM);
        mkC.init(1, userKey);
        byte[] IV = mkC.getIV();
        headerbuf.append(AndroidBackup.toHex(IV));
        headerbuf.append('\n');
        IV = c.getIV();
        byte[] mk = masterKeySpec.getEncoded();
        byte[] checksum = AndroidBackup.makeKeyChecksum(masterKeySpec.getEncoded(), checksumSalt, 10000, useUtf8);
        ByteArrayOutputStream blob = new ByteArrayOutputStream(IV.length + mk.length + checksum.length + 3);
        DataOutputStream mkOut = new DataOutputStream(blob);
        mkOut.writeByte(IV.length);
        mkOut.write(IV);
        mkOut.writeByte(mk.length);
        mkOut.write(mk);
        mkOut.writeByte(checksum.length);
        mkOut.write(checksum);
        mkOut.flush();
        byte[] encryptedMk = mkC.doFinal(blob.toByteArray());
        headerbuf.append(AndroidBackup.toHex(encryptedMk));
        headerbuf.append('\n');
        return finalOutput;
    }

    public static String toHex(byte[] bytes) {
        StringBuilder buff = new StringBuilder();
        for (byte b : bytes) {
            buff.append(String.format("%02X", b));
        }
        return buff.toString();
    }

    private static String readHeaderLine(InputStream in) throws IOException {
        int c;
        StringBuilder buffer = new StringBuilder(80);
        while ((c = in.read()) >= 0 && c != 10) {
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    public static byte[] hexToByteArray(String digits) {
        int bytes = digits.length() / 2;
        if (2 * bytes != digits.length()) {
            throw new IllegalArgumentException("Hex string must have an even number of digits");
        }
        byte[] result = new byte[bytes];
        for (int i = 0; i < digits.length(); i += 2) {
            result[i / 2] = (byte)Integer.parseInt(digits.substring(i, i + 2), 16);
        }
        return result;
    }

    public static byte[] makeKeyChecksum(byte[] pwBytes, byte[] salt, int rounds, boolean useUtf8) {
        char[] mkAsChar = new char[pwBytes.length];
        for (int i = 0; i < pwBytes.length; ++i) {
            mkAsChar[i] = (char)pwBytes[i];
        }
        SecretKey checksum = AndroidBackup.buildCharArrayKey(mkAsChar, salt, rounds, useUtf8);
        return checksum.getEncoded();
    }

    public static SecretKey buildCharArrayKey(char[] pwArray, byte[] salt, int rounds, boolean useUtf8) {
        return AndroidBackup.androidPBKDF2(pwArray, salt, rounds, useUtf8);
    }

    public static SecretKey androidPBKDF2(char[] pwArray, byte[] salt, int rounds, boolean useUtf8) {
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
        byte[] pwBytes = useUtf8 ? PBEParametersGenerator.PKCS5PasswordToUTF8Bytes((char[])pwArray) : PBEParametersGenerator.PKCS5PasswordToBytes((char[])pwArray);
        generator.init(pwBytes, salt, rounds);
        KeyParameter params = (KeyParameter)generator.generateDerivedParameters(256);
        return new SecretKeySpec(params.getKey(), "AES");
    }

    private static SecretKey buildPasswordKey(String pw, byte[] salt, int rounds, boolean useUtf8) {
        return AndroidBackup.buildCharArrayKey(pw.toCharArray(), salt, rounds, useUtf8);
    }
}

