hmLoadTopic({
hmKeywords:"automate Beyond Compare,batch file processing,scripts,scripts overview",
hmTitle:"Scripts",
hmDescription:"Beyond Compare provides a script processing feature which allows you to automate routine tasks.  A script is a simple text file containing a list of commands which can control...",
hmPrevLink:"moving_bc_to_another_computer.html",
hmNextLink:"sample_scripts.html",
hmParentLink:"using_bc.html",
hmBreadCrumbs:"<a href=\"using_bc.html\">Using Beyond Compare<\/a>",
hmTitlePath:"Using Beyond Compare > Scripts",
hmHeader:"<h1 class=\"p_Heading1\"><span class=\"f_Heading1\">Scripts<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">Beyond Compare provides a script processing feature which allows you to automate routine tasks.  A script is a simple text file containing a list of commands which can control the program and automatically perform file operations or produce reports.  See <a href=\"scripting_reference.html\" class=\"topiclink\">Scripting Reference<\/a> for a list of all scripting commands.<\/p>\n\r<p class=\"p_Normal\">Scripts run without displaying the usual Beyond Compare user interface, but might require input for certain confirmations.  Scripts essentially manipulate an invisible folder session: file operations require selections, the &quot;display&quot; can be limited with filters, and folders can be &quot;expanded&quot; to recurse into them.  Any folder name argument can be a folder on your system, on the network or a remote service, or the name of an archive file such as .zip, .cab, or Beyond Compare Snapshot file.<\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Running a script<\/span><\/p>\n\r<p class=\"p_Normal\">Specify the filename of the script on the command line with a leading &quot;@&quot; symbol, as in:<\/p>\n\r<p class=\"p_IndentedCode\"><img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/windows.png\"\/> <span class=\"f_CourierFixed\">BCompare.exe @&quot;C:\\<\/span><span class=\"f_CourierFixed\">My Folder<\/span><span class=\"f_CourierFixed\">\\<\/span><span class=\"f_CourierFixed\">My Script<\/span><span class=\"f_CourierFixed\">.txt&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/mac.png\"\/> <img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/linux.png\"\/> <span class=\"f_CourierFixed\">bcompare @&quot;<\/span><span class=\"f_CourierFixed\">My Folder<\/span><span class=\"f_CourierFixed\">\/<\/span><span class=\"f_CourierFixed\">My Script<\/span><span class=\"f_CourierFixed\">&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Creating a script<\/span><\/p>\n\r<p class=\"p_Normal\">Scripts are processed line by line, with a single command per line.  Scripts are not case sensitive, and blank lines and comments (anything after a &quot;#&quot;) are ignored.  Arguments are separated by spaces.  To include a space in an argument, surround the argument with quotes (&quot;).  To continue a long command on a second (or third) line, add an ampersand (&amp;) at the end of every line but the last.<\/p>\n\r<p class=\"p_Normal\">A parameter specified on the command line can be referenced by inserting a percent sign (%) followed by a single number from 1-9.  The script name and command line switches starting with \/ are not included in the 1-9 list.  Given the command line:<\/p>\n\r<p class=\"p_IndentedCode\"><img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/windows.png\"\/> <span class=\"f_CourierFixed\">BCompare.exe @&quot;<\/span><span class=\"f_CourierFixed\">My Script<\/span><span class=\"f_CourierFixed\">.txt&quot; \/silent &quot;<\/span><span class=\"f_CourierFixed\">My Session<\/span><span class=\"f_CourierFixed\">&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">the session named &quot;My Session&quot; can be loaded by adding the following to the script:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load &quot;%1&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">An environmental variable can be inserted by enclosing its name in percent signs.  The character case of the environmental variable must be correct.  The system\'s temporary folder can be loaded by adding the following to the script:<\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_CourierFixed\">load &quot;%TMP%&quot;<\/span><\/p>\n\r<p class=\"p_IndentedCode\"><span class=\"f_IndentedCode\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">There are several dynamic variables that Beyond Compare can fill in at each line of the script.  The %date% variable fills in the current date in the format yyyy-mm-dd.  The %time% variable\'s format depends on your computer\'s regional settings.  The %fn_time% variable outputs the time as hh-mm-ss, which can be used for filenames.<\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Scripting command line switches<\/span><\/p>\n\r<p class=\"p_Normal\"><img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/mac.png\"\/><span class=\"f_Subtitle\"> <img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/linux.png\"\/> <\/span><span class=\"f_NotePrompt\">Note<\/span>  macOS and Linux users should prefix the switches with &quot;-&quot; instead of &quot;\/&quot;.<\/p>\n\r<p class=\"p_Normal\">The command line switches that affect scripting are <span class=\"f_CourierFixed\">\/closescript<\/span>, <span class=\"f_CourierFixed\">\/leftreadonly<\/span>, <span class=\"f_CourierFixed\">\/readonly<\/span>, <span class=\"f_CourierFixed\">\/rightreadonly<\/span>, and <span class=\"f_CourierFixed\">\/silent<\/span>.  Normally, script processing adds an entry on the Task Bar and displays a Scripting Status Window detailing its progress and any errors.  The <span class=\"f_CourierFixed\">\/silent<\/span> switch bypasses the Task Bar entry and Scripting Status Window, allowing Beyond Compare to process the script invisibly.<\/p>\n\r<p class=\"p_Subtitle\"><span class=\"f_Subtitle\">Scripting options<\/span><\/p>\n\r<p class=\"p_Normal\">To change the script processing options, pick <span class=\"f_Command\">Tools &gt; Options<\/span> <img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/options.png\"\/>, switch to the <span class=\"f_Command\">Tweaks<\/span> page, and then scroll to find <span class=\"f_Command\">Scripts<\/span>.  Mark the <span class=\"f_Command\">Beep when finished<\/span> checkbox to have Beyond Compare sound an audible beep when it completes script processing.  This beep can alert you to check and close the Scripting Status window.  <span class=\"f_Command\">Close when finished<\/span> causes Beyond Compare to automatically close its Scripting Status window when it completes script processing.  When used in conjunction with <span class=\"f_Command\">Beep when finished<\/span>, the beep simply tells you the process has completed.<\/p>\n\r<p class=\"p_Normal\">There is also a place to designate a <span class=\"f_Command\">Shared scripts folder<\/span>.  When you provide a script name argument on the command line with no path designation, and there is no file of that name in the current folder, Beyond Compare will look in the <span class=\"f_Command\">Shared scripts folder<\/span> for that script.<\/p>\n\r"
})
