/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli;

import bisq.cli.CurrencyFormat;
import bisq.cli.GrpcClient;
import bisq.cli.Method;
import bisq.cli.opts.ArgumentList;
import bisq.cli.opts.CancelOfferOptionParser;
import bisq.cli.opts.CreateCryptoCurrencyPaymentAcctOptionParser;
import bisq.cli.opts.CreateOfferOptionParser;
import bisq.cli.opts.CreatePaymentAcctOptionParser;
import bisq.cli.opts.EditOfferOptionParser;
import bisq.cli.opts.GetAddressBalanceOptionParser;
import bisq.cli.opts.GetAvgBsqPriceOptionParser;
import bisq.cli.opts.GetBTCMarketPriceOptionParser;
import bisq.cli.opts.GetBalanceOptionParser;
import bisq.cli.opts.GetOffersOptionParser;
import bisq.cli.opts.GetPaymentAcctFormOptionParser;
import bisq.cli.opts.GetTradeOptionParser;
import bisq.cli.opts.GetTradesOptionParser;
import bisq.cli.opts.GetTransactionOptionParser;
import bisq.cli.opts.GetTransactionsOptionParser;
import bisq.cli.opts.OfferIdOptionParser;
import bisq.cli.opts.RegisterDisputeAgentOptionParser;
import bisq.cli.opts.RemoveWalletPasswordOptionParser;
import bisq.cli.opts.SendBsqOptionParser;
import bisq.cli.opts.SendBtcOptionParser;
import bisq.cli.opts.SetTxFeeRateOptionParser;
import bisq.cli.opts.SetWalletPasswordOptionParser;
import bisq.cli.opts.SimpleMethodOptionParser;
import bisq.cli.opts.TakeBsqSwapOfferOptionParser;
import bisq.cli.opts.TakeOfferOptionParser;
import bisq.cli.opts.UnlockWalletOptionParser;
import bisq.cli.opts.VerifyBsqSentToAddressOptionParser;
import bisq.cli.opts.WithdrawFundsOptionParser;
import bisq.cli.table.builder.TableBuilder;
import bisq.cli.table.builder.TableType;
import bisq.proto.grpc.AddressBalanceInfo;
import bisq.proto.grpc.AverageBsqTradePrice;
import bisq.proto.grpc.BalancesInfo;
import bisq.proto.grpc.EditOfferRequest;
import bisq.proto.grpc.GetOfferCategoryReply;
import bisq.proto.grpc.GetTradesRequest;
import bisq.proto.grpc.OfferInfo;
import bisq.proto.grpc.TradeInfo;
import bisq.proto.grpc.TxFeeRateInfo;
import bisq.proto.grpc.TxInfo;
import io.grpc.StatusRuntimeException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.PaymentAccount;
import protobuf.PaymentMethod;

public class CliMain {
    private static final Logger log = LoggerFactory.getLogger(CliMain.class);

    public static void main(String[] args) {
        try {
            CliMain.run(args);
        }
        catch (Throwable t) {
            System.err.println("Error: " + t.getMessage());
            System.exit(1);
        }
    }

    public static void run(String[] args) {
        Method method;
        OptionParser parser = new OptionParser();
        AbstractOptionSpec helpOpt = parser.accepts("help", "Print this help text").forHelp();
        ArgumentAcceptingOptionSpec hostOpt = parser.accepts("host", "rpc server hostname or ip").withRequiredArg().defaultsTo((Object)"localhost", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec portOpt = parser.accepts("port", "rpc server port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)9998, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec passwordOpt = parser.accepts("password", "rpc server password").withRequiredArg();
        OptionSet options = parser.parse(new ArgumentList(args).getCLIArguments());
        List nonOptionArgs = options.nonOptionArguments();
        if (!options.has((OptionSpec)helpOpt) && nonOptionArgs.isEmpty()) {
            CliMain.printHelp(parser, System.err);
            throw new IllegalArgumentException("no method specified");
        }
        if (options.has((OptionSpec)helpOpt) && nonOptionArgs.isEmpty()) {
            CliMain.printHelp(parser, System.out);
            return;
        }
        String host = (String)options.valueOf((OptionSpec)hostOpt);
        Integer port = (Integer)options.valueOf((OptionSpec)portOpt);
        String password = (String)options.valueOf((OptionSpec)passwordOpt);
        if (password == null) {
            throw new IllegalArgumentException("missing required 'password' option");
        }
        String methodName = (String)nonOptionArgs.get(0);
        try {
            method = CliMain.getMethodFromCmd(methodName);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("'%s' is not a supported method", methodName));
        }
        GrpcClient client = new GrpcClient(host, port, password);
        try {
            switch (method) {
                case getversion: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String version = client.getVersion();
                    System.out.println(version);
                    return;
                }
                case getnetwork: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String network = client.getNetwork();
                    System.out.println(network);
                    return;
                }
                case getdaostatus: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    System.out.println(client.getDaoStatus());
                    return;
                }
                case getbalance: {
                    GetBalanceOptionParser opts = new GetBalanceOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String currencyCode = opts.getCurrencyCode();
                    BalancesInfo balances = client.getBalances(currencyCode);
                    switch (currencyCode.toUpperCase()) {
                        case "BSQ": {
                            new TableBuilder(TableType.BSQ_BALANCE_TBL, balances.getBsq()).build().print(System.out);
                            break;
                        }
                        case "BTC": {
                            new TableBuilder(TableType.BTC_BALANCE_TBL, balances.getBtc()).build().print(System.out);
                            break;
                        }
                        default: {
                            System.out.println("BTC");
                            new TableBuilder(TableType.BTC_BALANCE_TBL, balances.getBtc()).build().print(System.out);
                            System.out.println("BSQ");
                            new TableBuilder(TableType.BSQ_BALANCE_TBL, balances.getBsq()).build().print(System.out);
                        }
                    }
                    return;
                }
                case getaddressbalance: {
                    GetAddressBalanceOptionParser opts = new GetAddressBalanceOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String address = opts.getAddress();
                    AddressBalanceInfo addressBalance = client.getAddressBalance(address);
                    new TableBuilder(TableType.ADDRESS_BALANCE_TBL, addressBalance).build().print(System.out);
                    return;
                }
                case getavgbsqprice: {
                    GetAvgBsqPriceOptionParser opts = new GetAvgBsqPriceOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    int days = opts.getDays();
                    AverageBsqTradePrice price = client.getAverageBsqTradePrice(days);
                    System.out.println(String.format("avg %d day btc price: %s    avg %d day usd price: %s", days, price.getBtcPrice(), days, price.getUsdPrice()));
                    return;
                }
                case getbtcprice: {
                    GetBTCMarketPriceOptionParser opts = new GetBTCMarketPriceOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String currencyCode = opts.getCurrencyCode();
                    double price = client.getBtcPrice(currencyCode);
                    System.out.println(CurrencyFormat.formatInternalFiatPrice(price));
                    return;
                }
                case getfundingaddresses: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    List<AddressBalanceInfo> fundingAddresses = client.getFundingAddresses();
                    new TableBuilder(TableType.ADDRESS_BALANCE_TBL, fundingAddresses).build().print(System.out);
                    return;
                }
                case getunusedbsqaddress: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String address = client.getUnusedBsqAddress();
                    System.out.println(address);
                    return;
                }
                case sendbsq: {
                    SendBsqOptionParser opts = new SendBsqOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String address = opts.getAddress();
                    String amount = opts.getAmount();
                    CliMain.verifyStringIsValidDecimal("amount", amount);
                    String txFeeRate = opts.getFeeRate();
                    if (!txFeeRate.isEmpty()) {
                        CliMain.verifyStringIsValidLong("tx-fee-rate", txFeeRate);
                    }
                    TxInfo txInfo = client.sendBsq(address, amount, txFeeRate);
                    System.out.printf("%s bsq sent to %s in tx %s%n", amount, address, txInfo.getTxId());
                    return;
                }
                case sendbtc: {
                    SendBtcOptionParser opts = new SendBtcOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String address = opts.getAddress();
                    String amount = opts.getAmount();
                    CliMain.verifyStringIsValidDecimal("amount", amount);
                    String txFeeRate = opts.getFeeRate();
                    if (!txFeeRate.isEmpty()) {
                        CliMain.verifyStringIsValidLong("tx-fee-rate", txFeeRate);
                    }
                    String memo = opts.getMemo();
                    TxInfo txInfo = client.sendBtc(address, amount, txFeeRate, memo);
                    System.out.printf("%s btc sent to %s in tx %s%n", amount, address, txInfo.getTxId());
                    return;
                }
                case verifybsqsenttoaddress: {
                    VerifyBsqSentToAddressOptionParser opts = new VerifyBsqSentToAddressOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String address = opts.getAddress();
                    String amount = opts.getAmount();
                    CliMain.verifyStringIsValidDecimal("amount", amount);
                    boolean bsqWasSent = client.verifyBsqSentToAddress(address, amount);
                    System.out.printf("%s bsq %s sent to address %s%n", amount, bsqWasSent ? "has been" : "has not been", address);
                    return;
                }
                case gettxfeerate: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    TxFeeRateInfo txFeeRate = client.getTxFeeRate();
                    System.out.println(CurrencyFormat.formatTxFeeRateInfo(txFeeRate));
                    return;
                }
                case settxfeerate: {
                    SetTxFeeRateOptionParser opts = new SetTxFeeRateOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    TxFeeRateInfo txFeeRate = client.setTxFeeRate(CliMain.toLong(opts.getFeeRate()));
                    System.out.println(CurrencyFormat.formatTxFeeRateInfo(txFeeRate));
                    return;
                }
                case unsettxfeerate: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    TxFeeRateInfo txFeeRate = client.unsetTxFeeRate();
                    System.out.println(CurrencyFormat.formatTxFeeRateInfo(txFeeRate));
                    return;
                }
                case gettransactions: {
                    GetTransactionsOptionParser opts = new GetTransactionsOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    List<TxInfo> txs = client.getTransactions();
                    new TableBuilder(TableType.TRANSACTION_TBL, txs).build().print(System.out);
                    return;
                }
                case gettransaction: {
                    GetTransactionOptionParser opts = new GetTransactionOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String txId = opts.getTxId();
                    TxInfo tx = client.getTransaction(txId);
                    new TableBuilder(TableType.TRANSACTION_TBL, tx).build().print(System.out);
                    return;
                }
                case createoffer: {
                    CreateOfferOptionParser opts = new CreateOfferOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    boolean isSwap = opts.getIsSwap();
                    String paymentAcctId = opts.getPaymentAccountId();
                    String direction = opts.getDirection();
                    String currencyCode = opts.getCurrencyCode();
                    long amount = CurrencyFormat.toSatoshis(opts.getAmount());
                    long minAmount = CurrencyFormat.toSatoshis(opts.getMinAmount());
                    boolean useMarketBasedPrice = opts.isUsingMktPriceMargin();
                    String fixedPrice = opts.getFixedPrice();
                    double marketPriceMarginPct = opts.getMktPriceMarginPct();
                    double securityDepositPct = isSwap ? 0.0 : opts.getSecurityDepositPct();
                    String makerFeeCurrencyCode = opts.getMakerFeeCurrencyCode();
                    String triggerPrice = "0";
                    OfferInfo offer = isSwap ? client.createBsqSwapOffer(direction, amount, minAmount, fixedPrice) : client.createOffer(direction, currencyCode, amount, minAmount, useMarketBasedPrice, fixedPrice, marketPriceMarginPct, securityDepositPct, paymentAcctId, makerFeeCurrencyCode, triggerPrice);
                    new TableBuilder(TableType.OFFER_TBL, offer).build().print(System.out);
                    return;
                }
                case editoffer: {
                    OfferIdOptionParser offerIdOpt = new OfferIdOptionParser(args, true).parse();
                    if (offerIdOpt.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String offerId = offerIdOpt.getOfferId();
                    GetOfferCategoryReply.OfferCategory offerCategory = client.getMyOfferCategory(offerId);
                    if (offerCategory.equals((Object)GetOfferCategoryReply.OfferCategory.BSQ_SWAP)) {
                        throw new IllegalStateException("bsq swap offers cannot be edited, but you may cancel them without forfeiting any funds");
                    }
                    EditOfferOptionParser opts = new EditOfferOptionParser(args).parse();
                    String fixedPrice = opts.getFixedPrice();
                    boolean isUsingMktPriceMargin = opts.isUsingMktPriceMargin();
                    double marketPriceMarginPct = opts.getMktPriceMarginPct();
                    String triggerPrice = opts.getTriggerPrice();
                    int enable = opts.getEnableAsSignedInt();
                    EditOfferRequest.EditType editOfferType = opts.getOfferEditType();
                    client.editOffer(offerId, fixedPrice, isUsingMktPriceMargin, marketPriceMarginPct, triggerPrice, enable, editOfferType);
                    System.out.println("offer has been edited");
                    return;
                }
                case canceloffer: {
                    CancelOfferOptionParser opts = new CancelOfferOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String offerId = opts.getOfferId();
                    client.cancelOffer(offerId);
                    System.out.println("offer canceled and removed from offer book");
                    return;
                }
                case getoffer: {
                    OfferIdOptionParser opts = new OfferIdOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String offerId = opts.getOfferId();
                    OfferInfo offer = client.getOffer(offerId);
                    new TableBuilder(TableType.OFFER_TBL, offer).build().print(System.out);
                    return;
                }
                case getmyoffer: {
                    OfferIdOptionParser opts = new OfferIdOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String offerId = opts.getOfferId();
                    OfferInfo offer = client.getMyOffer(offerId);
                    new TableBuilder(TableType.OFFER_TBL, offer).build().print(System.out);
                    return;
                }
                case getoffers: {
                    String currencyCode;
                    GetOffersOptionParser opts = new GetOffersOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String direction = opts.getDirection();
                    List<OfferInfo> offers = client.getOffers(direction, currencyCode = opts.getCurrencyCode());
                    if (offers.isEmpty()) {
                        System.out.printf("no %s %s offers found%n", direction, currencyCode);
                    } else {
                        new TableBuilder(TableType.OFFER_TBL, offers).build().print(System.out);
                    }
                    return;
                }
                case getmyoffers: {
                    String currencyCode;
                    GetOffersOptionParser opts = new GetOffersOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String direction = opts.getDirection();
                    List<OfferInfo> offers = client.getMyOffers(direction, currencyCode = opts.getCurrencyCode());
                    if (offers.isEmpty()) {
                        System.out.printf("no %s %s offers found%n", direction, currencyCode);
                    } else {
                        new TableBuilder(TableType.OFFER_TBL, offers).build().print(System.out);
                    }
                    return;
                }
                case takeoffer: {
                    TradeInfo trade;
                    OfferIdOptionParser offerIdOpt = new OfferIdOptionParser(args, true).parse();
                    if (offerIdOpt.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String offerId = offerIdOpt.getOfferId();
                    GetOfferCategoryReply.OfferCategory offerCategory = client.getAvailableOfferCategory(offerId);
                    if (offerCategory.equals((Object)GetOfferCategoryReply.OfferCategory.BSQ_SWAP)) {
                        TakeBsqSwapOfferOptionParser opts = new TakeBsqSwapOfferOptionParser(args).parse();
                        long amount = CurrencyFormat.toSatoshis(opts.getAmount());
                        trade = client.takeBsqSwapOffer(offerId, amount);
                    } else {
                        TakeOfferOptionParser opts = new TakeOfferOptionParser(args).parse();
                        long amount = CurrencyFormat.toSatoshis(opts.getAmount());
                        String paymentAccountId = opts.getPaymentAccountId();
                        String takerFeeCurrencyCode = opts.getTakerFeeCurrencyCode();
                        trade = client.takeOffer(offerId, paymentAccountId, takerFeeCurrencyCode, amount);
                    }
                    System.out.printf("trade %s successfully taken%n", trade.getTradeId());
                    return;
                }
                case gettrade: {
                    GetTradeOptionParser opts = new GetTradeOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String tradeId = opts.getTradeId();
                    boolean showContract = opts.getShowContract();
                    TradeInfo trade = client.getTrade(tradeId);
                    if (showContract) {
                        System.out.println(trade.getContractAsJson());
                    } else {
                        new TableBuilder(TableType.TRADE_DETAIL_TBL, trade).build().print(System.out);
                    }
                    return;
                }
                case gettrades: {
                    List<TradeInfo> trades;
                    GetTradesOptionParser opts = new GetTradesOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    GetTradesRequest.Category category = opts.getCategory();
                    List<TradeInfo> list = trades = category.equals((Object)GetTradesRequest.Category.OPEN) ? client.getOpenTrades() : client.getTradeHistory(category);
                    if (trades.isEmpty()) {
                        System.out.printf("no %s trades found%n", category.name().toLowerCase());
                    } else {
                        TableType tableType = category.equals((Object)GetTradesRequest.Category.OPEN) ? TableType.OPEN_TRADES_TBL : (category.equals((Object)GetTradesRequest.Category.CLOSED) ? TableType.CLOSED_TRADES_TBL : TableType.FAILED_TRADES_TBL);
                        new TableBuilder(tableType, trades).build().print(System.out);
                    }
                    return;
                }
                case confirmpaymentstarted: {
                    GetTradeOptionParser opts = new GetTradeOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String tradeId = opts.getTradeId();
                    client.confirmPaymentStarted(tradeId);
                    System.out.printf("trade %s payment started message sent%n", tradeId);
                    return;
                }
                case confirmpaymentstartedxmr: {
                    GetTradeOptionParser opts = new GetTradeOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String tradeId = opts.getTradeId();
                    String txId = opts.getTxId();
                    String txKey = opts.getTxKey();
                    client.confirmPaymentStartedXmr(tradeId, txId, txKey);
                    System.out.printf("trade %s payment started message sent%n", tradeId);
                    return;
                }
                case confirmpaymentreceived: {
                    GetTradeOptionParser opts = new GetTradeOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String tradeId = opts.getTradeId();
                    client.confirmPaymentReceived(tradeId);
                    System.out.printf("trade %s payment received message sent%n", tradeId);
                    return;
                }
                case closetrade: {
                    GetTradeOptionParser opts = new GetTradeOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String tradeId = opts.getTradeId();
                    client.closeTrade(tradeId);
                    System.out.printf("trade %s is closed%n", tradeId);
                    return;
                }
                case withdrawfunds: {
                    WithdrawFundsOptionParser opts = new WithdrawFundsOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String tradeId = opts.getTradeId();
                    String address = opts.getAddress();
                    String memo = opts.getMemo();
                    client.withdrawFunds(tradeId, address, memo);
                    System.out.printf("trade %s funds sent to btc address %s%n", tradeId, address);
                    return;
                }
                case getpaymentmethods: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    List<PaymentMethod> paymentMethods = client.getPaymentMethods();
                    paymentMethods.forEach(p -> System.out.println(p.getId()));
                    return;
                }
                case failtrade: {
                    GetTradeOptionParser opts = new GetTradeOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String tradeId = opts.getTradeId();
                    client.failTrade(tradeId);
                    System.out.printf("open trade %s changed to failed trade%n", tradeId);
                    return;
                }
                case unfailtrade: {
                    GetTradeOptionParser opts = new GetTradeOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String tradeId = opts.getTradeId();
                    client.unFailTrade(tradeId);
                    System.out.printf("failed trade %s changed to open trade%n", tradeId);
                    return;
                }
                case getpaymentacctform: {
                    GetPaymentAcctFormOptionParser opts = new GetPaymentAcctFormOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String paymentMethodId = opts.getPaymentMethodId();
                    String jsonString = client.getPaymentAcctFormAsJson(paymentMethodId);
                    File jsonFile = CliMain.saveFileToDisk(paymentMethodId.toLowerCase(), ".json", jsonString);
                    System.out.printf("payment account form %s%nsaved to %s%n", jsonString, jsonFile.getAbsolutePath());
                    System.out.println("Edit the file, and use as the argument to a 'createpaymentacct' command.");
                    return;
                }
                case createpaymentacct: {
                    String jsonString;
                    CreatePaymentAcctOptionParser opts = new CreatePaymentAcctOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    Path paymentAccountForm = opts.getPaymentAcctForm();
                    try {
                        jsonString = new String(Files.readAllBytes(paymentAccountForm));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(String.format("could not read %s", paymentAccountForm));
                    }
                    PaymentAccount paymentAccount = client.createPaymentAccount(jsonString);
                    System.out.println("payment account saved");
                    new TableBuilder(TableType.PAYMENT_ACCOUNT_TBL, paymentAccount).build().print(System.out);
                    return;
                }
                case createcryptopaymentacct: {
                    CreateCryptoCurrencyPaymentAcctOptionParser opts = new CreateCryptoCurrencyPaymentAcctOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String accountName = opts.getAccountName();
                    String currencyCode = opts.getCurrencyCode();
                    String address = opts.getAddress();
                    boolean isTradeInstant = opts.getIsTradeInstant();
                    PaymentAccount paymentAccount = client.createCryptoCurrencyPaymentAccount(accountName, currencyCode, address, isTradeInstant);
                    System.out.println("payment account saved");
                    new TableBuilder(TableType.PAYMENT_ACCOUNT_TBL, paymentAccount).build().print(System.out);
                    return;
                }
                case getpaymentaccts: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    List<PaymentAccount> paymentAccounts = client.getPaymentAccounts();
                    if (paymentAccounts.size() > 0) {
                        new TableBuilder(TableType.PAYMENT_ACCOUNT_TBL, paymentAccounts).build().print(System.out);
                    } else {
                        System.out.println("no payment accounts are saved");
                    }
                    return;
                }
                case lockwallet: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    client.lockWallet();
                    System.out.println("wallet locked");
                    return;
                }
                case unlockwallet: {
                    UnlockWalletOptionParser opts = new UnlockWalletOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String walletPassword = opts.getPassword();
                    long timeout = opts.getUnlockTimeout();
                    client.unlockWallet(walletPassword, timeout);
                    System.out.println("wallet unlocked");
                    return;
                }
                case removewalletpassword: {
                    RemoveWalletPasswordOptionParser opts = new RemoveWalletPasswordOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String walletPassword = opts.getPassword();
                    client.removeWalletPassword(walletPassword);
                    System.out.println("wallet decrypted");
                    return;
                }
                case setwalletpassword: {
                    SetWalletPasswordOptionParser opts = new SetWalletPasswordOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String walletPassword = opts.getPassword();
                    String newWalletPassword = opts.getNewPassword();
                    client.setWalletPassword(walletPassword, newWalletPassword);
                    System.out.println("wallet encrypted" + (!newWalletPassword.isEmpty() ? " with new password" : ""));
                    return;
                }
                case registerdisputeagent: {
                    RegisterDisputeAgentOptionParser opts = new RegisterDisputeAgentOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String disputeAgentType = opts.getDisputeAgentType();
                    String registrationKey = opts.getRegistrationKey();
                    client.registerDisputeAgent(disputeAgentType, registrationKey);
                    System.out.println(disputeAgentType + " registered");
                    return;
                }
                case stop: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    client.stopServer();
                    System.out.println("server shutdown signal received");
                    return;
                }
            }
            throw new RuntimeException(String.format("unhandled method '%s'", new Object[]{method}));
        }
        catch (StatusRuntimeException ex) {
            String message = ex.getMessage().replaceFirst("^[A-Z_]+: ", "");
            if (message.equals("io exception")) {
                throw new RuntimeException(message + ", server may not be running", ex);
            }
            throw new RuntimeException(message, ex);
        }
    }

    private static Method getMethodFromCmd(String methodName) {
        return Method.valueOf(methodName.toLowerCase());
    }

    private static void verifyStringIsValidDecimal(String optionLabel, String optionValue) {
        try {
            Double.parseDouble(optionValue);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("--%s=%s, '%s' is not a number", optionLabel, optionValue, optionValue));
        }
    }

    private static void verifyStringIsValidLong(String optionLabel, String optionValue) {
        try {
            Long.parseLong(optionValue);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("--%s=%s, '%s' is not a number", optionLabel, optionValue, optionValue));
        }
    }

    private static long toLong(String param) {
        try {
            return Long.parseLong(param);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("'%s' is not a number", param));
        }
    }

    private static File saveFileToDisk(String prefix, String suffix, String text) {
        String timestamp = Long.toUnsignedString(new Date().getTime());
        String relativeFileName = prefix + "_" + timestamp + suffix;
        try {
            Path path = Paths.get(relativeFileName, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                try (PrintWriter out = new PrintWriter(path.toString());){
                    out.println(text);
                }
                return path.toAbsolutePath().toFile();
            }
            throw new IllegalStateException(String.format("could not overwrite existing file '%s'", relativeFileName));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(String.format("could not create file '%s'", relativeFileName));
        }
    }

    private static void printHelp(OptionParser parser, PrintStream stream) {
        try {
            stream.println("Bisq RPC Client");
            stream.println();
            stream.println("Usage: bisq-cli [options] <method> [params]");
            stream.println();
            parser.printHelpOn((OutputStream)stream);
            stream.println();
            String rowFormat = "%-25s%-52s%s%n";
            stream.format(rowFormat, "Method", "Params", "Description");
            stream.format(rowFormat, "------", "------", "------------");
            stream.format(rowFormat, Method.getversion.name(), "", "Get server version");
            stream.println();
            stream.format(rowFormat, Method.getnetwork.name(), "", "Get BTC network:  mainnet, testnet3, or regtest");
            stream.println();
            stream.format(rowFormat, Method.getdaostatus.name(), "", "Get DAO synchronized status:  true or false");
            stream.println();
            stream.format(rowFormat, Method.getbalance.name(), "[--currency-code=<bsq|btc>]", "Get server wallet balances");
            stream.println();
            stream.format(rowFormat, Method.getaddressbalance.name(), "--address=<btc-address>", "Get server wallet address balance");
            stream.println();
            stream.format(rowFormat, Method.getavgbsqprice.name(), "--days=<days>", "Get volume weighted average bsq trade price");
            stream.println();
            stream.format(rowFormat, Method.getbtcprice.name(), "--currency-code=<currency-code>", "Get current market btc price");
            stream.println();
            stream.format(rowFormat, Method.getfundingaddresses.name(), "", "Get BTC funding addresses");
            stream.println();
            stream.format(rowFormat, Method.getunusedbsqaddress.name(), "", "Get unused BSQ address");
            stream.println();
            stream.format(rowFormat, Method.sendbsq.name(), "--address=<bsq-address> --amount=<bsq-amount>  \\", "Send BSQ");
            stream.format(rowFormat, "", "[--tx-fee-rate=<sats/byte>]", "");
            stream.println();
            stream.format(rowFormat, Method.sendbtc.name(), "--address=<btc-address> --amount=<btc-amount> \\", "Send BTC");
            stream.format(rowFormat, "", "[--tx-fee-rate=<sats/byte>]", "");
            stream.format(rowFormat, "", "[--memo=<\"memo\">]", "");
            stream.println();
            stream.format(rowFormat, Method.verifybsqsenttoaddress.name(), "--address=<bsq-address> --amount=<bsq-amount>", "Verify amount was sent to BSQ wallet address");
            stream.println();
            stream.format(rowFormat, Method.gettxfeerate.name(), "", "Get current tx fee rate in sats/byte");
            stream.println();
            stream.format(rowFormat, Method.settxfeerate.name(), "--tx-fee-rate=<sats/byte>", "Set custom tx fee rate in sats/byte");
            stream.println();
            stream.format(rowFormat, Method.unsettxfeerate.name(), "", "Unset custom tx fee rate");
            stream.println();
            stream.format(rowFormat, Method.gettransactions.name(), "", "Get transactions");
            stream.println();
            stream.format(rowFormat, Method.gettransaction.name(), "--transaction-id=<transaction-id>", "Get transaction with id");
            stream.println();
            stream.format(rowFormat, Method.createoffer.name(), "--payment-account=<payment-account-id> \\", "Create and place an offer");
            stream.format(rowFormat, "", "--direction=<buy|sell> \\", "");
            stream.format(rowFormat, "", "--currency-code=<currency-code> \\", "");
            stream.format(rowFormat, "", "--amount=<btc-amount> \\", "");
            stream.format(rowFormat, "", "[--min-amount=<min-btc-amount>] \\", "");
            stream.format(rowFormat, "", "--fixed-price=<price> | --market-price-margin=<percent> \\", "");
            stream.format(rowFormat, "", "--security-deposit=<percent> \\", "");
            stream.format(rowFormat, "", "[--fee-currency=<bsq|btc>]", "");
            stream.format(rowFormat, "", "[--trigger-price=<price>]", "");
            stream.format(rowFormat, "", "[--swap=<true|false>]", "");
            stream.println();
            stream.format(rowFormat, Method.editoffer.name(), "--offer-id=<offer-id> \\", "Edit offer with id");
            stream.format(rowFormat, "", "[--fixed-price=<price>] \\", "");
            stream.format(rowFormat, "", "[--market-price-margin=<percent>] \\", "");
            stream.format(rowFormat, "", "[--trigger-price=<price>] \\", "");
            stream.format(rowFormat, "", "[--enabled=<true|false>]", "");
            stream.println();
            stream.format(rowFormat, Method.canceloffer.name(), "--offer-id=<offer-id>", "Cancel offer with id");
            stream.println();
            stream.format(rowFormat, Method.getoffer.name(), "--offer-id=<offer-id>", "Get current offer with id");
            stream.println();
            stream.format(rowFormat, Method.getmyoffer.name(), "--offer-id=<offer-id>", "Get my current offer with id");
            stream.println();
            stream.format(rowFormat, Method.getoffers.name(), "--direction=<buy|sell> \\", "Get current offers");
            stream.format(rowFormat, "", "--currency-code=<currency-code>", "");
            stream.println();
            stream.format(rowFormat, Method.getmyoffers.name(), "--direction=<buy|sell> \\", "Get my current offers");
            stream.format(rowFormat, "", "--currency-code=<currency-code>", "");
            stream.println();
            stream.format(rowFormat, Method.takeoffer.name(), "--offer-id=<offer-id> \\", "Take offer with id");
            stream.format(rowFormat, "", "[--payment-account=<payment-account-id>]", "");
            stream.format(rowFormat, "", "[--fee-currency=<btc|bsq>]", "");
            stream.format(rowFormat, "", "[--amount=<min-btc-amount >= amount <= btc-amount>]", "");
            stream.println();
            stream.format(rowFormat, Method.gettrade.name(), "--trade-id=<trade-id> \\", "Get trade summary or full contract");
            stream.format(rowFormat, "", "[--show-contract=<true|false>]", "");
            stream.println();
            stream.format(rowFormat, Method.gettrades.name(), "[--category=<open|closed|failed>]", "Get open (default), closed, or failed trades");
            stream.println();
            stream.format(rowFormat, Method.confirmpaymentstarted.name(), "--trade-id=<trade-id>", "Confirm payment started");
            stream.println();
            stream.format(rowFormat, Method.confirmpaymentreceived.name(), "--trade-id=<trade-id>", "Confirm payment received");
            stream.println();
            stream.format(rowFormat, Method.closetrade.name(), "--trade-id=<trade-id>", "Close completed trade");
            stream.println();
            stream.format(rowFormat, Method.withdrawfunds.name(), "--trade-id=<trade-id> --address=<btc-address> \\", "Withdraw received trade funds to external wallet address");
            stream.format(rowFormat, "", "[--memo=<\"memo\">]", "");
            stream.println();
            stream.format(rowFormat, Method.failtrade.name(), "--trade-id=<trade-id>", "Change open trade to failed trade");
            stream.println();
            stream.format(rowFormat, Method.unfailtrade.name(), "--trade-id=<trade-id>", "Change failed trade to open trade");
            stream.println();
            stream.format(rowFormat, Method.getpaymentmethods.name(), "", "Get list of supported payment account method ids");
            stream.println();
            stream.format(rowFormat, Method.getpaymentacctform.name(), "--payment-method-id=<payment-method-id>", "Get a new payment account form");
            stream.println();
            stream.format(rowFormat, Method.createpaymentacct.name(), "--payment-account-form=<path>", "Create a new payment account");
            stream.println();
            stream.format(rowFormat, Method.createcryptopaymentacct.name(), "--account-name=<name> \\", "Create a new cryptocurrency payment account");
            stream.format(rowFormat, "", "--currency-code=<bsq> \\", "");
            stream.format(rowFormat, "", "--address=<bsq-address>", "");
            stream.format(rowFormat, "", "--trade-instant=<true|false>", "");
            stream.println();
            stream.format(rowFormat, Method.getpaymentaccts.name(), "", "Get user payment accounts");
            stream.println();
            stream.format(rowFormat, Method.lockwallet.name(), "", "Remove wallet password from memory, locking the wallet");
            stream.println();
            stream.format(rowFormat, Method.unlockwallet.name(), "--wallet-password=<password> --timeout=<seconds>", "Store wallet password in memory for timeout seconds");
            stream.println();
            stream.format(rowFormat, Method.setwalletpassword.name(), "--wallet-password=<password> \\", "Encrypt wallet with password, or set new password on encrypted wallet");
            stream.format(rowFormat, "", "[--new-wallet-password=<new-password>]", "");
            stream.println();
            stream.format(rowFormat, Method.stop.name(), "", "Shut down the server");
            stream.println();
            stream.println("Method Help Usage: bisq-cli [options] <method> --help");
            stream.println();
        }
        catch (IOException ex) {
            ex.printStackTrace(stream);
        }
    }
}

