/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli;

import bisq.proto.grpc.TxFeeRateInfo;
import com.google.common.annotations.VisibleForTesting;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

@VisibleForTesting
public class CurrencyFormat {
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
    private static final NumberFormat US_LOCALE_NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);
    private static final DecimalFormat INTERNAL_FIAT_DECIMAL_FORMAT = new DecimalFormat("##############0.0000");
    static final BigDecimal SATOSHI_DIVISOR = new BigDecimal(100000000);
    static final DecimalFormat SATOSHI_FORMAT = new DecimalFormat("###,##0.00000000", DECIMAL_FORMAT_SYMBOLS);
    static final DecimalFormat BTC_FORMAT = new DecimalFormat("###,##0.########", DECIMAL_FORMAT_SYMBOLS);
    static final DecimalFormat BTC_TX_FEE_FORMAT = new DecimalFormat("###,###,##0", DECIMAL_FORMAT_SYMBOLS);
    static final BigDecimal BSQ_SATOSHI_DIVISOR = new BigDecimal(100);
    static final DecimalFormat BSQ_FORMAT = new DecimalFormat("###,###,###,##0.00", DECIMAL_FORMAT_SYMBOLS);

    public static String formatSatoshis(String sats) {
        return SATOSHI_FORMAT.format(new BigDecimal(sats).divide(SATOSHI_DIVISOR));
    }

    public static String formatSatoshis(long sats) {
        return SATOSHI_FORMAT.format(new BigDecimal(sats).divide(SATOSHI_DIVISOR));
    }

    public static String formatBtc(long sats) {
        return BTC_FORMAT.format(new BigDecimal(sats).divide(SATOSHI_DIVISOR));
    }

    public static String formatBsq(long sats) {
        return BSQ_FORMAT.format(new BigDecimal(sats).divide(BSQ_SATOSHI_DIVISOR));
    }

    public static String formatTxFeeRateInfo(TxFeeRateInfo txFeeRateInfo) {
        if (txFeeRateInfo.getUseCustomTxFeeRate()) {
            return String.format("custom tx fee rate: %s sats/byte, network rate: %s sats/byte, min network rate: %s sats/byte", CurrencyFormat.formatFeeSatoshis(txFeeRateInfo.getCustomTxFeeRate()), CurrencyFormat.formatFeeSatoshis(txFeeRateInfo.getFeeServiceRate()), CurrencyFormat.formatFeeSatoshis(txFeeRateInfo.getMinFeeServiceRate()));
        }
        return String.format("tx fee rate: %s sats/byte, min tx fee rate: %s sats/byte", CurrencyFormat.formatFeeSatoshis(txFeeRateInfo.getFeeServiceRate()), CurrencyFormat.formatFeeSatoshis(txFeeRateInfo.getMinFeeServiceRate()));
    }

    public static String formatInternalFiatPrice(BigDecimal price) {
        INTERNAL_FIAT_DECIMAL_FORMAT.setMinimumFractionDigits(4);
        INTERNAL_FIAT_DECIMAL_FORMAT.setMaximumFractionDigits(4);
        return INTERNAL_FIAT_DECIMAL_FORMAT.format(price);
    }

    public static String formatInternalFiatPrice(double price) {
        US_LOCALE_NUMBER_FORMAT.setMinimumFractionDigits(4);
        US_LOCALE_NUMBER_FORMAT.setMaximumFractionDigits(4);
        return US_LOCALE_NUMBER_FORMAT.format(price);
    }

    public static String formatPrice(long price) {
        US_LOCALE_NUMBER_FORMAT.setMinimumFractionDigits(4);
        US_LOCALE_NUMBER_FORMAT.setMaximumFractionDigits(4);
        US_LOCALE_NUMBER_FORMAT.setRoundingMode(RoundingMode.UNNECESSARY);
        return US_LOCALE_NUMBER_FORMAT.format((double)price / 10000.0);
    }

    public static String formatFiatVolume(long volume) {
        US_LOCALE_NUMBER_FORMAT.setMinimumFractionDigits(0);
        US_LOCALE_NUMBER_FORMAT.setMaximumFractionDigits(0);
        US_LOCALE_NUMBER_FORMAT.setRoundingMode(RoundingMode.HALF_UP);
        return US_LOCALE_NUMBER_FORMAT.format((double)volume / 10000.0);
    }

    public static long toSatoshis(String btc) {
        if (btc.startsWith("-")) {
            throw new IllegalArgumentException(String.format("'%s' is not a positive number", btc));
        }
        try {
            return new BigDecimal(btc).multiply(SATOSHI_DIVISOR).longValue();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("'%s' is not a number", btc));
        }
    }

    public static String formatFeeSatoshis(long sats) {
        return BTC_TX_FEE_FORMAT.format(BigDecimal.valueOf(sats));
    }
}

