/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli;

import bisq.cli.GrpcStubs;
import bisq.cli.Method;
import bisq.cli.request.OffersServiceRequest;
import bisq.cli.request.PaymentAccountsServiceRequest;
import bisq.cli.request.TradesServiceRequest;
import bisq.cli.request.WalletsServiceRequest;
import bisq.proto.grpc.AddressBalanceInfo;
import bisq.proto.grpc.AverageBsqTradePrice;
import bisq.proto.grpc.BalancesInfo;
import bisq.proto.grpc.BsqBalanceInfo;
import bisq.proto.grpc.BtcBalanceInfo;
import bisq.proto.grpc.EditOfferRequest;
import bisq.proto.grpc.GetAverageBsqTradePriceRequest;
import bisq.proto.grpc.GetMethodHelpRequest;
import bisq.proto.grpc.GetOfferCategoryReply;
import bisq.proto.grpc.GetTradesRequest;
import bisq.proto.grpc.GetVersionRequest;
import bisq.proto.grpc.OfferInfo;
import bisq.proto.grpc.RegisterDisputeAgentRequest;
import bisq.proto.grpc.StopRequest;
import bisq.proto.grpc.TradeInfo;
import bisq.proto.grpc.TxFeeRateInfo;
import bisq.proto.grpc.TxInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.PaymentAccount;
import protobuf.PaymentMethod;

public final class GrpcClient {
    private static final Logger log = LoggerFactory.getLogger(GrpcClient.class);
    private final GrpcStubs grpcStubs;
    private final OffersServiceRequest offersServiceRequest;
    private final TradesServiceRequest tradesServiceRequest;
    private final WalletsServiceRequest walletsServiceRequest;
    private final PaymentAccountsServiceRequest paymentAccountsServiceRequest;

    public GrpcClient(String apiHost, int apiPort, String apiPassword) {
        this.grpcStubs = new GrpcStubs(apiHost, apiPort, apiPassword);
        this.offersServiceRequest = new OffersServiceRequest(this.grpcStubs);
        this.tradesServiceRequest = new TradesServiceRequest(this.grpcStubs);
        this.walletsServiceRequest = new WalletsServiceRequest(this.grpcStubs);
        this.paymentAccountsServiceRequest = new PaymentAccountsServiceRequest(this.grpcStubs);
    }

    public String getVersion() {
        GetVersionRequest request = GetVersionRequest.newBuilder().build();
        return this.grpcStubs.versionService.getVersion(request).getVersion();
    }

    public String getNetwork() {
        return this.walletsServiceRequest.getNetwork();
    }

    public boolean getDaoStatus() {
        return this.walletsServiceRequest.getDaoStatus();
    }

    public BalancesInfo getBalances() {
        return this.walletsServiceRequest.getBalances();
    }

    public BsqBalanceInfo getBsqBalances() {
        return this.walletsServiceRequest.getBsqBalances();
    }

    public BtcBalanceInfo getBtcBalances() {
        return this.walletsServiceRequest.getBtcBalances();
    }

    public BalancesInfo getBalances(String currencyCode) {
        return this.walletsServiceRequest.getBalances(currencyCode);
    }

    public AddressBalanceInfo getAddressBalance(String address) {
        return this.walletsServiceRequest.getAddressBalance(address);
    }

    public AverageBsqTradePrice getAverageBsqTradePrice(int days) {
        GetAverageBsqTradePriceRequest request = GetAverageBsqTradePriceRequest.newBuilder().setDays(days).build();
        return this.grpcStubs.priceService.getAverageBsqTradePrice(request).getPrice();
    }

    public double getBtcPrice(String currencyCode) {
        return this.walletsServiceRequest.getBtcPrice(currencyCode);
    }

    public List<AddressBalanceInfo> getFundingAddresses() {
        return this.walletsServiceRequest.getFundingAddresses();
    }

    public String getUnusedBsqAddress() {
        return this.walletsServiceRequest.getUnusedBsqAddress();
    }

    public String getUnusedBtcAddress() {
        return this.walletsServiceRequest.getUnusedBtcAddress();
    }

    public TxInfo sendBsq(String address, String amount, String txFeeRate) {
        return this.walletsServiceRequest.sendBsq(address, amount, txFeeRate);
    }

    public TxInfo sendBtc(String address, String amount, String txFeeRate, String memo) {
        return this.walletsServiceRequest.sendBtc(address, amount, txFeeRate, memo);
    }

    public boolean verifyBsqSentToAddress(String address, String amount) {
        return this.walletsServiceRequest.verifyBsqSentToAddress(address, amount);
    }

    public TxFeeRateInfo getTxFeeRate() {
        return this.walletsServiceRequest.getTxFeeRate();
    }

    public TxFeeRateInfo setTxFeeRate(long txFeeRate) {
        return this.walletsServiceRequest.setTxFeeRate(txFeeRate);
    }

    public TxFeeRateInfo unsetTxFeeRate() {
        return this.walletsServiceRequest.unsetTxFeeRate();
    }

    public List<TxInfo> getTransactions() {
        return this.walletsServiceRequest.getTransactions();
    }

    public TxInfo getTransaction(String txId) {
        return this.walletsServiceRequest.getTransaction(txId);
    }

    public GetOfferCategoryReply.OfferCategory getAvailableOfferCategory(String offerId) {
        return this.offersServiceRequest.getAvailableOfferCategory(offerId);
    }

    public GetOfferCategoryReply.OfferCategory getMyOfferCategory(String offerId) {
        return this.offersServiceRequest.getMyOfferCategory(offerId);
    }

    public OfferInfo createBsqSwapOffer(String direction, long amount, long minAmount, String fixedPrice) {
        return this.offersServiceRequest.createBsqSwapOffer(direction, amount, minAmount, fixedPrice);
    }

    public OfferInfo createFixedPricedOffer(String direction, String currencyCode, long amount, long minAmount, String fixedPrice, double securityDepositPct, String paymentAcctId, String makerFeeCurrencyCode) {
        return this.offersServiceRequest.createOffer(direction, currencyCode, amount, minAmount, false, fixedPrice, 0.0, securityDepositPct, paymentAcctId, makerFeeCurrencyCode, "0");
    }

    public OfferInfo createMarketBasedPricedOffer(String direction, String currencyCode, long amount, long minAmount, double marketPriceMarginPct, double securityDepositPct, String paymentAcctId, String makerFeeCurrencyCode, String triggerPrice) {
        return this.offersServiceRequest.createOffer(direction, currencyCode, amount, minAmount, true, "0", marketPriceMarginPct, securityDepositPct, paymentAcctId, makerFeeCurrencyCode, triggerPrice);
    }

    public OfferInfo createOffer(String direction, String currencyCode, long amount, long minAmount, boolean useMarketBasedPrice, String fixedPrice, double marketPriceMarginPct, double securityDepositPct, String paymentAcctId, String makerFeeCurrencyCode, String triggerPrice) {
        return this.offersServiceRequest.createOffer(direction, currencyCode, amount, minAmount, useMarketBasedPrice, fixedPrice, marketPriceMarginPct, securityDepositPct, paymentAcctId, makerFeeCurrencyCode, triggerPrice);
    }

    public void editOfferActivationState(String offerId, int enable) {
        this.offersServiceRequest.editOfferActivationState(offerId, enable);
    }

    public void editOfferFixedPrice(String offerId, String priceAsString) {
        this.offersServiceRequest.editOfferFixedPrice(offerId, priceAsString);
    }

    public void editOfferPriceMargin(String offerId, double marketPriceMargin) {
        this.offersServiceRequest.editOfferPriceMargin(offerId, marketPriceMargin);
    }

    public void editOfferTriggerPrice(String offerId, String triggerPrice) {
        this.offersServiceRequest.editOfferTriggerPrice(offerId, triggerPrice);
    }

    public void editOffer(String offerId, String price, boolean useMarketBasedPrice, double marketPriceMarginPct, String triggerPrice, int enable, EditOfferRequest.EditType editType) {
        this.offersServiceRequest.editOffer(offerId, price, useMarketBasedPrice, marketPriceMarginPct, triggerPrice, enable, editType);
    }

    public void cancelOffer(String offerId) {
        this.offersServiceRequest.cancelOffer(offerId);
    }

    public OfferInfo getBsqSwapOffer(String offerId) {
        return this.offersServiceRequest.getBsqSwapOffer(offerId);
    }

    public OfferInfo getOffer(String offerId) {
        return this.offersServiceRequest.getOffer(offerId);
    }

    @Deprecated
    public OfferInfo getMyOffer(String offerId) {
        return this.offersServiceRequest.getMyOffer(offerId);
    }

    public List<OfferInfo> getBsqSwapOffers(String direction) {
        return this.offersServiceRequest.getBsqSwapOffers(direction);
    }

    public List<OfferInfo> getOffers(String direction, String currencyCode) {
        return this.offersServiceRequest.getOffers(direction, currencyCode);
    }

    public List<OfferInfo> getOffersSortedByDate(String currencyCode) {
        return this.offersServiceRequest.getOffersSortedByDate(currencyCode);
    }

    public List<OfferInfo> getOffersSortedByDate(String direction, String currencyCode) {
        return this.offersServiceRequest.getOffersSortedByDate(direction, currencyCode);
    }

    public List<OfferInfo> getBsqSwapOffersSortedByDate() {
        return this.offersServiceRequest.getBsqSwapOffersSortedByDate();
    }

    public List<OfferInfo> getMyOffers(String direction, String currencyCode) {
        return this.offersServiceRequest.getMyOffers(direction, currencyCode);
    }

    public List<OfferInfo> getMyOffersSortedByDate(String currencyCode) {
        return this.offersServiceRequest.getMyOffersSortedByDate(currencyCode);
    }

    public List<OfferInfo> getMyOffersSortedByDate(String direction, String currencyCode) {
        return this.offersServiceRequest.getMyOffersSortedByDate(direction, currencyCode);
    }

    public List<OfferInfo> getMyBsqSwapBsqOffersSortedByDate() {
        return this.offersServiceRequest.getMyBsqSwapOffersSortedByDate();
    }

    public TradeInfo takeBsqSwapOffer(String offerId, long amount) {
        return this.tradesServiceRequest.takeBsqSwapOffer(offerId, amount);
    }

    public TradeInfo takeOffer(String offerId, String paymentAccountId, String takerFeeCurrencyCode, long amount) {
        return this.tradesServiceRequest.takeOffer(offerId, paymentAccountId, takerFeeCurrencyCode, amount);
    }

    public TradeInfo getTrade(String tradeId) {
        return this.tradesServiceRequest.getTrade(tradeId);
    }

    public List<TradeInfo> getOpenTrades() {
        return this.tradesServiceRequest.getOpenTrades();
    }

    public List<TradeInfo> getTradeHistory(GetTradesRequest.Category category) {
        return this.tradesServiceRequest.getTradeHistory(category);
    }

    public void confirmPaymentStarted(String tradeId) {
        this.tradesServiceRequest.confirmPaymentStarted(tradeId);
    }

    public void confirmPaymentStartedXmr(String tradeId, String txId, String txKey) {
        this.tradesServiceRequest.confirmPaymentStartedXmr(tradeId, txId, txKey);
    }

    public void confirmPaymentReceived(String tradeId) {
        this.tradesServiceRequest.confirmPaymentReceived(tradeId);
    }

    public void closeTrade(String tradeId) {
        this.tradesServiceRequest.closeTrade(tradeId);
    }

    public void withdrawFunds(String tradeId, String address, String memo) {
        this.tradesServiceRequest.withdrawFunds(tradeId, address, memo);
    }

    public void failTrade(String tradeId) {
        this.tradesServiceRequest.failTrade(tradeId);
    }

    public void unFailTrade(String tradeId) {
        this.tradesServiceRequest.unFailTrade(tradeId);
    }

    public List<PaymentMethod> getPaymentMethods() {
        return this.paymentAccountsServiceRequest.getPaymentMethods();
    }

    public String getPaymentAcctFormAsJson(String paymentMethodId) {
        return this.paymentAccountsServiceRequest.getPaymentAcctFormAsJson(paymentMethodId);
    }

    public PaymentAccount createPaymentAccount(String json) {
        return this.paymentAccountsServiceRequest.createPaymentAccount(json);
    }

    public List<PaymentAccount> getPaymentAccounts() {
        return this.paymentAccountsServiceRequest.getPaymentAccounts();
    }

    public PaymentAccount getPaymentAccount(String accountName) {
        return this.paymentAccountsServiceRequest.getPaymentAccount(accountName);
    }

    public PaymentAccount createCryptoCurrencyPaymentAccount(String accountName, String currencyCode, String address, boolean tradeInstant) {
        return this.paymentAccountsServiceRequest.createCryptoCurrencyPaymentAccount(accountName, currencyCode, address, tradeInstant);
    }

    public List<PaymentMethod> getCryptoPaymentMethods() {
        return this.paymentAccountsServiceRequest.getCryptoPaymentMethods();
    }

    public void lockWallet() {
        this.walletsServiceRequest.lockWallet();
    }

    public void unlockWallet(String walletPassword, long timeout) {
        this.walletsServiceRequest.unlockWallet(walletPassword, timeout);
    }

    public void removeWalletPassword(String walletPassword) {
        this.walletsServiceRequest.removeWalletPassword(walletPassword);
    }

    public void setWalletPassword(String walletPassword) {
        this.walletsServiceRequest.setWalletPassword(walletPassword);
    }

    public void setWalletPassword(String oldWalletPassword, String newWalletPassword) {
        this.walletsServiceRequest.setWalletPassword(oldWalletPassword, newWalletPassword);
    }

    public void registerDisputeAgent(String disputeAgentType, String registrationKey) {
        RegisterDisputeAgentRequest request = RegisterDisputeAgentRequest.newBuilder().setDisputeAgentType(disputeAgentType).setRegistrationKey(registrationKey).build();
        this.grpcStubs.disputeAgentsService.registerDisputeAgent(request);
    }

    public void stopServer() {
        StopRequest request = StopRequest.newBuilder().build();
        this.grpcStubs.shutdownService.stop(request);
    }

    public String getMethodHelp(Method method) {
        GetMethodHelpRequest request = GetMethodHelpRequest.newBuilder().setMethodName(method.name()).build();
        return this.grpcStubs.helpService.getMethodHelp(request).getMethodHelp();
    }
}

