/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.opts;

import bisq.cli.opts.ArgumentList;
import bisq.cli.opts.MethodOpts;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

abstract class AbstractMethodOptionParser
implements MethodOpts {
    protected final String[] args;
    protected final OptionParser parser = new OptionParser();
    protected final OptionSpec<Void> helpOpt = this.parser.accepts("help", "Print method help").forHelp();
    protected OptionSet options;
    protected List<String> nonOptionArguments;
    protected final Predicate<OptionSpec<String>> valueNotSpecified = opt -> !this.options.hasArgument(opt) || ((String)this.options.valueOf(opt)).isEmpty();
    private final Function<OptionException, String> cliExceptionMessageStyle = ex -> {
        if (ex.getMessage() == null) {
            return null;
        }
        String optionToken = "option ";
        String cliMessage = ex.getMessage().toLowerCase();
        if (cliMessage.startsWith(optionToken) && cliMessage.length() > optionToken.length()) {
            cliMessage = cliMessage.substring(cliMessage.indexOf(" ") + 1);
        }
        return cliMessage;
    };

    protected AbstractMethodOptionParser(String[] args) {
        this.args = args;
    }

    @Override
    public AbstractMethodOptionParser parse() {
        try {
            this.options = this.parser.parse(new ArgumentList(this.args).getMethodArguments());
            this.nonOptionArguments = this.options.nonOptionArguments();
            return this;
        }
        catch (OptionException ex) {
            throw new IllegalArgumentException(this.cliExceptionMessageStyle.apply(ex), ex);
        }
    }

    @Override
    public boolean isForHelp() {
        return this.options.has(this.helpOpt);
    }

    protected void verifyStringIsValidDouble(String string) {
        try {
            Double.valueOf(string);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("%s is not a number", string));
        }
    }

    public OptionSet getOptions() {
        return this.options;
    }

    public List<String> getNonOptionArguments() {
        return this.nonOptionArguments;
    }
}

