/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.opts;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;

public class ArgumentList {
    private final Predicate<String> isCliOpt = o -> o.startsWith("--password") || o.startsWith("-password") || o.startsWith("--port") || o.startsWith("-port") || o.startsWith("--host") || o.startsWith("-host");
    private final Predicate<String> isMethodNameOpt = o -> !o.startsWith("-");
    private final Predicate<String> isHelpOpt = o -> o.startsWith("--help") || o.startsWith("-help");
    private final String[] arguments;
    private int currentIndex;

    public ArgumentList(String ... arguments) {
        this.arguments = (String[])arguments.clone();
    }

    public String[] getCLIArguments() {
        this.currentIndex = 0;
        Optional<Object> methodNameArgument = Optional.empty();
        Optional<Object> helpArgument = Optional.empty();
        ArrayList<String> prunedArguments = new ArrayList<String>();
        while (this.hasMore()) {
            String arg = this.peek();
            if (this.isMethodNameOpt.test(arg)) {
                methodNameArgument = Optional.of(arg);
                prunedArguments.add(arg);
            }
            if (this.isCliOpt.test(arg)) {
                prunedArguments.add(arg);
            }
            if (this.isHelpOpt.test(arg)) {
                helpArgument = Optional.of(arg);
            }
            this.next();
        }
        if (!methodNameArgument.isPresent() && helpArgument.isPresent()) {
            prunedArguments.add((String)helpArgument.get());
        }
        return prunedArguments.toArray(new String[0]);
    }

    public String[] getMethodArguments() {
        ArrayList<String> prunedArguments = new ArrayList<String>();
        this.currentIndex = 0;
        while (this.hasMore()) {
            String arg = this.peek();
            if (!this.isCliOpt.test(arg) && !this.isMethodNameOpt.test(arg)) {
                prunedArguments.add(arg);
            }
            this.next();
        }
        return prunedArguments.toArray(new String[0]);
    }

    boolean hasMore() {
        return this.currentIndex < this.arguments.length;
    }

    String next() {
        return this.arguments[this.currentIndex++];
    }

    String peek() {
        return this.arguments[this.currentIndex];
    }
}

