/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.opts;

import bisq.cli.opts.AbstractMethodOptionParser;
import bisq.cli.opts.MethodOpts;
import joptsimple.OptionSpec;

public class CreateOfferOptionParser
extends AbstractMethodOptionParser
implements MethodOpts {
    final OptionSpec<String> paymentAccountIdOpt;
    final OptionSpec<String> directionOpt;
    final OptionSpec<String> currencyCodeOpt;
    final OptionSpec<String> amountOpt;
    final OptionSpec<String> minAmountOpt;
    final OptionSpec<String> mktPriceMarginPctOpt;
    final OptionSpec<String> fixedPriceOpt;
    final OptionSpec<String> securityDepositPctOpt;
    final OptionSpec<String> makerFeeCurrencyCodeOpt;
    final OptionSpec<Boolean> isSwapOpt;

    public CreateOfferOptionParser(String[] args) {
        super(args);
        this.paymentAccountIdOpt = this.parser.accepts("payment-account-id", "id of payment account used for offer").withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]);
        this.directionOpt = this.parser.accepts("direction", "offer direction (buy|sell)").withRequiredArg();
        this.currencyCodeOpt = this.parser.accepts("currency-code", "currency code (bsq|xmr|eur|usd|...)").withRequiredArg();
        this.amountOpt = this.parser.accepts("amount", "amount of btc to buy or sell").withRequiredArg();
        this.minAmountOpt = this.parser.accepts("min-amount", "minimum amount of btc to buy or sell").withOptionalArg();
        this.mktPriceMarginPctOpt = this.parser.accepts("market-price-margin", "market btc price margin (%)").withOptionalArg().defaultsTo((Object)"0.00", (Object[])new String[0]);
        this.fixedPriceOpt = this.parser.accepts("fixed-price", "fixed btc price").withOptionalArg().defaultsTo((Object)"0", (Object[])new String[0]);
        this.securityDepositPctOpt = this.parser.accepts("security-deposit", "maker security deposit (%)").withRequiredArg();
        this.makerFeeCurrencyCodeOpt = this.parser.accepts("fee-currency", "maker fee currency code (bsq|btc)").withOptionalArg().defaultsTo((Object)"btc", (Object[])new String[0]);
        this.isSwapOpt = this.parser.accepts("swap", "create bsq swap offer").withOptionalArg().ofType(Boolean.TYPE).defaultsTo((Object)Boolean.FALSE, (Object[])new Boolean[0]);
    }

    @Override
    public CreateOfferOptionParser parse() {
        super.parse();
        if (this.options.has(this.helpOpt)) {
            return this;
        }
        if (!this.options.has(this.directionOpt) || ((String)this.options.valueOf(this.directionOpt)).isEmpty()) {
            throw new IllegalArgumentException("no direction (buy|sell) specified");
        }
        if (!this.options.has(this.currencyCodeOpt) || ((String)this.options.valueOf(this.currencyCodeOpt)).isEmpty()) {
            throw new IllegalArgumentException("no currency code specified");
        }
        if (!this.options.has(this.amountOpt) || ((String)this.options.valueOf(this.amountOpt)).isEmpty()) {
            throw new IllegalArgumentException("no btc amount specified");
        }
        if (this.getIsSwap()) {
            if (!((String)this.options.valueOf(this.currencyCodeOpt)).equalsIgnoreCase("bsq")) {
                throw new IllegalArgumentException("only bsq swaps are currently supported");
            }
            if (this.options.has(this.paymentAccountIdOpt)) {
                throw new IllegalArgumentException("cannot use a payment account id in bsq swap offer");
            }
            if (this.options.has(this.mktPriceMarginPctOpt)) {
                throw new IllegalArgumentException("cannot use a market price margin in bsq swap offer");
            }
            if (this.options.has(this.securityDepositPctOpt)) {
                throw new IllegalArgumentException("cannot use a security deposit in bsq swap offer");
            }
            if (!this.options.has(this.fixedPriceOpt) || ((String)this.options.valueOf(this.fixedPriceOpt)).isEmpty()) {
                throw new IllegalArgumentException("no fixed price specified");
            }
        } else {
            if (!this.options.has(this.paymentAccountIdOpt) || ((String)this.options.valueOf(this.paymentAccountIdOpt)).isEmpty()) {
                throw new IllegalArgumentException("no payment account id specified");
            }
            if (!this.options.has(this.mktPriceMarginPctOpt) && !this.options.has(this.fixedPriceOpt)) {
                throw new IllegalArgumentException("no market price margin or fixed price specified");
            }
            if (this.options.has(this.mktPriceMarginPctOpt)) {
                String mktPriceMarginPctString = (String)this.options.valueOf(this.mktPriceMarginPctOpt);
                if (mktPriceMarginPctString.isEmpty()) {
                    throw new IllegalArgumentException("no market price margin specified");
                }
                this.verifyStringIsValidDouble(mktPriceMarginPctString);
            }
            if (this.options.has(this.fixedPriceOpt) && ((String)this.options.valueOf(this.fixedPriceOpt)).isEmpty()) {
                throw new IllegalArgumentException("no fixed price specified");
            }
            if (!this.options.has(this.securityDepositPctOpt) || ((String)this.options.valueOf(this.securityDepositPctOpt)).isEmpty()) {
                throw new IllegalArgumentException("no security deposit specified");
            }
            this.verifyStringIsValidDouble((String)this.options.valueOf(this.securityDepositPctOpt));
        }
        return this;
    }

    public String getPaymentAccountId() {
        return (String)this.options.valueOf(this.paymentAccountIdOpt);
    }

    public String getDirection() {
        return (String)this.options.valueOf(this.directionOpt);
    }

    public String getCurrencyCode() {
        return (String)this.options.valueOf(this.currencyCodeOpt);
    }

    public String getAmount() {
        return (String)this.options.valueOf(this.amountOpt);
    }

    public String getMinAmount() {
        return this.options.has(this.minAmountOpt) ? (String)this.options.valueOf(this.minAmountOpt) : this.getAmount();
    }

    public boolean isUsingMktPriceMargin() {
        return this.options.has(this.mktPriceMarginPctOpt);
    }

    public double getMktPriceMarginPct() {
        return this.isUsingMktPriceMargin() ? Double.parseDouble((String)this.options.valueOf(this.mktPriceMarginPctOpt)) : 0.0;
    }

    public String getFixedPrice() {
        return this.options.has(this.fixedPriceOpt) ? (String)this.options.valueOf(this.fixedPriceOpt) : "0.00";
    }

    public double getSecurityDepositPct() {
        return Double.valueOf((String)this.options.valueOf(this.securityDepositPctOpt));
    }

    public String getMakerFeeCurrencyCode() {
        return this.options.has(this.makerFeeCurrencyCodeOpt) ? (String)this.options.valueOf(this.makerFeeCurrencyCodeOpt) : "btc";
    }

    public boolean getIsSwap() {
        return (Boolean)this.options.valueOf(this.isSwapOpt);
    }
}

