/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.opts;

import bisq.cli.opts.MethodOpts;
import bisq.cli.opts.OfferIdOptionParser;
import bisq.proto.grpc.EditOfferRequest;
import joptsimple.OptionSpec;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EditOfferOptionParser
extends OfferIdOptionParser
implements MethodOpts {
    static int OPT_ENABLE_ON = 1;
    static int OPT_ENABLE_OFF = 0;
    static int OPT_ENABLE_IGNORED = -1;
    final OptionSpec<String> fixedPriceOpt;
    final OptionSpec<String> mktPriceMarginPctOpt;
    final OptionSpec<String> triggerPriceOpt;
    final OptionSpec<String> enableOpt;
    private EditOfferRequest.EditType offerEditType;

    public EditOfferOptionParser(String[] args) {
        super(args, true);
        this.fixedPriceOpt = this.parser.accepts("fixed-price", "fixed btc price").withOptionalArg().defaultsTo((Object)"0", (Object[])new String[0]);
        this.mktPriceMarginPctOpt = this.parser.accepts("market-price-margin", "market btc price margin (%)").withOptionalArg().defaultsTo((Object)"0.00", (Object[])new String[0]);
        this.triggerPriceOpt = this.parser.accepts("trigger-price", "trigger price (applies to mkt price margin based offers)").withOptionalArg().defaultsTo((Object)"0", (Object[])new String[0]);
        this.enableOpt = this.parser.accepts("enable", "enable or disable offer").withOptionalArg().ofType(String.class);
    }

    @Override
    public EditOfferOptionParser parse() {
        boolean hasNoEditDetails;
        super.parse();
        boolean bl = hasNoEditDetails = !this.options.has(this.fixedPriceOpt) && !this.options.has(this.mktPriceMarginPctOpt) && !this.options.has(this.triggerPriceOpt) && !this.options.has(this.enableOpt);
        if (hasNoEditDetails) {
            throw new IllegalArgumentException("no edit details specified");
        }
        if (this.options.has(this.enableOpt)) {
            boolean enableOptIsOnlyOpt;
            if (this.valueNotSpecified.test(this.enableOpt)) {
                throw new IllegalArgumentException("invalid enable value specified, must be true|false");
            }
            String enableOptValue = (String)this.options.valueOf(this.enableOpt);
            if (!enableOptValue.equalsIgnoreCase("true") && !enableOptValue.equalsIgnoreCase("false")) {
                throw new IllegalArgumentException("invalid enable value specified, must be true|false");
            }
            boolean bl2 = enableOptIsOnlyOpt = !this.options.has(this.fixedPriceOpt) && !this.options.has(this.mktPriceMarginPctOpt) && !this.options.has(this.triggerPriceOpt);
            if (enableOptIsOnlyOpt) {
                this.offerEditType = EditOfferRequest.EditType.ACTIVATION_STATE_ONLY;
                return this;
            }
        }
        if (this.options.has(this.fixedPriceOpt)) {
            boolean fixedPriceOptAndEnableOptAreOnlyOpts;
            boolean fixedPriceOptIsOnlyOpt;
            if (this.valueNotSpecified.test(this.fixedPriceOpt)) {
                throw new IllegalArgumentException("no fixed price specified");
            }
            String fixedPriceAsString = (String)this.options.valueOf(this.fixedPriceOpt);
            this.verifyStringIsValidDouble(fixedPriceAsString);
            boolean bl3 = fixedPriceOptIsOnlyOpt = !this.options.has(this.mktPriceMarginPctOpt) && !this.options.has(this.triggerPriceOpt) && !this.options.has(this.enableOpt);
            if (fixedPriceOptIsOnlyOpt) {
                this.offerEditType = EditOfferRequest.EditType.FIXED_PRICE_ONLY;
                return this;
            }
            boolean bl4 = fixedPriceOptAndEnableOptAreOnlyOpts = this.options.has(this.enableOpt) && !this.options.has(this.mktPriceMarginPctOpt) && !this.options.has(this.triggerPriceOpt);
            if (fixedPriceOptAndEnableOptAreOnlyOpts) {
                this.offerEditType = EditOfferRequest.EditType.FIXED_PRICE_AND_ACTIVATION_STATE;
                return this;
            }
        }
        if (this.options.has(this.mktPriceMarginPctOpt)) {
            boolean mktPriceMarginOptAndEnableOptAreOnlyOpts;
            boolean mktPriceMarginOptIsOnlyOpt;
            if (this.valueNotSpecified.test(this.mktPriceMarginPctOpt)) {
                throw new IllegalArgumentException("no market price margin specified");
            }
            String priceMarginPctAsString = (String)this.options.valueOf(this.mktPriceMarginPctOpt);
            this.verifyStringIsValidDouble(priceMarginPctAsString);
            boolean bl5 = mktPriceMarginOptIsOnlyOpt = !this.options.has(this.triggerPriceOpt) && !this.options.has(this.fixedPriceOpt) && !this.options.has(this.enableOpt);
            if (mktPriceMarginOptIsOnlyOpt) {
                this.offerEditType = EditOfferRequest.EditType.MKT_PRICE_MARGIN_ONLY;
                return this;
            }
            boolean bl6 = mktPriceMarginOptAndEnableOptAreOnlyOpts = this.options.has(this.enableOpt) && !this.options.has(this.fixedPriceOpt) && !this.options.has(this.triggerPriceOpt);
            if (mktPriceMarginOptAndEnableOptAreOnlyOpts) {
                this.offerEditType = EditOfferRequest.EditType.MKT_PRICE_MARGIN_AND_ACTIVATION_STATE;
                return this;
            }
        }
        if (this.options.has(this.triggerPriceOpt)) {
            boolean triggerPriceOptAndEnableOptAreOnlyOpts;
            boolean triggerPriceOptIsOnlyOpt;
            if (this.valueNotSpecified.test(this.triggerPriceOpt)) {
                throw new IllegalArgumentException("no trigger price specified");
            }
            String triggerPriceAsString = (String)this.options.valueOf(this.triggerPriceOpt);
            this.verifyStringIsValidDouble(triggerPriceAsString);
            boolean bl7 = triggerPriceOptIsOnlyOpt = !this.options.has(this.mktPriceMarginPctOpt) && !this.options.has(this.fixedPriceOpt) && !this.options.has(this.enableOpt);
            if (triggerPriceOptIsOnlyOpt) {
                this.offerEditType = EditOfferRequest.EditType.TRIGGER_PRICE_ONLY;
                return this;
            }
            boolean bl8 = triggerPriceOptAndEnableOptAreOnlyOpts = !this.options.has(this.mktPriceMarginPctOpt) && !this.options.has(this.fixedPriceOpt) && this.options.has(this.enableOpt);
            if (triggerPriceOptAndEnableOptAreOnlyOpts) {
                this.offerEditType = EditOfferRequest.EditType.TRIGGER_PRICE_AND_ACTIVATION_STATE;
                return this;
            }
        }
        if (this.options.has(this.mktPriceMarginPctOpt) && this.options.has(this.fixedPriceOpt)) {
            throw new IllegalArgumentException("cannot specify market price margin and fixed price");
        }
        if (this.options.has(this.fixedPriceOpt) && this.options.has(this.triggerPriceOpt)) {
            throw new IllegalArgumentException("trigger price cannot be set on fixed price offers");
        }
        if (this.options.has(this.mktPriceMarginPctOpt) && this.options.has(this.triggerPriceOpt) && !this.options.has(this.enableOpt)) {
            this.offerEditType = EditOfferRequest.EditType.MKT_PRICE_MARGIN_AND_TRIGGER_PRICE;
            return this;
        }
        if (this.options.has(this.mktPriceMarginPctOpt) && this.options.has(this.triggerPriceOpt) && this.options.has(this.enableOpt)) {
            this.offerEditType = EditOfferRequest.EditType.MKT_PRICE_MARGIN_AND_TRIGGER_PRICE_AND_ACTIVATION_STATE;
            return this;
        }
        return this;
    }

    public String getFixedPrice() {
        if (this.offerEditType.equals((Object)EditOfferRequest.EditType.FIXED_PRICE_ONLY) || this.offerEditType.equals((Object)EditOfferRequest.EditType.FIXED_PRICE_AND_ACTIVATION_STATE)) {
            return this.options.has(this.fixedPriceOpt) ? (String)this.options.valueOf(this.fixedPriceOpt) : "0";
        }
        return "0";
    }

    public String getTriggerPrice() {
        if (this.offerEditType.equals((Object)EditOfferRequest.EditType.TRIGGER_PRICE_ONLY) || this.offerEditType.equals((Object)EditOfferRequest.EditType.TRIGGER_PRICE_AND_ACTIVATION_STATE) || this.offerEditType.equals((Object)EditOfferRequest.EditType.MKT_PRICE_MARGIN_AND_TRIGGER_PRICE) || this.offerEditType.equals((Object)EditOfferRequest.EditType.MKT_PRICE_MARGIN_AND_TRIGGER_PRICE_AND_ACTIVATION_STATE)) {
            return this.options.has(this.triggerPriceOpt) ? (String)this.options.valueOf(this.triggerPriceOpt) : "0";
        }
        return "0";
    }

    public String getMktPriceMargin() {
        if (this.offerEditType.equals((Object)EditOfferRequest.EditType.MKT_PRICE_MARGIN_ONLY) || this.offerEditType.equals((Object)EditOfferRequest.EditType.MKT_PRICE_MARGIN_AND_ACTIVATION_STATE) || this.offerEditType.equals((Object)EditOfferRequest.EditType.MKT_PRICE_MARGIN_AND_TRIGGER_PRICE) || this.offerEditType.equals((Object)EditOfferRequest.EditType.MKT_PRICE_MARGIN_AND_TRIGGER_PRICE_AND_ACTIVATION_STATE)) {
            return this.isUsingMktPriceMargin() ? (String)this.options.valueOf(this.mktPriceMarginPctOpt) : "0.00";
        }
        return "0.00";
    }

    public double getMktPriceMarginPct() {
        return Double.parseDouble((String)this.options.valueOf(this.mktPriceMarginPctOpt));
    }

    public boolean isUsingMktPriceMargin() {
        return !this.offerEditType.equals((Object)EditOfferRequest.EditType.FIXED_PRICE_ONLY) && !this.offerEditType.equals((Object)EditOfferRequest.EditType.FIXED_PRICE_AND_ACTIVATION_STATE);
    }

    public int getEnableAsSignedInt() {
        @Nullable Boolean input = this.isEnable();
        return input == null ? OPT_ENABLE_IGNORED : (input != false ? OPT_ENABLE_ON : OPT_ENABLE_OFF);
    }

    public @Nullable Boolean isEnable() {
        return this.options.has(this.enableOpt) ? Boolean.valueOf((String)this.options.valueOf(this.enableOpt)) : null;
    }

    public EditOfferRequest.EditType getOfferEditType() {
        return this.offerEditType;
    }
}

