/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.opts;

import bisq.cli.opts.AbstractMethodOptionParser;
import bisq.cli.opts.MethodOpts;
import bisq.proto.grpc.GetTradesRequest;
import java.util.Arrays;
import java.util.function.Predicate;
import joptsimple.OptionSpec;

public class GetTradesOptionParser
extends AbstractMethodOptionParser
implements MethodOpts {
    final OptionSpec<String> categoryOpt;
    private final Predicate<String> isValidCategory;

    public GetTradesOptionParser(String[] args) {
        super(args);
        this.categoryOpt = this.parser.accepts("category", "category of trades (open|closed|failed)").withRequiredArg().defaultsTo((Object)CATEGORY.open.name(), (Object[])new String[0]);
        this.isValidCategory = c -> Arrays.stream(CATEGORY.values()).anyMatch(v -> v.name().equalsIgnoreCase((String)c));
    }

    @Override
    public GetTradesOptionParser parse() {
        super.parse();
        if (this.options.has(this.helpOpt)) {
            return this;
        }
        if (this.options.has(this.categoryOpt)) {
            String category = (String)this.options.valueOf(this.categoryOpt);
            if (category.isEmpty()) {
                throw new IllegalArgumentException("no category (open|closed|failed) specified");
            }
            if (!this.isValidCategory.test(category)) {
                throw new IllegalArgumentException("category must be open|closed|failed");
            }
        }
        return this;
    }

    public GetTradesRequest.Category getCategory() {
        String categoryOpt = ((String)this.options.valueOf(this.categoryOpt)).toLowerCase();
        return CATEGORY.valueOf((String)categoryOpt).grpcRequestCategory;
    }

    private static enum CATEGORY {
        open(GetTradesRequest.Category.OPEN),
        closed(GetTradesRequest.Category.CLOSED),
        failed(GetTradesRequest.Category.FAILED);

        private final GetTradesRequest.Category grpcRequestCategory;

        private CATEGORY(GetTradesRequest.Category grpcRequestCategory) {
            this.grpcRequestCategory = grpcRequestCategory;
        }
    }
}

