/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.opts;

import bisq.cli.opts.AbstractMethodOptionParser;
import bisq.cli.opts.MethodOpts;
import joptsimple.OptionSpec;

public class SendBtcOptionParser
extends AbstractMethodOptionParser
implements MethodOpts {
    final OptionSpec<String> addressOpt;
    final OptionSpec<String> amountOpt;
    final OptionSpec<String> feeRateOpt;
    final OptionSpec<String> memoOpt;

    public SendBtcOptionParser(String[] args) {
        super(args);
        this.addressOpt = this.parser.accepts("address", "destination btc address").withRequiredArg();
        this.amountOpt = this.parser.accepts("amount", "amount of btc to send").withRequiredArg();
        this.feeRateOpt = this.parser.accepts("tx-fee-rate", "optional tx fee rate (sats/byte)").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
        this.memoOpt = this.parser.accepts("memo", "optional tx memo").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
    }

    @Override
    public SendBtcOptionParser parse() {
        super.parse();
        if (this.options.has(this.helpOpt)) {
            return this;
        }
        if (!this.options.has(this.addressOpt) || ((String)this.options.valueOf(this.addressOpt)).isEmpty()) {
            throw new IllegalArgumentException("no btc address specified");
        }
        if (!this.options.has(this.amountOpt) || ((String)this.options.valueOf(this.amountOpt)).isEmpty()) {
            throw new IllegalArgumentException("no btc amount specified");
        }
        return this;
    }

    public String getAddress() {
        return (String)this.options.valueOf(this.addressOpt);
    }

    public String getAmount() {
        return (String)this.options.valueOf(this.amountOpt);
    }

    public String getFeeRate() {
        return this.options.has(this.feeRateOpt) ? (String)this.options.valueOf(this.feeRateOpt) : "";
    }

    public String getMemo() {
        return this.options.has(this.memoOpt) ? (String)this.options.valueOf(this.memoOpt) : "";
    }
}

