/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.opts;

import bisq.cli.CurrencyFormat;
import bisq.cli.opts.MethodOpts;
import bisq.cli.opts.OfferIdOptionParser;
import joptsimple.OptionSpec;

public class TakeBsqSwapOfferOptionParser
extends OfferIdOptionParser
implements MethodOpts {
    final OptionSpec<String> amountOpt;
    final OptionSpec<String> paymentAccountIdOpt;
    final OptionSpec<String> takerFeeCurrencyCodeOpt;

    public TakeBsqSwapOfferOptionParser(String[] args) {
        super(args, true);
        this.amountOpt = this.parser.accepts("amount", "intended amount of btc to buy or sell").withRequiredArg().defaultsTo((Object)"0", (Object[])new String[0]);
        this.paymentAccountIdOpt = this.parser.accepts("payment-account-id", "not used when taking bsq swaps").withRequiredArg().defaultsTo((Object)"invalid param", (Object[])new String[0]);
        this.takerFeeCurrencyCodeOpt = this.parser.accepts("fee-currency", "not used when taking bsq swaps").withOptionalArg().defaultsTo((Object)"invalid param", (Object[])new String[0]);
    }

    @Override
    public TakeBsqSwapOfferOptionParser parse() {
        super.parse();
        if (this.options.has(this.paymentAccountIdOpt)) {
            throw new IllegalArgumentException("the payment-account-id param is not used for swaps; the internal default swap account is always used");
        }
        if (this.options.has(this.takerFeeCurrencyCodeOpt)) {
            throw new IllegalArgumentException("the fee-currency param is not used for swaps; fees are always paid in bsq");
        }
        if (this.options.has(this.amountOpt)) {
            if (((String)this.options.valueOf(this.amountOpt)).isEmpty()) {
                throw new IllegalArgumentException("no intended btc trade amount specified");
            }
            try {
                CurrencyFormat.toSatoshis((String)this.options.valueOf(this.amountOpt));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("invalid amount: " + ex.getMessage());
            }
        }
        return this;
    }

    public String getAmount() {
        return (String)this.options.valueOf(this.amountOpt);
    }
}

