/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.request;

import bisq.cli.GrpcStubs;
import bisq.proto.grpc.CancelOfferRequest;
import bisq.proto.grpc.CreateBsqSwapOfferRequest;
import bisq.proto.grpc.CreateOfferRequest;
import bisq.proto.grpc.EditOfferRequest;
import bisq.proto.grpc.GetBsqSwapOffersRequest;
import bisq.proto.grpc.GetMyOfferRequest;
import bisq.proto.grpc.GetMyOffersRequest;
import bisq.proto.grpc.GetOfferCategoryReply;
import bisq.proto.grpc.GetOfferCategoryRequest;
import bisq.proto.grpc.GetOfferRequest;
import bisq.proto.grpc.GetOffersRequest;
import bisq.proto.grpc.OfferInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import protobuf.OfferDirection;

public class OffersServiceRequest {
    private final GrpcStubs grpcStubs;

    public OffersServiceRequest(GrpcStubs grpcStubs) {
        this.grpcStubs = grpcStubs;
    }

    public GetOfferCategoryReply.OfferCategory getAvailableOfferCategory(String offerId) {
        return this.getOfferCategory(offerId, false);
    }

    public GetOfferCategoryReply.OfferCategory getMyOfferCategory(String offerId) {
        return this.getOfferCategory(offerId, true);
    }

    public OfferInfo createBsqSwapOffer(String direction, long amount, long minAmount, String fixedPrice) {
        CreateBsqSwapOfferRequest request = CreateBsqSwapOfferRequest.newBuilder().setDirection(direction).setAmount(amount).setMinAmount(minAmount).setPrice(fixedPrice).build();
        return this.grpcStubs.offersService.createBsqSwapOffer(request).getBsqSwapOffer();
    }

    public OfferInfo createFixedPricedOffer(String direction, String currencyCode, long amount, long minAmount, String fixedPrice, double securityDepositPct, String paymentAcctId, String makerFeeCurrencyCode) {
        return this.createOffer(direction, currencyCode, amount, minAmount, false, fixedPrice, 0.0, securityDepositPct, paymentAcctId, makerFeeCurrencyCode, "0");
    }

    public OfferInfo createOffer(String direction, String currencyCode, long amount, long minAmount, boolean useMarketBasedPrice, String fixedPrice, double marketPriceMarginPct, double securityDepositPct, String paymentAcctId, String makerFeeCurrencyCode, String triggerPrice) {
        CreateOfferRequest request = CreateOfferRequest.newBuilder().setDirection(direction).setCurrencyCode(currencyCode).setAmount(amount).setMinAmount(minAmount).setUseMarketBasedPrice(useMarketBasedPrice).setPrice(fixedPrice).setMarketPriceMarginPct(marketPriceMarginPct).setBuyerSecurityDepositPct(securityDepositPct).setPaymentAccountId(paymentAcctId).setMakerFeeCurrencyCode(makerFeeCurrencyCode).setTriggerPrice(triggerPrice).build();
        return this.grpcStubs.offersService.createOffer(request).getOffer();
    }

    public void editOfferActivationState(String offerId, int enable) {
        OfferInfo offer = this.getMyOffer(offerId);
        String offerPrice = offer.getUseMarketBasedPrice() ? "0.00" : offer.getPrice();
        this.editOffer(offerId, offerPrice, offer.getUseMarketBasedPrice(), offer.getMarketPriceMarginPct(), offer.getTriggerPrice(), enable, EditOfferRequest.EditType.ACTIVATION_STATE_ONLY);
    }

    public void editOfferFixedPrice(String offerId, String rawPriceString) {
        OfferInfo offer = this.getMyOffer(offerId);
        this.editOffer(offerId, rawPriceString, false, offer.getMarketPriceMarginPct(), offer.getTriggerPrice(), offer.getIsActivated() ? 1 : 0, EditOfferRequest.EditType.FIXED_PRICE_ONLY);
    }

    public void editOfferPriceMargin(String offerId, double marketPriceMarginPct) {
        OfferInfo offer = this.getMyOffer(offerId);
        this.editOffer(offerId, "0.00", true, marketPriceMarginPct, offer.getTriggerPrice(), offer.getIsActivated() ? 1 : 0, EditOfferRequest.EditType.MKT_PRICE_MARGIN_ONLY);
    }

    public void editOfferTriggerPrice(String offerId, String triggerPrice) {
        OfferInfo offer = this.getMyOffer(offerId);
        this.editOffer(offerId, "0.00", offer.getUseMarketBasedPrice(), offer.getMarketPriceMarginPct(), triggerPrice, offer.getIsActivated() ? 1 : 0, EditOfferRequest.EditType.TRIGGER_PRICE_ONLY);
    }

    public void editOffer(String offerId, String scaledPriceString, boolean useMarketBasedPrice, double marketPriceMarginPct, String triggerPrice, int enable, EditOfferRequest.EditType editType) {
        EditOfferRequest request = EditOfferRequest.newBuilder().setId(offerId).setPrice(scaledPriceString).setUseMarketBasedPrice(useMarketBasedPrice).setMarketPriceMarginPct(marketPriceMarginPct).setTriggerPrice(triggerPrice).setEnable(enable).setEditType(editType).build();
        this.grpcStubs.offersService.editOffer(request);
    }

    public void cancelOffer(String offerId) {
        CancelOfferRequest request = CancelOfferRequest.newBuilder().setId(offerId).build();
        this.grpcStubs.offersService.cancelOffer(request);
    }

    public OfferInfo getBsqSwapOffer(String offerId) {
        GetOfferRequest request = GetOfferRequest.newBuilder().setId(offerId).build();
        return this.grpcStubs.offersService.getBsqSwapOffer(request).getBsqSwapOffer();
    }

    public OfferInfo getOffer(String offerId) {
        GetOfferRequest request = GetOfferRequest.newBuilder().setId(offerId).build();
        return this.grpcStubs.offersService.getOffer(request).getOffer();
    }

    public OfferInfo getMyOffer(String offerId) {
        GetMyOfferRequest request = GetMyOfferRequest.newBuilder().setId(offerId).build();
        return this.grpcStubs.offersService.getMyOffer(request).getOffer();
    }

    public List<OfferInfo> getBsqSwapOffers(String direction) {
        GetBsqSwapOffersRequest request = GetBsqSwapOffersRequest.newBuilder().setDirection(direction).build();
        return this.grpcStubs.offersService.getBsqSwapOffers(request).getBsqSwapOffersList();
    }

    public List<OfferInfo> getOffers(String direction, String currencyCode) {
        GetOffersRequest request = GetOffersRequest.newBuilder().setDirection(direction).setCurrencyCode(currencyCode).build();
        return this.grpcStubs.offersService.getOffers(request).getOffersList();
    }

    public List<OfferInfo> getOffersSortedByDate(String currencyCode) {
        ArrayList<OfferInfo> offers = new ArrayList<OfferInfo>();
        offers.addAll(this.getOffers(OfferDirection.BUY.name(), currencyCode));
        offers.addAll(this.getOffers(OfferDirection.SELL.name(), currencyCode));
        return offers.isEmpty() ? offers : this.sortOffersByDate(offers);
    }

    public List<OfferInfo> getOffersSortedByDate(String direction, String currencyCode) {
        List<OfferInfo> offers = this.getOffers(direction, currencyCode);
        return offers.isEmpty() ? offers : this.sortOffersByDate(offers);
    }

    public List<OfferInfo> getBsqSwapOffersSortedByDate() {
        ArrayList<OfferInfo> offers = new ArrayList<OfferInfo>();
        offers.addAll(this.getBsqSwapOffers(OfferDirection.BUY.name()));
        offers.addAll(this.getBsqSwapOffers(OfferDirection.SELL.name()));
        return this.sortOffersByDate(offers);
    }

    public List<OfferInfo> getMyBsqSwapOffers(String direction) {
        GetBsqSwapOffersRequest request = GetBsqSwapOffersRequest.newBuilder().setDirection(direction).build();
        return this.grpcStubs.offersService.getMyBsqSwapOffers(request).getBsqSwapOffersList();
    }

    public List<OfferInfo> getMyOffers(String direction, String currencyCode) {
        GetMyOffersRequest request = GetMyOffersRequest.newBuilder().setDirection(direction).setCurrencyCode(currencyCode).build();
        return this.grpcStubs.offersService.getMyOffers(request).getOffersList();
    }

    public List<OfferInfo> getMyOffersSortedByDate(String currencyCode) {
        ArrayList<OfferInfo> offers = new ArrayList<OfferInfo>();
        offers.addAll(this.getMyOffers(OfferDirection.BUY.name(), currencyCode));
        offers.addAll(this.getMyOffers(OfferDirection.SELL.name(), currencyCode));
        return offers.isEmpty() ? offers : this.sortOffersByDate(offers);
    }

    public List<OfferInfo> getMyOffersSortedByDate(String direction, String currencyCode) {
        List<OfferInfo> offers = this.getMyOffers(direction, currencyCode);
        return offers.isEmpty() ? offers : this.sortOffersByDate(offers);
    }

    public List<OfferInfo> getMyBsqSwapOffersSortedByDate() {
        ArrayList<OfferInfo> offers = new ArrayList<OfferInfo>();
        offers.addAll(this.getMyBsqSwapOffers(OfferDirection.BUY.name()));
        offers.addAll(this.getMyBsqSwapOffers(OfferDirection.SELL.name()));
        return this.sortOffersByDate(offers);
    }

    public OfferInfo getMostRecentOffer(String direction, String currencyCode) {
        List<OfferInfo> offers = this.getOffersSortedByDate(direction, currencyCode);
        return offers.isEmpty() ? null : offers.get(offers.size() - 1);
    }

    public List<OfferInfo> sortOffersByDate(List<OfferInfo> offerInfoList) {
        return offerInfoList.stream().sorted(Comparator.comparing(OfferInfo::getDate)).collect(Collectors.toList());
    }

    private GetOfferCategoryReply.OfferCategory getOfferCategory(String offerId, boolean isMyOffer) {
        GetOfferCategoryRequest request = GetOfferCategoryRequest.newBuilder().setId(offerId).setIsMyOffer(isMyOffer).build();
        return this.grpcStubs.offersService.getOfferCategory(request).getOfferCategory();
    }
}

