/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.request;

import bisq.cli.GrpcStubs;
import bisq.proto.grpc.CloseTradeRequest;
import bisq.proto.grpc.ConfirmPaymentReceivedRequest;
import bisq.proto.grpc.ConfirmPaymentStartedRequest;
import bisq.proto.grpc.ConfirmPaymentStartedXmrRequest;
import bisq.proto.grpc.FailTradeRequest;
import bisq.proto.grpc.GetTradeRequest;
import bisq.proto.grpc.GetTradesRequest;
import bisq.proto.grpc.TakeOfferReply;
import bisq.proto.grpc.TakeOfferRequest;
import bisq.proto.grpc.TradeInfo;
import bisq.proto.grpc.UnFailTradeRequest;
import bisq.proto.grpc.WithdrawFundsRequest;
import java.util.List;

public class TradesServiceRequest {
    private final GrpcStubs grpcStubs;

    public TradesServiceRequest(GrpcStubs grpcStubs) {
        this.grpcStubs = grpcStubs;
    }

    public TakeOfferReply getTakeOfferReply(String offerId, String paymentAccountId, String takerFeeCurrencyCode, long amount) {
        TakeOfferRequest request = TakeOfferRequest.newBuilder().setOfferId(offerId).setPaymentAccountId(paymentAccountId).setTakerFeeCurrencyCode(takerFeeCurrencyCode).setAmount(amount).build();
        return this.grpcStubs.tradesService.takeOffer(request);
    }

    public TradeInfo takeBsqSwapOffer(String offerId, long amount) {
        TakeOfferReply reply = this.getTakeOfferReply(offerId, "", "", amount);
        if (reply.hasTrade()) {
            return reply.getTrade();
        }
        throw new IllegalStateException(reply.getFailureReason().getDescription());
    }

    public TradeInfo takeOffer(String offerId, String paymentAccountId, String takerFeeCurrencyCode, long amount) {
        TakeOfferReply reply = this.getTakeOfferReply(offerId, paymentAccountId, takerFeeCurrencyCode, amount);
        if (reply.hasTrade()) {
            return reply.getTrade();
        }
        throw new IllegalStateException(reply.getFailureReason().getDescription());
    }

    public TradeInfo getTrade(String tradeId) {
        GetTradeRequest request = GetTradeRequest.newBuilder().setTradeId(tradeId).build();
        return this.grpcStubs.tradesService.getTrade(request).getTrade();
    }

    public List<TradeInfo> getOpenTrades() {
        GetTradesRequest request = GetTradesRequest.newBuilder().build();
        return this.grpcStubs.tradesService.getTrades(request).getTradesList();
    }

    public List<TradeInfo> getTradeHistory(GetTradesRequest.Category category) {
        if (!category.equals((Object)GetTradesRequest.Category.CLOSED) && !category.equals((Object)GetTradesRequest.Category.FAILED)) {
            throw new IllegalStateException("unrecognized gettrades category parameter " + category.name());
        }
        GetTradesRequest request = GetTradesRequest.newBuilder().setCategory(category).build();
        return this.grpcStubs.tradesService.getTrades(request).getTradesList();
    }

    public void confirmPaymentStarted(String tradeId) {
        ConfirmPaymentStartedRequest request = ConfirmPaymentStartedRequest.newBuilder().setTradeId(tradeId).build();
        this.grpcStubs.tradesService.confirmPaymentStarted(request);
    }

    public void confirmPaymentStartedXmr(String tradeId, String txId, String txKey) {
        ConfirmPaymentStartedXmrRequest request = ConfirmPaymentStartedXmrRequest.newBuilder().setTradeId(tradeId).setTxId(txId).setTxKey(txKey).build();
        this.grpcStubs.tradesService.confirmPaymentStartedXmr(request);
    }

    public void confirmPaymentReceived(String tradeId) {
        ConfirmPaymentReceivedRequest request = ConfirmPaymentReceivedRequest.newBuilder().setTradeId(tradeId).build();
        this.grpcStubs.tradesService.confirmPaymentReceived(request);
    }

    public void closeTrade(String tradeId) {
        CloseTradeRequest request = CloseTradeRequest.newBuilder().setTradeId(tradeId).build();
        this.grpcStubs.tradesService.closeTrade(request);
    }

    public void withdrawFunds(String tradeId, String address, String memo) {
        WithdrawFundsRequest request = WithdrawFundsRequest.newBuilder().setTradeId(tradeId).setAddress(address).setMemo(memo).build();
        this.grpcStubs.tradesService.withdrawFunds(request);
    }

    public void failTrade(String tradeId) {
        FailTradeRequest request = FailTradeRequest.newBuilder().setTradeId(tradeId).build();
        this.grpcStubs.tradesService.failTrade(request);
    }

    public void unFailTrade(String tradeId) {
        UnFailTradeRequest request = UnFailTradeRequest.newBuilder().setTradeId(tradeId).build();
        this.grpcStubs.tradesService.unFailTrade(request);
    }
}

