/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.request;

import bisq.cli.GrpcStubs;
import bisq.proto.grpc.AddressBalanceInfo;
import bisq.proto.grpc.BalancesInfo;
import bisq.proto.grpc.BsqBalanceInfo;
import bisq.proto.grpc.BtcBalanceInfo;
import bisq.proto.grpc.GetAddressBalanceRequest;
import bisq.proto.grpc.GetBalancesRequest;
import bisq.proto.grpc.GetDaoStatusRequest;
import bisq.proto.grpc.GetFundingAddressesRequest;
import bisq.proto.grpc.GetNetworkRequest;
import bisq.proto.grpc.GetTransactionRequest;
import bisq.proto.grpc.GetTransactionsRequest;
import bisq.proto.grpc.GetTxFeeRateRequest;
import bisq.proto.grpc.GetUnusedBsqAddressRequest;
import bisq.proto.grpc.LockWalletRequest;
import bisq.proto.grpc.MarketPriceRequest;
import bisq.proto.grpc.RemoveWalletPasswordRequest;
import bisq.proto.grpc.SendBsqRequest;
import bisq.proto.grpc.SendBtcRequest;
import bisq.proto.grpc.SetTxFeeRatePreferenceRequest;
import bisq.proto.grpc.SetWalletPasswordRequest;
import bisq.proto.grpc.TxFeeRateInfo;
import bisq.proto.grpc.TxInfo;
import bisq.proto.grpc.UnlockWalletRequest;
import bisq.proto.grpc.UnsetTxFeeRatePreferenceRequest;
import bisq.proto.grpc.VerifyBsqSentToAddressRequest;
import java.util.List;

public class WalletsServiceRequest {
    private final GrpcStubs grpcStubs;

    public WalletsServiceRequest(GrpcStubs grpcStubs) {
        this.grpcStubs = grpcStubs;
    }

    public String getNetwork() {
        GetNetworkRequest request = GetNetworkRequest.newBuilder().build();
        return this.grpcStubs.walletsService.getNetwork(request).getNetwork();
    }

    public boolean getDaoStatus() {
        GetDaoStatusRequest request = GetDaoStatusRequest.newBuilder().build();
        return this.grpcStubs.walletsService.getDaoStatus(request).getIsDaoStateReadyAndInSync();
    }

    public BalancesInfo getBalances() {
        return this.getBalances("");
    }

    public BsqBalanceInfo getBsqBalances() {
        return this.getBalances("BSQ").getBsq();
    }

    public BtcBalanceInfo getBtcBalances() {
        return this.getBalances("BTC").getBtc();
    }

    public BalancesInfo getBalances(String currencyCode) {
        GetBalancesRequest request = GetBalancesRequest.newBuilder().setCurrencyCode(currencyCode).build();
        return this.grpcStubs.walletsService.getBalances(request).getBalances();
    }

    public AddressBalanceInfo getAddressBalance(String address) {
        GetAddressBalanceRequest request = GetAddressBalanceRequest.newBuilder().setAddress(address).build();
        return this.grpcStubs.walletsService.getAddressBalance(request).getAddressBalanceInfo();
    }

    public double getBtcPrice(String currencyCode) {
        MarketPriceRequest request = MarketPriceRequest.newBuilder().setCurrencyCode(currencyCode).build();
        return this.grpcStubs.priceService.getMarketPrice(request).getPrice();
    }

    public List<AddressBalanceInfo> getFundingAddresses() {
        GetFundingAddressesRequest request = GetFundingAddressesRequest.newBuilder().build();
        return this.grpcStubs.walletsService.getFundingAddresses(request).getAddressBalanceInfoList();
    }

    public String getUnusedBsqAddress() {
        GetUnusedBsqAddressRequest request = GetUnusedBsqAddressRequest.newBuilder().build();
        return this.grpcStubs.walletsService.getUnusedBsqAddress(request).getAddress();
    }

    public String getUnusedBtcAddress() {
        GetFundingAddressesRequest request = GetFundingAddressesRequest.newBuilder().build();
        List addressBalances = this.grpcStubs.walletsService.getFundingAddresses(request).getAddressBalanceInfoList();
        return addressBalances.stream().filter(AddressBalanceInfo::getIsAddressUnused).findFirst().get().getAddress();
    }

    public TxInfo sendBsq(String address, String amount, String txFeeRate) {
        SendBsqRequest request = SendBsqRequest.newBuilder().setAddress(address).setAmount(amount).setTxFeeRate(txFeeRate).build();
        return this.grpcStubs.walletsService.sendBsq(request).getTxInfo();
    }

    public TxInfo sendBtc(String address, String amount, String txFeeRate, String memo) {
        SendBtcRequest request = SendBtcRequest.newBuilder().setAddress(address).setAmount(amount).setTxFeeRate(txFeeRate).setMemo(memo).build();
        return this.grpcStubs.walletsService.sendBtc(request).getTxInfo();
    }

    public boolean verifyBsqSentToAddress(String address, String amount) {
        VerifyBsqSentToAddressRequest request = VerifyBsqSentToAddressRequest.newBuilder().setAddress(address).setAmount(amount).build();
        return this.grpcStubs.walletsService.verifyBsqSentToAddress(request).getIsAmountReceived();
    }

    public TxFeeRateInfo getTxFeeRate() {
        GetTxFeeRateRequest request = GetTxFeeRateRequest.newBuilder().build();
        return this.grpcStubs.walletsService.getTxFeeRate(request).getTxFeeRateInfo();
    }

    public TxFeeRateInfo setTxFeeRate(long txFeeRate) {
        SetTxFeeRatePreferenceRequest request = SetTxFeeRatePreferenceRequest.newBuilder().setTxFeeRatePreference(txFeeRate).build();
        return this.grpcStubs.walletsService.setTxFeeRatePreference(request).getTxFeeRateInfo();
    }

    public TxFeeRateInfo unsetTxFeeRate() {
        UnsetTxFeeRatePreferenceRequest request = UnsetTxFeeRatePreferenceRequest.newBuilder().build();
        return this.grpcStubs.walletsService.unsetTxFeeRatePreference(request).getTxFeeRateInfo();
    }

    public List<TxInfo> getTransactions() {
        GetTransactionsRequest request = GetTransactionsRequest.newBuilder().build();
        return this.grpcStubs.walletsService.getTransactions(request).getTxInfoList();
    }

    public TxInfo getTransaction(String txId) {
        GetTransactionRequest request = GetTransactionRequest.newBuilder().setTxId(txId).build();
        return this.grpcStubs.walletsService.getTransaction(request).getTxInfo();
    }

    public void lockWallet() {
        LockWalletRequest request = LockWalletRequest.newBuilder().build();
        this.grpcStubs.walletsService.lockWallet(request);
    }

    public void unlockWallet(String walletPassword, long timeout) {
        UnlockWalletRequest request = UnlockWalletRequest.newBuilder().setPassword(walletPassword).setTimeout(timeout).build();
        this.grpcStubs.walletsService.unlockWallet(request);
    }

    public void removeWalletPassword(String walletPassword) {
        RemoveWalletPasswordRequest request = RemoveWalletPasswordRequest.newBuilder().setPassword(walletPassword).build();
        this.grpcStubs.walletsService.removeWalletPassword(request);
    }

    public void setWalletPassword(String walletPassword) {
        SetWalletPasswordRequest request = SetWalletPasswordRequest.newBuilder().setPassword(walletPassword).build();
        this.grpcStubs.walletsService.setWalletPassword(request);
    }

    public void setWalletPassword(String oldWalletPassword, String newWalletPassword) {
        SetWalletPasswordRequest request = SetWalletPasswordRequest.newBuilder().setPassword(oldWalletPassword).setNewPassword(newWalletPassword).build();
        this.grpcStubs.walletsService.setWalletPassword(request);
    }
}

