/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.builder;

import bisq.cli.CurrencyFormat;
import bisq.cli.table.builder.AbstractTableBuilder;
import bisq.cli.table.builder.TableType;
import bisq.cli.table.builder.TradeTableColumnSupplier;
import bisq.cli.table.column.Column;
import bisq.cli.table.column.MixedTradeFeeColumn;
import bisq.proto.grpc.ContractInfo;
import bisq.proto.grpc.TradeInfo;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import protobuf.OfferDirection;

abstract class AbstractTradeListBuilder
extends AbstractTableBuilder {
    protected final List<TradeInfo> trades;
    protected final TradeTableColumnSupplier colSupplier;
    protected final Column<String> colTradeId;
    @Nullable
    protected final Column<Long> colCreateDate;
    @Nullable
    protected final Column<String> colMarket;
    protected final Column<String> colPrice;
    @Nullable
    protected final Column<String> colPriceDeviation;
    @Nullable
    protected final Column<String> colCurrency;
    @Nullable
    protected final Column<Long> colAmount;
    @Nullable
    protected final Column<String> colMixedAmount;
    @Nullable
    protected final Column<Long> colMinerTxFee;
    @Nullable
    protected final MixedTradeFeeColumn colMixedTradeFee;
    @Nullable
    protected final Column<Long> colBuyerDeposit;
    @Nullable
    protected final Column<Long> colSellerDeposit;
    @Nullable
    protected final Column<String> colPaymentMethod;
    @Nullable
    protected final Column<String> colRole;
    @Nullable
    protected final Column<String> colOfferType;
    @Nullable
    protected final Column<String> colClosingStatus;
    @Nullable
    protected final Column<Boolean> colIsDepositPublished;
    @Nullable
    protected final Column<Boolean> colIsDepositConfirmed;
    @Nullable
    protected final Column<Boolean> colIsPayoutPublished;
    @Nullable
    protected final Column<Boolean> colIsCompleted;
    @Nullable
    protected final Column<Long> colBisqTradeFee;
    @Nullable
    protected final Column<String> colTradeCost;
    @Nullable
    protected final Column<Boolean> colIsPaymentStartedMessageSent;
    @Nullable
    protected final Column<Boolean> colIsPaymentReceivedMessageSent;
    @Nullable
    protected final Column<String> colAltcoinReceiveAddressColumn;
    @Nullable
    protected final Column<String> status;
    @Nullable
    protected final Column<String> colTxId;
    @Nullable
    protected final Column<Long> colNumConfirmations;
    private final Supplier<Boolean> isTradeDetailTblBuilder = () -> this.tableType.equals((Object)TableType.TRADE_DETAIL_TBL);
    protected final Predicate<TradeInfo> isFiatTrade = t -> this.isFiatOffer.test(t.getOffer());
    protected final Predicate<TradeInfo> isBsqTrade = t -> !this.isFiatOffer.test(t.getOffer()) && t.getOffer().getBaseCurrencyCode().equals("BSQ");
    protected final Predicate<TradeInfo> isBsqSwapTrade = t -> t.getOffer().getIsBsqSwapOffer();
    protected final Predicate<TradeInfo> isMyOffer = t -> t.getOffer().getIsMyOffer();
    protected final Predicate<TradeInfo> isTaker = t -> t.getRole().toLowerCase().contains("taker");
    protected final Predicate<TradeInfo> isSellOffer = t -> t.getOffer().getDirection().equals(OfferDirection.SELL.name());
    protected final Predicate<TradeInfo> isBtcSeller = t -> this.isMyOffer.test((TradeInfo)t) && this.isSellOffer.test((TradeInfo)t) || !this.isMyOffer.test((TradeInfo)t) && !this.isSellOffer.test((TradeInfo)t);
    protected final Predicate<TradeInfo> isTradeFeeBtc = t -> this.isMyOffer.test((TradeInfo)t) ? t.getOffer().getIsCurrencyForMakerFeeBtc() : t.getIsCurrencyForTakerFeeBtc();
    protected final Function<TradeInfo, Long> toAltcoinTradeVolumeAsLong = t -> this.isBsqTrade.test((TradeInfo)t) ? new BigDecimal(t.getTradeVolume()).movePointRight(2).longValue() : new BigDecimal(t.getTradeVolume()).movePointRight(8).longValue();
    protected final Function<TradeInfo, String> toTradeVolumeAsString = t -> this.isFiatTrade.test((TradeInfo)t) ? t.getTradeVolume() : CurrencyFormat.formatSatoshis(t.getTradeAmountAsLong());
    protected final Function<TradeInfo, Long> toTradeVolumeAsLong = t -> this.isFiatTrade.test((TradeInfo)t) ? Long.parseLong(t.getTradeVolume()) : this.toAltcoinTradeVolumeAsLong.apply((TradeInfo)t);
    protected final Function<TradeInfo, Long> toTradeAmount = t -> this.isFiatTrade.test((TradeInfo)t) ? t.getTradeAmountAsLong() : this.toTradeVolumeAsLong.apply((TradeInfo)t).longValue();
    protected final Function<TradeInfo, String> toMarket = t -> t.getOffer().getBaseCurrencyCode() + "/" + t.getOffer().getCounterCurrencyCode();
    protected final Function<TradeInfo, String> toPaymentCurrencyCode = t -> this.isFiatTrade.test((TradeInfo)t) ? t.getOffer().getCounterCurrencyCode() : t.getOffer().getBaseCurrencyCode();
    protected final Function<TradeInfo, String> toPriceDeviation = t -> t.getOffer().getUseMarketBasedPrice() ? String.format("%.2f%s", t.getOffer().getMarketPriceMarginPct(), "%") : "N/A";
    protected final Function<TradeInfo, Long> toMyMinerTxFee = t -> {
        if (this.isBsqSwapTrade.test((TradeInfo)t)) {
            return this.isBtcSeller.test((TradeInfo)t) ? t.getTxFeeAsLong() : 0L;
        }
        return this.isTaker.test((TradeInfo)t) ? t.getTxFeeAsLong() : t.getOffer().getTxFee();
    };
    protected final Function<TradeInfo, Long> toTradeFeeBsq = t -> {
        boolean isMyOffer = t.getOffer().getIsMyOffer();
        if (isMyOffer) {
            return t.getOffer().getIsCurrencyForMakerFeeBtc() ? 0L : t.getOffer().getMakerFee();
        }
        return t.getIsCurrencyForTakerFeeBtc() ? 0L : t.getTakerFeeAsLong();
    };
    protected final Function<TradeInfo, Long> toTradeFeeBtc = t -> {
        boolean isMyOffer = t.getOffer().getIsMyOffer();
        if (isMyOffer) {
            return t.getOffer().getIsCurrencyForMakerFeeBtc() ? t.getOffer().getMakerFee() : 0L;
        }
        return t.getIsCurrencyForTakerFeeBtc() ? t.getTakerFeeAsLong() : 0L;
    };
    protected final Function<TradeInfo, Long> toMyMakerOrTakerFee = t -> {
        if (this.isBsqSwapTrade.test((TradeInfo)t)) {
            return this.isTaker.test((TradeInfo)t) ? t.getBsqSwapTradeInfo().getBsqTakerTradeFee() : t.getBsqSwapTradeInfo().getBsqMakerTradeFee();
        }
        return this.isTaker.test((TradeInfo)t) ? t.getTakerFeeAsLong() : t.getOffer().getMakerFee();
    };
    protected final Function<TradeInfo, String> toOfferType = t -> {
        if (this.isFiatTrade.test((TradeInfo)t)) {
            return t.getOffer().getDirection() + " " + t.getOffer().getBaseCurrencyCode();
        }
        if (t.getOffer().getDirection().equals("BUY")) {
            return "SELL " + t.getOffer().getBaseCurrencyCode();
        }
        return "BUY " + t.getOffer().getBaseCurrencyCode();
    };
    protected final Predicate<TradeInfo> showAltCoinBuyerAddress = t -> {
        if (this.isFiatTrade.test((TradeInfo)t)) {
            return false;
        }
        ContractInfo contract = t.getContract();
        boolean isBuyerMakerAndSellerTaker = contract.getIsBuyerMakerAndSellerTaker();
        if (this.isTaker.test((TradeInfo)t)) {
            return !isBuyerMakerAndSellerTaker;
        }
        return isBuyerMakerAndSellerTaker;
    };
    protected final Function<TradeInfo, String> toAltcoinReceiveAddress = t -> {
        if (this.showAltCoinBuyerAddress.test((TradeInfo)t)) {
            ContractInfo contract = t.getContract();
            boolean isBuyerMakerAndSellerTaker = contract.getIsBuyerMakerAndSellerTaker();
            return isBuyerMakerAndSellerTaker ? contract.getTakerPaymentAccountPayload().getAddress() : contract.getMakerPaymentAccountPayload().getAddress();
        }
        return "";
    };

    AbstractTradeListBuilder(TableType tableType, List<?> protos) {
        super(tableType, protos);
        this.validate();
        this.trades = protos.stream().map(p -> (TradeInfo)p).collect(Collectors.toList());
        this.colSupplier = new TradeTableColumnSupplier(tableType, this.trades);
        this.colTradeId = this.colSupplier.tradeIdColumn.get();
        this.colCreateDate = this.colSupplier.createDateColumn.get();
        this.colMarket = this.colSupplier.marketColumn.get();
        this.colPrice = this.colSupplier.priceColumn.get();
        this.colPriceDeviation = this.colSupplier.priceDeviationColumn.get();
        this.colCurrency = this.colSupplier.currencyColumn.get();
        this.colAmount = this.colSupplier.amountColumn.get();
        this.colMixedAmount = this.colSupplier.mixedAmountColumn.get();
        this.colMinerTxFee = this.colSupplier.minerTxFeeColumn.get();
        this.colMixedTradeFee = this.colSupplier.mixedTradeFeeColumn.get();
        this.colBuyerDeposit = this.colSupplier.toSecurityDepositColumn.apply("Buyer Deposit (BTC)");
        this.colSellerDeposit = this.colSupplier.toSecurityDepositColumn.apply("Seller Deposit (BTC)");
        this.colPaymentMethod = this.colSupplier.paymentMethodColumn.get();
        this.colRole = this.colSupplier.roleColumn.get();
        this.colOfferType = this.colSupplier.offerTypeColumn.get();
        this.colClosingStatus = this.colSupplier.statusDescriptionColumn.get();
        this.colIsDepositPublished = this.colSupplier.depositPublishedColumn.get();
        this.colIsDepositConfirmed = this.colSupplier.depositConfirmedColumn.get();
        this.colIsPayoutPublished = this.colSupplier.payoutPublishedColumn.get();
        this.colIsCompleted = this.colSupplier.fundsWithdrawnColumn.get();
        this.colBisqTradeFee = this.colSupplier.bisqTradeDetailFeeColumn.get();
        this.colTradeCost = this.colSupplier.tradeCostColumn.get();
        this.colIsPaymentStartedMessageSent = this.colSupplier.paymentStartedMessageSentColumn.get();
        this.colIsPaymentReceivedMessageSent = this.colSupplier.paymentReceivedMessageSentColumn.get();
        this.colAltcoinReceiveAddressColumn = this.colSupplier.altcoinReceiveAddressColumn.get();
        this.status = this.colSupplier.bsqSwapStatusColumn.get();
        this.colTxId = this.colSupplier.bsqSwapTxIdColumn.get();
        this.colNumConfirmations = this.colSupplier.numConfirmationsColumn.get();
    }

    protected void validate() {
        if (this.isTradeDetailTblBuilder.get().booleanValue()) {
            if (this.protos.size() != 1) {
                throw new IllegalArgumentException("trade detail tbl can have only one row");
            }
        } else if (this.protos.isEmpty()) {
            throw new IllegalArgumentException("trade tbl has no rows");
        }
    }
}

