/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.builder;

import bisq.cli.table.Table;
import bisq.cli.table.builder.AbstractTableBuilder;
import bisq.cli.table.builder.TableType;
import bisq.cli.table.column.Column;
import bisq.cli.table.column.SatoshiColumn;
import bisq.proto.grpc.BsqBalanceInfo;
import java.util.List;

class BsqBalanceTableBuilder
extends AbstractTableBuilder {
    private final Column<Long> colAvailableConfirmedBalance = new SatoshiColumn("Available Confirmed Balance", true);
    private final Column<Long> colUnverifiedBalance = new SatoshiColumn("Unverified Balance", true);
    private final Column<Long> colUnconfirmedChangeBalance = new SatoshiColumn("Unconfirmed Change Balance", true);
    private final Column<Long> colLockedForVotingBalance = new SatoshiColumn("Locked For Voting Balance", true);
    private final Column<Long> colLockupBondsBalance = new SatoshiColumn("Lockup Bonds Balance", true);
    private final Column<Long> colUnlockingBondsBalance = new SatoshiColumn("Unlocking Bonds Balance", true);

    BsqBalanceTableBuilder(List<?> protos) {
        super(TableType.BSQ_BALANCE_TBL, protos);
    }

    @Override
    public Table build() {
        BsqBalanceInfo balance = (BsqBalanceInfo)this.protos.get(0);
        this.colAvailableConfirmedBalance.addRow(balance.getAvailableConfirmedBalance());
        this.colUnverifiedBalance.addRow(balance.getUnverifiedBalance());
        this.colUnconfirmedChangeBalance.addRow(balance.getUnconfirmedChangeBalance());
        this.colLockedForVotingBalance.addRow(balance.getLockedForVotingBalance());
        this.colLockupBondsBalance.addRow(balance.getLockupBondsBalance());
        this.colUnlockingBondsBalance.addRow(balance.getUnlockingBondsBalance());
        return new Table(this.colAvailableConfirmedBalance.asStringColumn(), this.colUnverifiedBalance.asStringColumn(), this.colUnconfirmedChangeBalance.asStringColumn(), this.colLockedForVotingBalance.asStringColumn(), this.colLockupBondsBalance.asStringColumn(), this.colUnlockingBondsBalance.asStringColumn());
    }
}

