/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.builder;

import bisq.cli.table.Table;
import bisq.cli.table.builder.AbstractTableBuilder;
import bisq.cli.table.builder.TableType;
import bisq.cli.table.column.Column;
import bisq.cli.table.column.SatoshiColumn;
import bisq.proto.grpc.BtcBalanceInfo;
import java.util.List;

class BtcBalanceTableBuilder
extends AbstractTableBuilder {
    private final Column<Long> colAvailableBalance = new SatoshiColumn("Available Balance");
    private final Column<Long> colReservedBalance = new SatoshiColumn("Reserved Balance");
    private final Column<Long> colTotalAvailableBalance = new SatoshiColumn("Total Available Balance");
    private final Column<Long> colLockedBalance = new SatoshiColumn("Locked Balance");

    BtcBalanceTableBuilder(List<?> protos) {
        super(TableType.BTC_BALANCE_TBL, protos);
    }

    @Override
    public Table build() {
        BtcBalanceInfo balance = (BtcBalanceInfo)this.protos.get(0);
        this.colAvailableBalance.addRow(balance.getAvailableBalance());
        this.colReservedBalance.addRow(balance.getReservedBalance());
        this.colTotalAvailableBalance.addRow(balance.getTotalAvailableBalance());
        this.colLockedBalance.addRow(balance.getLockedBalance());
        return new Table(this.colAvailableBalance.asStringColumn(), this.colReservedBalance.asStringColumn(), this.colTotalAvailableBalance.asStringColumn(), this.colLockedBalance.asStringColumn());
    }
}

