/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.builder;

import bisq.cli.table.Table;
import bisq.cli.table.builder.AbstractTradeListBuilder;
import bisq.cli.table.builder.TableType;
import java.util.List;

class ClosedTradeTableBuilder
extends AbstractTradeListBuilder {
    ClosedTradeTableBuilder(List<?> protos) {
        super(TableType.CLOSED_TRADES_TBL, protos);
    }

    @Override
    public Table build() {
        this.populateColumns();
        return new Table(this.colTradeId, this.colCreateDate.asStringColumn(), this.colMarket, this.colPrice.justify(), this.colPriceDeviation.justify(), this.colAmount.asStringColumn(), this.colMixedAmount.justify(), this.colCurrency, this.colMinerTxFee.asStringColumn(), this.colMixedTradeFee.asStringColumn(), this.colBuyerDeposit.asStringColumn(), this.colSellerDeposit.asStringColumn(), this.colOfferType, this.colClosingStatus);
    }

    private void populateColumns() {
        this.trades.forEach(t -> {
            this.colTradeId.addRow(t.getTradeId());
            this.colCreateDate.addRow(t.getDate());
            this.colMarket.addRow((String)this.toMarket.apply(t));
            this.colPrice.addRow(t.getTradePrice());
            this.colPriceDeviation.addRow((String)this.toPriceDeviation.apply(t));
            this.colAmount.addRow(t.getTradeAmountAsLong());
            this.colMixedAmount.addRow(t.getTradeVolume());
            this.colCurrency.addRow((String)this.toPaymentCurrencyCode.apply(t));
            this.colMinerTxFee.addRow((Long)this.toMyMinerTxFee.apply(t));
            if (t.getOffer().getIsBsqSwapOffer()) {
                long optionalTradeFeeBsq = this.isBtcSeller.test(t) ? 0L : (Long)this.toTradeFeeBsq.apply(t);
                this.colMixedTradeFee.addRow(optionalTradeFeeBsq, true);
            } else if (this.isTradeFeeBtc.test(t)) {
                this.colMixedTradeFee.addRow((Long)this.toTradeFeeBtc.apply(t), false);
            } else {
                this.colMixedTradeFee.addRow((Long)this.toTradeFeeBsq.apply(t), true);
            }
            this.colBuyerDeposit.addRow(t.getOffer().getBuyerSecurityDeposit());
            this.colSellerDeposit.addRow(t.getOffer().getSellerSecurityDeposit());
            this.colOfferType.addRow((String)this.toOfferType.apply(t));
            this.colClosingStatus.addRow(t.getClosingStatus());
        });
    }
}

