/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.builder;

import bisq.cli.table.Table;
import bisq.cli.table.builder.AbstractTableBuilder;
import bisq.cli.table.builder.TableType;
import bisq.cli.table.column.Column;
import bisq.cli.table.column.Iso8601DateTimeColumn;
import bisq.cli.table.column.SatoshiColumn;
import bisq.cli.table.column.StringColumn;
import bisq.cli.table.column.ZippedStringColumns;
import bisq.proto.grpc.OfferInfo;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import protobuf.OfferDirection;

class OfferTableBuilder
extends AbstractTableBuilder {
    private final Column<String> colOfferId = new StringColumn("ID", Column.JUSTIFICATION.LEFT);
    private final Column<String> colDirection = new StringColumn("Buy/Sell", Column.JUSTIFICATION.LEFT);
    private final Column<Long> colAmount = new SatoshiColumn("Temp Amount", Column.JUSTIFICATION.NONE);
    private final Column<Long> colMinAmount = new SatoshiColumn("Temp Min Amount", Column.JUSTIFICATION.NONE);
    private final Column<String> colPaymentMethod = new StringColumn("Payment Method", Column.JUSTIFICATION.LEFT);
    private final Column<Long> colCreateDate = new Iso8601DateTimeColumn("Creation Date (UTC)");
    private final Function<String, String> toBlankOrNonZeroValue = s -> s.trim().equals("0") ? "" : s;
    private final Supplier<OfferInfo> firstOfferInList = () -> (OfferInfo)this.protos.get(0);
    private final Supplier<Boolean> isShowingMyOffers = () -> this.firstOfferInList.get().getIsMyOffer();
    private final Supplier<Boolean> isShowingFiatOffers = () -> this.isFiatOffer.test(this.firstOfferInList.get());
    private final Supplier<String> fiatTradeCurrency = () -> this.firstOfferInList.get().getCounterCurrencyCode();
    private final Supplier<String> altcoinTradeCurrency = () -> this.firstOfferInList.get().getBaseCurrencyCode();
    private final Supplier<Boolean> isShowingBsqOffers = () -> !this.isFiatOffer.test(this.firstOfferInList.get()) && this.altcoinTradeCurrency.get().equals("BSQ");
    @Nullable
    private final Supplier<StringColumn> enabledColumn = () -> this.isShowingMyOffers.get() != false ? new StringColumn("Enabled", Column.JUSTIFICATION.LEFT) : null;
    @Nullable
    private final Supplier<StringColumn> fiatTriggerPriceColumn = () -> this.isShowingMyOffers.get() != false ? new StringColumn(String.format("Trigger Price(%-3s)", this.fiatTradeCurrency.get()), Column.JUSTIFICATION.RIGHT) : null;
    @Nullable
    private final Supplier<StringColumn> altcoinTriggerPriceColumn = () -> this.isShowingMyOffers.get() != false && this.isShowingBsqOffers.get() == false ? new StringColumn(String.format("Trigger Price(%-3s)", this.altcoinTradeCurrency.get()), Column.JUSTIFICATION.RIGHT) : null;
    private final Function<OfferInfo, String> toEnabled = o -> {
        if (o.getIsMyOffer() && o.getIsMyPendingOffer()) {
            return "PENDING";
        }
        return o.getIsActivated() ? "YES" : "NO";
    };
    private final Function<String, String> toMirroredDirection = d -> d.equalsIgnoreCase(OfferDirection.BUY.name()) ? OfferDirection.SELL.name() : OfferDirection.BUY.name();
    private final Function<OfferInfo, String> directionFormat = o -> {
        if (this.isFiatOffer.test(o)) {
            return o.getBaseCurrencyCode();
        }
        String direction = o.getDirection();
        String mirroredDirection = this.toMirroredDirection.apply(direction);
        Function<String, String> mixedCase = word -> word.charAt(0) + word.substring(1).toLowerCase();
        return String.format("%s %s (%s %s)", mixedCase.apply(mirroredDirection), o.getBaseCurrencyCode(), mixedCase.apply(direction), o.getCounterCurrencyCode());
    };
    private final Supplier<ZippedStringColumns> zippedAmountRangeColumns = () -> {
        if (this.colMinAmount.isEmpty() || this.colAmount.isEmpty()) {
            throw new IllegalStateException("amount columns must have data");
        }
        return new ZippedStringColumns("BTC(min - max)", Column.JUSTIFICATION.RIGHT, " - ", this.colMinAmount.asStringColumn(), this.colAmount.asStringColumn());
    };

    OfferTableBuilder(List<?> protos) {
        super(TableType.OFFER_TBL, protos);
    }

    @Override
    public Table build() {
        List<OfferInfo> offers = this.protos.stream().map(p -> (OfferInfo)p).collect(Collectors.toList());
        return this.isShowingFiatOffers.get() != false ? this.buildFiatOfferTable(offers) : this.buildCryptoCurrencyOfferTable(offers);
    }

    public Table buildFiatOfferTable(List<OfferInfo> offers) {
        Column colEnabled = this.enabledColumn.get();
        StringColumn colFiatPrice = new StringColumn(String.format("Price in %-3s for 1 BTC", this.fiatTradeCurrency.get()), Column.JUSTIFICATION.RIGHT);
        StringColumn colVolume = new StringColumn(String.format("Temp Volume (%s)", this.fiatTradeCurrency.get()), Column.JUSTIFICATION.NONE);
        StringColumn colMinVolume = new StringColumn(String.format("Temp Min Volume (%s)", this.fiatTradeCurrency.get()), Column.JUSTIFICATION.NONE);
        Column colTriggerPrice = this.fiatTriggerPriceColumn.get();
        offers.forEach(o -> {
            if (colEnabled != null) {
                colEnabled.addRow(this.toEnabled.apply((OfferInfo)o));
            }
            this.colDirection.addRow(o.getDirection());
            colFiatPrice.addRow(o.getPrice());
            this.colMinAmount.addRow(o.getMinAmount());
            this.colAmount.addRow(o.getAmount());
            colVolume.addRow(o.getVolume());
            colMinVolume.addRow(o.getMinVolume());
            if (colTriggerPrice != null) {
                colTriggerPrice.addRow(this.toBlankOrNonZeroValue.apply(o.getTriggerPrice()));
            }
            this.colPaymentMethod.addRow(o.getPaymentMethodShortName());
            this.colCreateDate.addRow(o.getDate());
            this.colOfferId.addRow(o.getId());
        });
        ZippedStringColumns amountRange = this.zippedAmountRangeColumns.get();
        ZippedStringColumns volumeRange = new ZippedStringColumns(String.format("%-3s(min - max)", this.fiatTradeCurrency.get()), Column.JUSTIFICATION.RIGHT, " - ", colMinVolume.asStringColumn(), colVolume.asStringColumn());
        if (this.isShowingMyOffers.get().booleanValue()) {
            return new Table(colEnabled.asStringColumn(), this.colDirection, colFiatPrice.justify(), amountRange.asStringColumn(ZippedStringColumns.DUPLICATION_MODE.EXCLUDE_DUPLICATES), volumeRange.asStringColumn(ZippedStringColumns.DUPLICATION_MODE.EXCLUDE_DUPLICATES), colTriggerPrice.justify(), this.colPaymentMethod, this.colCreateDate.asStringColumn(), this.colOfferId);
        }
        return new Table(this.colDirection, colFiatPrice.justify(), amountRange.asStringColumn(ZippedStringColumns.DUPLICATION_MODE.EXCLUDE_DUPLICATES), volumeRange.asStringColumn(ZippedStringColumns.DUPLICATION_MODE.EXCLUDE_DUPLICATES), this.colPaymentMethod, this.colCreateDate.asStringColumn(), this.colOfferId);
    }

    public Table buildCryptoCurrencyOfferTable(List<OfferInfo> offers) {
        Column colEnabled = this.enabledColumn.get();
        StringColumn colBtcPrice = new StringColumn(String.format("Price in BTC for 1 %-3s", this.altcoinTradeCurrency.get()), Column.JUSTIFICATION.RIGHT);
        StringColumn colVolume = new StringColumn(String.format("Temp Volume (%s)", this.altcoinTradeCurrency.get()), Column.JUSTIFICATION.NONE);
        StringColumn colMinVolume = new StringColumn(String.format("Temp Min Volume (%s)", this.altcoinTradeCurrency.get()), Column.JUSTIFICATION.NONE);
        Column colTriggerPrice = this.altcoinTriggerPriceColumn.get();
        offers.forEach(o -> {
            if (colEnabled != null) {
                colEnabled.addRow(this.toEnabled.apply((OfferInfo)o));
            }
            this.colDirection.addRow(this.directionFormat.apply((OfferInfo)o));
            colBtcPrice.addRow(o.getPrice());
            this.colAmount.addRow(o.getAmount());
            this.colMinAmount.addRow(o.getMinAmount());
            colVolume.addRow(o.getVolume());
            colMinVolume.addRow(o.getMinVolume());
            if (colTriggerPrice != null) {
                colTriggerPrice.addRow(this.toBlankOrNonZeroValue.apply(o.getTriggerPrice()));
            }
            this.colPaymentMethod.addRow(o.getPaymentMethodShortName());
            this.colCreateDate.addRow(o.getDate());
            this.colOfferId.addRow(o.getId());
        });
        ZippedStringColumns amountRange = this.zippedAmountRangeColumns.get();
        ZippedStringColumns volumeRange = new ZippedStringColumns(String.format("%-3s(min - max)", this.altcoinTradeCurrency.get()), Column.JUSTIFICATION.RIGHT, " - ", colMinVolume.asStringColumn(), colVolume.asStringColumn());
        if (this.isShowingMyOffers.get().booleanValue()) {
            if (this.isShowingBsqOffers.get().booleanValue()) {
                return new Table(colEnabled.asStringColumn(), this.colDirection, colBtcPrice.justify(), amountRange.asStringColumn(ZippedStringColumns.DUPLICATION_MODE.EXCLUDE_DUPLICATES), volumeRange.asStringColumn(ZippedStringColumns.DUPLICATION_MODE.EXCLUDE_DUPLICATES), this.colPaymentMethod, this.colCreateDate.asStringColumn(), this.colOfferId);
            }
            return new Table(colEnabled.asStringColumn(), this.colDirection, colBtcPrice.justify(), amountRange.asStringColumn(ZippedStringColumns.DUPLICATION_MODE.EXCLUDE_DUPLICATES), volumeRange.asStringColumn(ZippedStringColumns.DUPLICATION_MODE.EXCLUDE_DUPLICATES), colTriggerPrice.justify(), this.colPaymentMethod, this.colCreateDate.asStringColumn(), this.colOfferId);
        }
        return new Table(this.colDirection, colBtcPrice.justify(), amountRange.asStringColumn(ZippedStringColumns.DUPLICATION_MODE.EXCLUDE_DUPLICATES), volumeRange.asStringColumn(ZippedStringColumns.DUPLICATION_MODE.EXCLUDE_DUPLICATES), this.colPaymentMethod, this.colCreateDate.asStringColumn(), this.colOfferId);
    }
}

