/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.builder;

import bisq.cli.table.Table;
import bisq.cli.table.builder.AbstractTradeListBuilder;
import bisq.cli.table.builder.TableType;
import java.util.List;

class OpenTradeTableBuilder
extends AbstractTradeListBuilder {
    OpenTradeTableBuilder(List<?> protos) {
        super(TableType.OPEN_TRADES_TBL, protos);
    }

    @Override
    public Table build() {
        this.populateColumns();
        return new Table(this.colTradeId, this.colCreateDate.asStringColumn(), this.colMarket, this.colPrice.justify(), this.colAmount.asStringColumn(), this.colMixedAmount.justify(), this.colCurrency, this.colPaymentMethod, this.colRole);
    }

    private void populateColumns() {
        this.trades.forEach(t -> {
            this.colTradeId.addRow(t.getTradeId());
            this.colCreateDate.addRow(t.getDate());
            this.colMarket.addRow((String)this.toMarket.apply(t));
            this.colPrice.addRow(t.getTradePrice());
            this.colAmount.addRow(t.getTradeAmountAsLong());
            this.colMixedAmount.addRow(t.getTradeVolume());
            this.colCurrency.addRow((String)this.toPaymentCurrencyCode.apply(t));
            this.colPaymentMethod.addRow(t.getOffer().getPaymentMethodShortName());
            this.colRole.addRow(t.getRole());
        });
    }
}

