/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.builder;

import bisq.cli.table.Table;
import bisq.cli.table.builder.AbstractTableBuilder;
import bisq.cli.table.builder.AddressBalanceTableBuilder;
import bisq.cli.table.builder.BsqBalanceTableBuilder;
import bisq.cli.table.builder.BtcBalanceTableBuilder;
import bisq.cli.table.builder.ClosedTradeTableBuilder;
import bisq.cli.table.builder.FailedTradeTableBuilder;
import bisq.cli.table.builder.OfferTableBuilder;
import bisq.cli.table.builder.OpenTradeTableBuilder;
import bisq.cli.table.builder.PaymentAccountTableBuilder;
import bisq.cli.table.builder.TableType;
import bisq.cli.table.builder.TradeDetailTableBuilder;
import bisq.cli.table.builder.TransactionTableBuilder;
import java.util.Collections;
import java.util.List;

public class TableBuilder
extends AbstractTableBuilder {
    public TableBuilder(TableType tableType, Object proto) {
        this(tableType, Collections.singletonList(proto));
    }

    public TableBuilder(TableType tableType, List<?> protos) {
        super(tableType, protos);
    }

    @Override
    public Table build() {
        switch (this.tableType) {
            case ADDRESS_BALANCE_TBL: {
                return new AddressBalanceTableBuilder(this.protos).build();
            }
            case BSQ_BALANCE_TBL: {
                return new BsqBalanceTableBuilder(this.protos).build();
            }
            case BTC_BALANCE_TBL: {
                return new BtcBalanceTableBuilder(this.protos).build();
            }
            case CLOSED_TRADES_TBL: {
                return new ClosedTradeTableBuilder(this.protos).build();
            }
            case FAILED_TRADES_TBL: {
                return new FailedTradeTableBuilder(this.protos).build();
            }
            case OFFER_TBL: {
                return new OfferTableBuilder(this.protos).build();
            }
            case OPEN_TRADES_TBL: {
                return new OpenTradeTableBuilder(this.protos).build();
            }
            case PAYMENT_ACCOUNT_TBL: {
                return new PaymentAccountTableBuilder(this.protos).build();
            }
            case TRADE_DETAIL_TBL: {
                return new TradeDetailTableBuilder(this.protos).build();
            }
            case TRANSACTION_TBL: {
                return new TransactionTableBuilder(this.protos).build();
            }
        }
        throw new IllegalArgumentException("invalid cli table type " + this.tableType.name());
    }
}

