/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.builder;

import bisq.cli.table.Table;
import bisq.cli.table.builder.AbstractTradeListBuilder;
import bisq.cli.table.builder.TableType;
import bisq.cli.table.column.Column;
import bisq.proto.grpc.TradeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import protobuf.BsqSwapTrade;

class TradeDetailTableBuilder
extends AbstractTradeListBuilder {
    private final Predicate<TradeInfo> isPendingBsqSwap = t -> t.getState().equals(BsqSwapTrade.State.PREPARATION.name());
    private final Predicate<TradeInfo> isCompletedBsqSwap = t -> t.getState().equals(BsqSwapTrade.State.COMPLETED.name());

    TradeDetailTableBuilder(List<?> protos) {
        super(TableType.TRADE_DETAIL_TBL, protos);
    }

    @Override
    public Table build() {
        TradeInfo trade = (TradeInfo)this.trades.get(0);
        this.populateColumns(trade);
        List<Column<?>> columns = this.defineColumnList(trade);
        return new Table(columns.toArray(new Column[0]));
    }

    private void populateColumns(TradeInfo trade) {
        if (this.isBsqSwapTrade.test(trade)) {
            boolean isCompleted;
            boolean isPending = this.isPendingBsqSwap.test(trade);
            if (isPending == (isCompleted = this.isCompletedBsqSwap.test(trade))) {
                throw new IllegalStateException(String.format("programmer error: trade must be either pending or completed, is pending=%s and completed=%s", isPending, isCompleted));
            }
            this.populateBsqSwapTradeColumns(trade);
        } else {
            this.populateBisqV1TradeColumns(trade);
        }
    }

    private void populateBisqV1TradeColumns(TradeInfo trade) {
        this.colTradeId.addRow(trade.getShortId());
        this.colRole.addRow(trade.getRole());
        this.colPrice.addRow(trade.getTradePrice());
        this.colAmount.addRow((Long)this.toTradeAmount.apply(trade));
        this.colMinerTxFee.addRow((Long)this.toMyMinerTxFee.apply(trade));
        this.colBisqTradeFee.addRow((Long)this.toMyMakerOrTakerFee.apply(trade));
        this.colIsDepositPublished.addRow(trade.getIsDepositPublished());
        this.colIsDepositConfirmed.addRow(trade.getIsDepositConfirmed());
        this.colTradeCost.addRow((String)this.toTradeVolumeAsString.apply(trade));
        this.colIsPaymentStartedMessageSent.addRow(trade.getIsPaymentStartedMessageSent());
        this.colIsPaymentReceivedMessageSent.addRow(trade.getIsPaymentReceivedMessageSent());
        this.colIsPayoutPublished.addRow(trade.getIsPayoutPublished());
        this.colIsCompleted.addRow(trade.getIsCompleted());
        if (this.colAltcoinReceiveAddressColumn != null) {
            this.colAltcoinReceiveAddressColumn.addRow((String)this.toAltcoinReceiveAddress.apply(trade));
        }
    }

    private void populateBsqSwapTradeColumns(TradeInfo trade) {
        this.colTradeId.addRow(trade.getShortId());
        this.colRole.addRow(trade.getRole());
        this.colPrice.addRow(trade.getTradePrice());
        this.colAmount.addRow((Long)this.toTradeAmount.apply(trade));
        this.colMinerTxFee.addRow((Long)this.toMyMinerTxFee.apply(trade));
        this.colBisqTradeFee.addRow((Long)this.toMyMakerOrTakerFee.apply(trade));
        this.colTradeCost.addRow((String)this.toTradeVolumeAsString.apply(trade));
        boolean isCompleted = this.isCompletedBsqSwap.test(trade);
        this.status.addRow(isCompleted ? "COMPLETED" : "PENDING");
        if (isCompleted) {
            this.colTxId.addRow(trade.getBsqSwapTradeInfo().getTxId());
            this.colNumConfirmations.addRow(trade.getBsqSwapTradeInfo().getNumConfirmations());
        }
    }

    private List<Column<?>> defineColumnList(TradeInfo trade) {
        return this.isBsqSwapTrade.test(trade) ? this.getBsqSwapTradeColumnList(this.isCompletedBsqSwap.test(trade)) : this.getBisqV1TradeColumnList();
    }

    private List<Column<?>> getBisqV1TradeColumnList() {
        ArrayList columns = new ArrayList<Column<?>>(){
            {
                this.add(TradeDetailTableBuilder.this.colTradeId);
                this.add(TradeDetailTableBuilder.this.colRole);
                this.add(TradeDetailTableBuilder.this.colPrice.justify());
                this.add(TradeDetailTableBuilder.this.colAmount.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colMinerTxFee.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colBisqTradeFee.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colIsDepositPublished.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colIsDepositConfirmed.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colTradeCost.justify());
                this.add(TradeDetailTableBuilder.this.colIsPaymentStartedMessageSent.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colIsPaymentReceivedMessageSent.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colIsPayoutPublished.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colIsCompleted.asStringColumn());
            }
        };
        if (this.colAltcoinReceiveAddressColumn != null) {
            columns.add(this.colAltcoinReceiveAddressColumn);
        }
        return columns;
    }

    private List<Column<?>> getBsqSwapTradeColumnList(boolean isCompleted) {
        ArrayList columns = new ArrayList<Column<?>>(){
            {
                this.add(TradeDetailTableBuilder.this.colTradeId);
                this.add(TradeDetailTableBuilder.this.colRole);
                this.add(TradeDetailTableBuilder.this.colPrice.justify());
                this.add(TradeDetailTableBuilder.this.colAmount.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colMinerTxFee.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colBisqTradeFee.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colTradeCost.justify());
                this.add(TradeDetailTableBuilder.this.status);
            }
        };
        if (isCompleted) {
            columns.add(this.colTxId);
        }
        if (!this.colNumConfirmations.isEmpty()) {
            columns.add(this.colNumConfirmations.asStringColumn());
        }
        return columns;
    }
}

