/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.builder;

import bisq.cli.table.builder.TableType;
import bisq.cli.table.column.AltcoinVolumeColumn;
import bisq.cli.table.column.BooleanColumn;
import bisq.cli.table.column.BtcColumn;
import bisq.cli.table.column.Column;
import bisq.cli.table.column.Iso8601DateTimeColumn;
import bisq.cli.table.column.LongColumn;
import bisq.cli.table.column.MixedTradeFeeColumn;
import bisq.cli.table.column.SatoshiColumn;
import bisq.cli.table.column.StringColumn;
import bisq.proto.grpc.ContractInfo;
import bisq.proto.grpc.OfferInfo;
import bisq.proto.grpc.TradeInfo;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TradeTableColumnSupplier {
    private static final Logger log = LoggerFactory.getLogger(TradeTableColumnSupplier.class);
    private final TableType tableType;
    private final List<TradeInfo> trades;
    private final Supplier<Boolean> isTradeDetailTblBuilder = () -> this.getTableType().equals((Object)TableType.TRADE_DETAIL_TBL);
    private final Supplier<Boolean> isOpenTradeTblBuilder = () -> this.getTableType().equals((Object)TableType.OPEN_TRADES_TBL);
    private final Supplier<Boolean> isClosedTradeTblBuilder = () -> this.getTableType().equals((Object)TableType.CLOSED_TRADES_TBL);
    private final Supplier<Boolean> isFailedTradeTblBuilder = () -> this.getTableType().equals((Object)TableType.FAILED_TRADES_TBL);
    private final Supplier<TradeInfo> firstRow = () -> this.getTrades().get(0);
    private final Predicate<OfferInfo> isFiatOffer = o -> o.getBaseCurrencyCode().equals("BTC");
    private final Predicate<TradeInfo> isFiatTrade = t -> this.isFiatOffer.test(t.getOffer());
    private final Predicate<TradeInfo> isBsqSwapTrade = t -> t.getOffer().getIsBsqSwapOffer();
    private final Predicate<TradeInfo> isTaker = t -> t.getRole().toLowerCase().contains("taker");
    private final Supplier<Boolean> isSwapTradeDetail = () -> this.isTradeDetailTblBuilder.get() != false && this.isBsqSwapTrade.test(this.firstRow.get());
    final Supplier<StringColumn> tradeIdColumn = () -> this.isTradeDetailTblBuilder.get() != false ? new StringColumn("ID") : new StringColumn("Trade ID");
    final Supplier<Iso8601DateTimeColumn> createDateColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new Iso8601DateTimeColumn("Date/Time (UTC)");
    final Supplier<StringColumn> marketColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new StringColumn("Market");
    private final Function<TradeInfo, Column<String>> toDetailedPriceColumn = t -> {
        String colHeader = this.isFiatTrade.test((TradeInfo)t) ? String.format("Price in %-3s for 1 BTC", t.getOffer().getCounterCurrencyCode()) : String.format("Price in BTC for 1 %-3s", t.getOffer().getBaseCurrencyCode());
        return new StringColumn(colHeader, Column.JUSTIFICATION.RIGHT);
    };
    final Supplier<Column<String>> priceColumn = () -> this.isTradeDetailTblBuilder.get() != false ? this.toDetailedPriceColumn.apply(this.firstRow.get()) : new StringColumn("Price", Column.JUSTIFICATION.RIGHT);
    final Supplier<Column<String>> priceDeviationColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new StringColumn("Deviation", Column.JUSTIFICATION.RIGHT);
    final Supplier<StringColumn> currencyColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new StringColumn("Currency");
    private final Function<TradeInfo, Column<Long>> toDetailedAmountColumn = t -> {
        String headerCurrencyCode = t.getOffer().getBaseCurrencyCode();
        String colHeader = String.format("Amount(%-3s)", headerCurrencyCode);
        AltcoinVolumeColumn.DISPLAY_MODE displayMode = headerCurrencyCode.equals("BSQ") ? AltcoinVolumeColumn.DISPLAY_MODE.BSQ_VOLUME : AltcoinVolumeColumn.DISPLAY_MODE.ALTCOIN_VOLUME;
        return this.isFiatTrade.test((TradeInfo)t) ? new SatoshiColumn(colHeader) : new AltcoinVolumeColumn(colHeader, displayMode);
    };
    final Supplier<Column<Long>> amountColumn = () -> this.isTradeDetailTblBuilder.get() != false ? this.toDetailedAmountColumn.apply(this.firstRow.get()) : new BtcColumn("Amount in BTC");
    final Supplier<StringColumn> mixedAmountColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new StringColumn("Amount", Column.JUSTIFICATION.RIGHT);
    final Supplier<Column<Long>> minerTxFeeColumn = () -> this.isTradeDetailTblBuilder.get() != false || this.isClosedTradeTblBuilder.get() != false ? new SatoshiColumn("Tx Fee (BTC)") : null;
    final Supplier<MixedTradeFeeColumn> mixedTradeFeeColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new MixedTradeFeeColumn("Trade Fee");
    final Supplier<StringColumn> paymentMethodColumn = () -> this.isTradeDetailTblBuilder.get() != false || this.isClosedTradeTblBuilder.get() != false ? null : new StringColumn("Payment Method", Column.JUSTIFICATION.LEFT);
    final Supplier<StringColumn> roleColumn = () -> {
        if (this.isSwapTradeDetail.get().booleanValue()) {
            return new StringColumn("My BSQ Swap Role");
        }
        return this.isTradeDetailTblBuilder.get() != false || this.isOpenTradeTblBuilder.get() != false || this.isFailedTradeTblBuilder.get() != false ? new StringColumn("My Role") : null;
    };
    final Function<String, Column<Long>> toSecurityDepositColumn = name -> this.isClosedTradeTblBuilder.get() != false ? new SatoshiColumn((String)name) : null;
    final Supplier<StringColumn> offerTypeColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new StringColumn("Offer Type");
    final Supplier<StringColumn> statusDescriptionColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new StringColumn("Status");
    private final Function<String, Column<Boolean>> toBooleanColumn = BooleanColumn::new;
    final Supplier<Column<Boolean>> depositPublishedColumn = () -> {
        if (this.isSwapTradeDetail.get().booleanValue()) {
            return null;
        }
        return this.isTradeDetailTblBuilder.get() != false ? this.toBooleanColumn.apply("Deposit Published") : null;
    };
    final Supplier<Column<Boolean>> depositConfirmedColumn = () -> {
        if (this.isSwapTradeDetail.get().booleanValue()) {
            return null;
        }
        return this.isTradeDetailTblBuilder.get() != false ? this.toBooleanColumn.apply("Deposit Confirmed") : null;
    };
    final Supplier<Column<Boolean>> payoutPublishedColumn = () -> {
        if (this.isSwapTradeDetail.get().booleanValue()) {
            return null;
        }
        return this.isTradeDetailTblBuilder.get() != false ? this.toBooleanColumn.apply("Payout Published") : null;
    };
    final Supplier<Column<Boolean>> fundsWithdrawnColumn = () -> {
        if (this.isSwapTradeDetail.get().booleanValue()) {
            return null;
        }
        return this.isTradeDetailTblBuilder.get() != false ? this.toBooleanColumn.apply("Withdrawn") : null;
    };
    final Supplier<Column<Long>> bisqTradeDetailFeeColumn = () -> {
        if (this.isTradeDetailTblBuilder.get().booleanValue()) {
            TradeInfo t = this.firstRow.get();
            String headerCurrencyCode = this.isTaker.test(t) ? (t.getIsCurrencyForTakerFeeBtc() ? "BTC" : "BSQ") : (t.getOffer().getIsCurrencyForMakerFeeBtc() ? "BTC" : "BSQ");
            String colHeader = this.isTaker.test(t) ? String.format("Taker Fee(%-3s)", headerCurrencyCode) : String.format("Maker Fee(%-3s)", headerCurrencyCode);
            boolean isBsqSatoshis = headerCurrencyCode.equals("BSQ");
            return new SatoshiColumn(colHeader, isBsqSatoshis);
        }
        return null;
    };
    final Function<TradeInfo, String> toPaymentCurrencyCode = t -> this.isFiatTrade.test((TradeInfo)t) ? t.getOffer().getCounterCurrencyCode() : t.getOffer().getBaseCurrencyCode();
    final Supplier<Column<Boolean>> paymentStartedMessageSentColumn = () -> {
        if (this.isTradeDetailTblBuilder.get().booleanValue()) {
            String headerCurrencyCode = this.toPaymentCurrencyCode.apply(this.firstRow.get());
            String colHeader = String.format("%-3s Sent", headerCurrencyCode);
            return new BooleanColumn(colHeader);
        }
        return null;
    };
    final Supplier<Column<Boolean>> paymentReceivedMessageSentColumn = () -> {
        if (this.isTradeDetailTblBuilder.get().booleanValue()) {
            String headerCurrencyCode = this.toPaymentCurrencyCode.apply(this.firstRow.get());
            String colHeader = String.format("%-3s Received", headerCurrencyCode);
            return new BooleanColumn(colHeader);
        }
        return null;
    };
    final Supplier<Column<String>> tradeCostColumn = () -> {
        if (this.isTradeDetailTblBuilder.get().booleanValue()) {
            TradeInfo t = this.firstRow.get();
            String headerCurrencyCode = t.getOffer().getCounterCurrencyCode();
            String colHeader = String.format("Buyer Cost(%-3s)", headerCurrencyCode);
            return new StringColumn(colHeader, Column.JUSTIFICATION.RIGHT);
        }
        return null;
    };
    final Supplier<Column<String>> bsqSwapTxIdColumn = () -> this.isSwapTradeDetail.get() != false ? new StringColumn("Tx ID") : null;
    final Supplier<Column<String>> bsqSwapStatusColumn = () -> this.isSwapTradeDetail.get() != false ? new StringColumn("Status") : null;
    final Supplier<Column<Long>> numConfirmationsColumn = () -> this.isSwapTradeDetail.get() != false ? new LongColumn("Confirmations") : null;
    final Predicate<TradeInfo> showAltCoinBuyerAddress = t -> {
        if (this.isFiatTrade.test((TradeInfo)t)) {
            return false;
        }
        ContractInfo contract = t.getContract();
        boolean isBuyerMakerAndSellerTaker = contract.getIsBuyerMakerAndSellerTaker();
        if (this.isTaker.test((TradeInfo)t)) {
            return !isBuyerMakerAndSellerTaker;
        }
        return isBuyerMakerAndSellerTaker;
    };
    @Nullable
    final Supplier<Column<String>> altcoinReceiveAddressColumn = () -> {
        if (this.isTradeDetailTblBuilder.get().booleanValue()) {
            TradeInfo t = this.firstRow.get();
            if (this.showAltCoinBuyerAddress.test(t)) {
                String headerCurrencyCode = this.toPaymentCurrencyCode.apply(t);
                String colHeader = String.format("%-3s Buyer Address", headerCurrencyCode);
                return new StringColumn(colHeader);
            }
            return null;
        }
        return null;
    };

    public TradeTableColumnSupplier(TableType tableType, List<TradeInfo> trades) {
        this.tableType = tableType;
        this.trades = trades;
    }

    public TableType getTableType() {
        return this.tableType;
    }

    public List<TradeInfo> getTrades() {
        return this.trades;
    }
}

