/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.builder;

import bisq.cli.table.Table;
import bisq.cli.table.builder.AbstractTableBuilder;
import bisq.cli.table.builder.TableType;
import bisq.cli.table.column.BooleanColumn;
import bisq.cli.table.column.Column;
import bisq.cli.table.column.LongColumn;
import bisq.cli.table.column.SatoshiColumn;
import bisq.cli.table.column.StringColumn;
import bisq.proto.grpc.TxInfo;
import java.util.List;

class TransactionTableBuilder
extends AbstractTableBuilder {
    private final Column<String> colTxId = new StringColumn("Tx ID");
    private final Column<Boolean> colIsConfirmed = new BooleanColumn("Is Confirmed");
    private final Column<Long> colInputSum = new SatoshiColumn("Tx Inputs (BTC)");
    private final Column<Long> colOutputSum = new SatoshiColumn("Tx Outputs (BTC)");
    private final Column<Long> colTxFee = new SatoshiColumn("Tx Fee (BTC)");
    private final Column<Long> colTxSize = new LongColumn("Tx Size (Bytes)");
    private final Column<String> colMemo = new StringColumn("Memo");

    TransactionTableBuilder(List<?> protos) {
        super(TableType.TRANSACTION_TBL, protos);
    }

    @Override
    public Table build() {
        this.protos.stream().forEach(p -> {
            TxInfo tx = (TxInfo)p;
            this.colTxId.addRow(tx.getTxId());
            this.colIsConfirmed.addRow(!tx.getIsPending());
            this.colInputSum.addRow(tx.getInputSum());
            this.colOutputSum.addRow(tx.getOutputSum());
            this.colTxFee.addRow(tx.getFee());
            this.colTxSize.addRow(Long.valueOf(tx.getSize()));
            this.colMemo.addRow(tx.getMemo());
        });
        if (this.colMemo != null) {
            return new Table(this.colTxId, this.colIsConfirmed.asStringColumn(), this.colInputSum.asStringColumn(), this.colOutputSum.asStringColumn(), this.colTxFee.asStringColumn(), this.colTxSize.asStringColumn(), this.colMemo);
        }
        return new Table(this.colTxId, this.colIsConfirmed.asStringColumn(), this.colInputSum.asStringColumn(), this.colOutputSum.asStringColumn(), this.colTxFee.asStringColumn(), this.colTxSize.asStringColumn());
    }
}

