/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.column;

import bisq.cli.table.column.Column;
import bisq.cli.table.column.NumberColumn;
import bisq.cli.table.column.StringColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public class DoubleColumn
extends NumberColumn<DoubleColumn, Double> {
    protected final List<Double> rows = new ArrayList<Double>();
    protected final Predicate<String> isNewMaxWidth = s -> s != null && !s.isEmpty() && s.length() > this.maxWidth;

    public DoubleColumn(String name) {
        this(name, Column.JUSTIFICATION.RIGHT);
    }

    public DoubleColumn(String name, Column.JUSTIFICATION justification) {
        super(name, justification);
        this.maxWidth = name.length();
    }

    @Override
    public void addRow(Double value) {
        this.rows.add(value);
        String s = String.valueOf(value);
        if (this.isNewMaxWidth.test(s)) {
            this.maxWidth = s.length();
        }
    }

    @Override
    public List<Double> getRows() {
        return this.rows;
    }

    @Override
    public int rowCount() {
        return this.rows.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public Double getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    @Override
    public void updateRow(int rowIndex, Double newValue) {
        this.rows.set(rowIndex, newValue);
    }

    @Override
    public String getRowAsFormattedString(int rowIndex) {
        String s = String.valueOf(this.getRow(rowIndex));
        return this.toJustifiedString(s);
    }

    @Override
    public StringColumn asStringColumn() {
        IntStream.range(0, this.rows.size()).forEachOrdered(rowIndex -> this.stringColumn.addRow(this.getRowAsFormattedString(rowIndex)));
        return this.stringColumn;
    }
}

