/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.column;

import bisq.cli.CurrencyFormat;
import bisq.cli.table.column.Column;
import bisq.cli.table.column.LongColumn;
import bisq.cli.table.column.StringColumn;
import java.util.stream.IntStream;

public class FiatColumn
extends LongColumn {
    private final DISPLAY_MODE displayMode;

    public FiatColumn(String name) {
        this(name, Column.JUSTIFICATION.RIGHT, DISPLAY_MODE.FIAT_PRICE);
    }

    public FiatColumn(String name, DISPLAY_MODE displayMode) {
        this(name, Column.JUSTIFICATION.RIGHT, displayMode);
    }

    public FiatColumn(String name, Column.JUSTIFICATION justification, DISPLAY_MODE displayMode) {
        super(name, justification);
        this.displayMode = displayMode;
    }

    @Override
    public void addRow(Long value) {
        this.rows.add(value);
        String s = this.displayMode.equals((Object)DISPLAY_MODE.FIAT_PRICE) ? CurrencyFormat.formatPrice(value) : CurrencyFormat.formatFiatVolume(value);
        this.stringColumn.addRow(s);
        if (this.isNewMaxWidth.test(s)) {
            this.maxWidth = s.length();
        }
    }

    @Override
    public String getRowAsFormattedString(int rowIndex) {
        return this.getRow(rowIndex).toString();
    }

    @Override
    public StringColumn asStringColumn() {
        IntStream.range(0, this.stringColumn.getRows().size()).forEach(rowIndex -> {
            String unjustified = this.stringColumn.getRow(rowIndex);
            String justified = this.stringColumn.toJustifiedString(unjustified);
            this.stringColumn.updateRow(rowIndex, justified);
        });
        return this.stringColumn;
    }

    public static enum DISPLAY_MODE {
        FIAT_PRICE,
        FIAT_VOLUME;

    }
}

