/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.column;

import bisq.cli.table.column.Column;
import bisq.cli.table.column.LongColumn;
import bisq.cli.table.column.StringColumn;
import com.google.common.base.Strings;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.stream.IntStream;

public class Iso8601DateTimeColumn
extends LongColumn {
    protected final SimpleDateFormat iso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public Iso8601DateTimeColumn(String name) {
        this(name, Column.JUSTIFICATION.LEFT);
    }

    public Iso8601DateTimeColumn(String name, Column.JUSTIFICATION justification) {
        super(name, justification);
        this.iso8601DateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.maxWidth = Math.max(name.length(), String.valueOf(System.currentTimeMillis()).length());
    }

    @Override
    public String getRowAsFormattedString(int rowIndex) {
        long time = this.getRow(rowIndex);
        return this.justification.equals((Object)Column.JUSTIFICATION.LEFT) ? Strings.padEnd((String)this.iso8601DateFormat.format(new Date(time)), (int)this.maxWidth, (char)' ') : Strings.padStart((String)this.iso8601DateFormat.format(new Date(time)), (int)this.maxWidth, (char)' ');
    }

    @Override
    public StringColumn asStringColumn() {
        IntStream.range(0, this.rows.size()).forEachOrdered(rowIndex -> this.stringColumn.addRow(this.getRowAsFormattedString(rowIndex)));
        return this.stringColumn;
    }
}

