/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.column;

import bisq.cli.CurrencyFormat;
import bisq.cli.table.column.Column;
import bisq.cli.table.column.LongColumn;
import bisq.cli.table.column.StringColumn;

public class MixedTradeFeeColumn
extends LongColumn {
    public MixedTradeFeeColumn(String name) {
        super(name, Column.JUSTIFICATION.RIGHT);
    }

    @Override
    public void addRow(Long value) {
        throw new UnsupportedOperationException("use public void addRow(Long value, boolean isBsq) instead");
    }

    public void addRow(Long value, boolean isBsq) {
        this.rows.add(value);
        String s = isBsq ? CurrencyFormat.formatBsq(value) + " BSQ" : CurrencyFormat.formatSatoshis(value) + " BTC";
        this.stringColumn.addRow(s);
        if (this.isNewMaxWidth.test(s)) {
            this.maxWidth = s.length();
        }
    }

    @Override
    public String getRowAsFormattedString(int rowIndex) {
        return this.getRow(rowIndex).toString();
    }

    @Override
    public StringColumn asStringColumn() {
        return this.stringColumn.justify();
    }
}

