/*
 * Decompiled with CFR 0.152.
 */
package bisq.cli.table.column;

import bisq.cli.CurrencyFormat;
import bisq.cli.table.column.Column;
import bisq.cli.table.column.LongColumn;
import bisq.cli.table.column.StringColumn;

public class SatoshiColumn
extends LongColumn {
    protected final boolean isBsqSatoshis;

    public SatoshiColumn(String name) {
        this(name, Column.JUSTIFICATION.RIGHT, false);
    }

    public SatoshiColumn(String name, boolean isBsqSatoshis) {
        this(name, Column.JUSTIFICATION.RIGHT, isBsqSatoshis);
    }

    public SatoshiColumn(String name, Column.JUSTIFICATION justification) {
        this(name, justification, false);
    }

    public SatoshiColumn(String name, Column.JUSTIFICATION justification, boolean isBsqSatoshis) {
        super(name, justification);
        this.isBsqSatoshis = isBsqSatoshis;
    }

    @Override
    public void addRow(Long value) {
        this.rows.add(value);
        String s = this.isBsqSatoshis ? CurrencyFormat.formatBsq(value) : CurrencyFormat.formatSatoshis(value);
        this.stringColumn.addRow(s);
        if (this.isNewMaxWidth.test(s)) {
            this.maxWidth = s.length();
        }
    }

    @Override
    public String getRowAsFormattedString(int rowIndex) {
        return this.isBsqSatoshis ? CurrencyFormat.formatBsq(this.getRow(rowIndex)) : CurrencyFormat.formatSatoshis(this.getRow(rowIndex));
    }

    @Override
    public StringColumn asStringColumn() {
        return this.stringColumn.justify();
    }
}

