/*
 * Decompiled with CFR 0.152.
 */
package dev.matrixlab.webp4j;

import dev.matrixlab.webp4j.NativeWebP;
import dev.matrixlab.webp4j.VP8StatusCode;
import dev.matrixlab.webp4j.WebPBitstreamFeatures;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.Arrays;

public final class WebPCodec {
    private static final NativeWebP nativeWebP = new NativeWebP();

    private WebPCodec() {
        throw new AssertionError((Object)"Cannot instantiate utility class.");
    }

    public static int[] getWebPInfo(byte[] webPData) throws IOException {
        int[] dimensions = new int[2];
        boolean success = nativeWebP.getInfo(webPData, dimensions);
        if (!success) {
            throw new IOException("Failed to retrieve WebP image information.");
        }
        return dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encodeImage(BufferedImage bufferedImage, float quality, boolean lossless) throws IOException {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("The input BufferedImage cannot be null.");
        }
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        byte[] imageBytes = WebPCodec.convertBufferedImageToBytes(bufferedImage);
        if (imageBytes.length == 0) {
            throw new IOException("Failed to convert BufferedImage to a byte array.");
        }
        bufferedImage.flush();
        boolean hasAlpha = bufferedImage.getColorModel().hasAlpha();
        int stride = width * (hasAlpha ? 4 : 3);
        try {
            byte[] encodedWebP = WebPCodec.encodeWithNativeLibrary(imageBytes, width, height, stride, quality, lossless, hasAlpha);
            if (encodedWebP == null || encodedWebP.length == 0) {
                String encodingType = lossless ? "Lossless" : "Lossy";
                throw new IOException(encodingType + " WebP encoding failed.");
            }
            byte[] byArray = encodedWebP;
            return byArray;
        }
        finally {
            Arrays.fill(imageBytes, (byte)0);
        }
    }

    public static byte[] encodeImage(BufferedImage bufferedImage, float quality) throws IOException {
        return WebPCodec.encodeImage(bufferedImage, quality, false);
    }

    public static byte[] encodeLosslessImage(BufferedImage bufferedImage) throws IOException {
        return WebPCodec.encodeImage(bufferedImage, 0.0f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage decodeImage(byte[] webPData) throws IOException {
        if (webPData == null || webPData.length == 0) {
            throw new IllegalArgumentException("The input WebP data cannot be null or empty.");
        }
        int[] dimensions = WebPCodec.getWebPInfo(webPData);
        int width = dimensions[0];
        int height = dimensions[1];
        WebPBitstreamFeatures features = new WebPBitstreamFeatures();
        int status = nativeWebP.getFeatures(webPData, webPData.length, features);
        VP8StatusCode code = VP8StatusCode.getStatusCode(status);
        if (code != VP8StatusCode.VP8_STATUS_OK) {
            throw new IOException("Failed to get WebP bitstream features, error code: " + (Object)((Object)code));
        }
        boolean hasAlpha = features.hasAlpha;
        int outputStride = width * (hasAlpha ? 4 : 3);
        byte[] outputBuffer = new byte[height * outputStride];
        try {
            boolean success;
            boolean bl = success = hasAlpha ? nativeWebP.decodeRGBAInto(webPData, outputBuffer, outputStride) : nativeWebP.decodeRGBInto(webPData, outputBuffer, outputStride);
            if (!success) {
                throw new IOException("Failed to decode WebP data into RGB buffer.");
            }
            BufferedImage bufferedImage = WebPCodec.convertBytesToBufferedImage(width, height, outputBuffer);
            return bufferedImage;
        }
        finally {
            Arrays.fill(outputBuffer, (byte)0);
            outputBuffer = null;
        }
    }

    private static byte[] encodeWithNativeLibrary(byte[] imageBytes, int width, int height, int stride, float quality, boolean lossless, boolean hasAlpha) {
        if (lossless) {
            return hasAlpha ? nativeWebP.encodeLosslessRGBA(imageBytes, width, height, stride) : nativeWebP.encodeLosslessRGB(imageBytes, width, height, stride);
        }
        return hasAlpha ? nativeWebP.encodeRGBA(imageBytes, width, height, stride, quality) : nativeWebP.encodeRGB(imageBytes, width, height, stride, quality);
    }

    private static BufferedImage convertBytesToBufferedImage(int width, int height, byte[] outputBuffer) {
        boolean hasAlpha = outputBuffer.length == width * height * 4;
        int imageType = hasAlpha ? 2 : 1;
        BufferedImage image = new BufferedImage(width, height, imageType);
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int index = 0;
        int pixelIndex = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int r = outputBuffer[index++] & 0xFF;
                int g = outputBuffer[index++] & 0xFF;
                int b = outputBuffer[index++] & 0xFF;
                int a = hasAlpha ? outputBuffer[index++] & 0xFF : 255;
                pixels[pixelIndex++] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        outputBuffer = null;
        return image;
    }

    private static byte[] convertBufferedImageToBytes(BufferedImage image) {
        boolean hasAlpha = image.getColorModel().hasAlpha();
        int width = image.getWidth();
        int height = image.getHeight();
        int bytesPerPixel = hasAlpha ? 4 : 3;
        byte[] output = new byte[width * height * bytesPerPixel];
        int imageType = image.getType();
        try {
            switch (imageType) {
                case 1: 
                case 2: 
                case 3: {
                    DataBuffer dataBuffer = image.getRaster().getDataBuffer();
                    if (dataBuffer instanceof DataBufferInt) {
                        int[] intPixels = ((DataBufferInt)dataBuffer).getData();
                        if (hasAlpha) {
                            int index = 0;
                            for (int i = 0; i < intPixels.length; ++i) {
                                int pixel = intPixels[i];
                                output[index++] = (byte)(pixel >> 16 & 0xFF);
                                output[index++] = (byte)(pixel >> 8 & 0xFF);
                                output[index++] = (byte)(pixel & 0xFF);
                                output[index++] = (byte)(pixel >> 24 & 0xFF);
                            }
                        } else {
                            int index = 0;
                            for (int i = 0; i < intPixels.length; ++i) {
                                int pixel = intPixels[i];
                                output[index++] = (byte)(pixel >> 16 & 0xFF);
                                output[index++] = (byte)(pixel >> 8 & 0xFF);
                                output[index++] = (byte)(pixel & 0xFF);
                            }
                        }
                        break;
                    }
                    WebPCodec.processImageByRows(image, output, width, height, hasAlpha);
                    break;
                }
                case 4: {
                    DataBuffer dataBuffer = image.getRaster().getDataBuffer();
                    if (dataBuffer instanceof DataBufferInt) {
                        int[] bgrIntPixels = ((DataBufferInt)dataBuffer).getData();
                        int index = 0;
                        for (int i = 0; i < bgrIntPixels.length; ++i) {
                            int pixel = bgrIntPixels[i];
                            output[index++] = (byte)(pixel & 0xFF);
                            output[index++] = (byte)(pixel >> 8 & 0xFF);
                            output[index++] = (byte)(pixel >> 16 & 0xFF);
                            if (!hasAlpha) continue;
                            output[index++] = (byte)(pixel >> 24 & 0xFF);
                        }
                        break;
                    }
                    WebPCodec.processImageByRows(image, output, width, height, hasAlpha);
                    break;
                }
                case 5: {
                    DataBuffer dataBuffer = image.getRaster().getDataBuffer();
                    if (dataBuffer instanceof DataBufferByte) {
                        int i;
                        byte[] bgrBytes = ((DataBufferByte)dataBuffer).getData();
                        int index = 0;
                        int maxIndex = bgrBytes.length - 2;
                        for (i = 0; i < maxIndex - 8; i += 9) {
                            output[index++] = bgrBytes[i + 2];
                            output[index++] = bgrBytes[i + 1];
                            output[index++] = bgrBytes[i];
                            output[index++] = bgrBytes[i + 5];
                            output[index++] = bgrBytes[i + 4];
                            output[index++] = bgrBytes[i + 3];
                            output[index++] = bgrBytes[i + 8];
                            output[index++] = bgrBytes[i + 7];
                            output[index++] = bgrBytes[i + 6];
                        }
                        while (i < bgrBytes.length) {
                            output[index++] = bgrBytes[i + 2];
                            output[index++] = bgrBytes[i + 1];
                            output[index++] = bgrBytes[i];
                            i += 3;
                        }
                        break;
                    }
                    WebPCodec.processImageByRows(image, output, width, height, hasAlpha);
                    break;
                }
                case 6: 
                case 7: {
                    DataBuffer dataBuffer = image.getRaster().getDataBuffer();
                    if (dataBuffer instanceof DataBufferByte) {
                        byte[] abgrBytes = ((DataBufferByte)dataBuffer).getData();
                        if (hasAlpha) {
                            int i;
                            int index = 0;
                            int maxIndex = abgrBytes.length - 7;
                            for (i = 0; i < maxIndex; i += 8) {
                                output[index++] = abgrBytes[i + 3];
                                output[index++] = abgrBytes[i + 2];
                                output[index++] = abgrBytes[i + 1];
                                output[index++] = abgrBytes[i];
                                output[index++] = abgrBytes[i + 7];
                                output[index++] = abgrBytes[i + 6];
                                output[index++] = abgrBytes[i + 5];
                                output[index++] = abgrBytes[i + 4];
                            }
                            while (i < abgrBytes.length) {
                                output[index++] = abgrBytes[i + 3];
                                output[index++] = abgrBytes[i + 2];
                                output[index++] = abgrBytes[i + 1];
                                output[index++] = abgrBytes[i];
                                i += 4;
                            }
                        } else {
                            int index = 0;
                            for (int i = 0; i < abgrBytes.length; i += 4) {
                                output[index++] = abgrBytes[i + 3];
                                output[index++] = abgrBytes[i + 2];
                                output[index++] = abgrBytes[i + 1];
                            }
                        }
                        break;
                    }
                    WebPCodec.processImageByRows(image, output, width, height, hasAlpha);
                    break;
                }
                default: {
                    WebPCodec.processImageByRows(image, output, width, height, hasAlpha);
                }
            }
        }
        catch (Exception e) {
            WebPCodec.processImageByRows(image, output, width, height, hasAlpha);
        }
        return output;
    }

    private static void processImageByRows(BufferedImage image, byte[] output, int width, int height, boolean hasAlpha) {
        int[] rowBuffer = new int[width];
        int index = 0;
        int bytesPerPixel = hasAlpha ? 4 : 3;
        for (int y = 0; y < height; ++y) {
            int argb;
            int x;
            image.getRGB(0, y, width, 1, rowBuffer, 0, width);
            if (hasAlpha) {
                for (x = 0; x < width; ++x) {
                    argb = rowBuffer[x];
                    output[index++] = (byte)(argb >> 16 & 0xFF);
                    output[index++] = (byte)(argb >> 8 & 0xFF);
                    output[index++] = (byte)(argb & 0xFF);
                    output[index++] = (byte)(argb >> 24 & 0xFF);
                }
                continue;
            }
            for (x = 0; x < width; ++x) {
                argb = rowBuffer[x];
                output[index++] = (byte)(argb >> 16 & 0xFF);
                output[index++] = (byte)(argb >> 8 & 0xFF);
                output[index++] = (byte)(argb & 0xFF);
            }
        }
    }
}

