/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.components;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.components.BreakPointListener;
import jsyntaxpane.components.LineMarkerPainter;
import jsyntaxpane.components.LineNumbersRuler;
import jsyntaxpane.util.Configuration;

public class LineNumbersBreakpointsRuler
extends LineNumbersRuler {
    @Override
    public void install(final JEditorPane editor) {
        super.install(editor);
        if (editor instanceof LineMarkerPainter) {
            ((LineMarkerPainter)((Object)editor)).installLineMarker(this);
        }
        this.removeMouseListener(this.mouseListener);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                p.x = 0;
                int loc = editor.viewToModel(p);
                int currentLine = -1;
                try {
                    currentLine = ActionUtils.getLineNumber(editor, loc) + 1;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (currentLine > -1 && editor instanceof BreakPointListener) {
                    ((BreakPointListener)((Object)editor)).toggled(currentLine);
                }
            }
        };
        this.addMouseListener(this.mouseListener);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.editor instanceof LineMarkerPainter) {
            FontMetrics fontMetrics = this.editor.getFontMetrics(this.editor.getFont());
            int lh = fontMetrics.getHeight();
            Rectangle bounds = g.getClipBounds();
            int minY = bounds.y;
            int maxY = minY + bounds.height;
            int maxLines = ActionUtils.getLineCount(this.editor);
            Insets insets = this.getInsets();
            int currentLine = -1;
            try {
                currentLine = ActionUtils.getLineNumber(this.editor, this.editor.getCaretPosition()) + 1;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            for (int line = 1; line <= maxLines; ++line) {
                int y = line * lh;
                if (y < minY) continue;
                if (y - lh > maxY) break;
                ((LineMarkerPainter)((Object)this.editor)).paintLineMarker(g, line, insets.left - 16 - 5, y - lh + fontMetrics.getDescent() - 1, y, lh, currentLine == line, maxLines);
            }
        }
    }

    @Override
    public void config(Configuration config) {
        super.config(config);
        int right = config.getInteger("LineNumbers.RightMargin", 5);
        int left = config.getInteger("LineNumbers.LeftMargin", 5);
        this.setBorder(BorderFactory.createEmptyBorder(0, left + 16 + 5, 0, right));
    }
}

