/*
 * Decompiled with CFR 0.152.
 */
package com.realityinteractive.imageio.tga;

import com.realityinteractive.imageio.tga.TGAImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class TGAImageReaderSpi
extends ImageReaderSpi {
    static final String VENDOR_NAME = "Reality Interactive, Inc.";
    static final String VERSION = "1.00";
    static final String READER_CLASSNAME = "com.realityinteractive.imageio.tga.TGAImageReader";
    static final String[] FORMAT_NAMES = new String[]{"tga", "targa"};
    static final String[] SUFFIXES = new String[]{"tga", "targa"};
    static final String[] MIME_TYPES = new String[]{"application/tga", "application/x-tga", "application/x-targa", "image/tga", "image/x-tga", "image/targa", "image/x-targa"};
    static final String[] WRITER_SPI_CLASSNAMES = null;
    static final boolean SUPPORTS_STANDARD_STREAM_METADATA_FORMAT = false;
    static final String NATIVE_STREAM_METADATA_FORMAT_NAME = null;
    static final String NATIVE_STREAM_METADATA_FORMAT_CLASSNAME = null;
    static final String[] EXTRA_STREAM_METADATA_FORMAT_NAMES = null;
    static final String[] EXTRA_STREAM_METADATA_FORMAT_CLASSNAMES = null;
    static final boolean SUPPORTS_STANDARD_IMAGE_METADATA_FORMAT = false;
    static final String NATIVE_IMAGE_METADATA_FORMAT_NAME = null;
    static final String NATIVE_IMAGE_METADATA_FORMAT_CLASSNAME = null;
    static final String[] EXTRA_IMAGE_METADATA_FORMAT_NAMES = null;
    static final String[] EXTRA_IMAGE_METADATA_FORMAT_CLASSNAMES = null;

    public TGAImageReaderSpi() {
        super(VENDOR_NAME, VERSION, FORMAT_NAMES, SUFFIXES, MIME_TYPES, READER_CLASSNAME, new Class[]{ImageInputStream.class}, WRITER_SPI_CLASSNAMES, false, NATIVE_STREAM_METADATA_FORMAT_NAME, NATIVE_STREAM_METADATA_FORMAT_CLASSNAME, EXTRA_STREAM_METADATA_FORMAT_NAMES, EXTRA_STREAM_METADATA_FORMAT_CLASSNAMES, false, NATIVE_IMAGE_METADATA_FORMAT_NAME, NATIVE_IMAGE_METADATA_FORMAT_CLASSNAME, EXTRA_IMAGE_METADATA_FORMAT_NAMES, EXTRA_IMAGE_METADATA_FORMAT_CLASSNAMES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream inputStream = (ImageInputStream)source;
        try {
            inputStream.mark();
            inputStream.readUnsignedByte();
            int colourMapType = inputStream.readUnsignedByte();
            if (colourMapType != 0 && colourMapType != 1) {
                boolean bl = false;
                return bl;
            }
            int imageType = inputStream.readUnsignedByte();
            if (imageType != 0 && imageType != 1 && imageType != 2 && imageType != 3 && imageType != 10 && imageType != 9 && imageType != 11) {
                boolean bl = false;
                return bl;
            }
            inputStream.skipBytes(4);
            int colourMapBits = inputStream.readUnsignedByte();
            if (colourMapBits != 0 && colourMapBits != 15 && colourMapBits != 16 && colourMapBits != 24 && colourMapBits != 32) {
                boolean bl = false;
                return bl;
            }
            inputStream.skipBytes(8);
            int bits = inputStream.readUnsignedByte();
            if (bits != 8 && bits != 16 && bits != 24 && bits != 32) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            inputStream.reset();
        }
    }

    @Override
    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new TGAImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "TGA";
    }
}

