/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFStream;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;

public class PDFImage
extends PDFStream
implements ImageObserver,
Serializable {
    private int objwidth;
    private int objheight;
    private int width;
    private int height;
    private Image img;
    private byte[] jpegImageData;
    private String name;
    private String mask;
    private boolean interpolate;

    public PDFImage() {
        super("/XObject");
    }

    public PDFImage(Image img, String mask, boolean interpolate) {
        this();
        this.mask = mask;
        this.interpolate = interpolate;
        this.setImage(img, 0, 0, img.getWidth(this), img.getHeight(this), this);
    }

    public PDFImage(Image img) {
        this(img, null, false);
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public PDFImage(Image img, int x, int y, int w, int h, ImageObserver obs, String mask, boolean interpolate) {
        this();
        this.objwidth = w;
        this.objheight = h;
        this.mask = mask;
        this.interpolate = interpolate;
        this.setImage(img, x, y, img.getWidth(this), img.getHeight(this), obs);
    }

    public PDFImage(byte[] jpegImageData, int x, int y, int w, int h, ImageObserver obs, String mask, boolean interpolate) {
        this();
        this.objwidth = w;
        this.objheight = h;
        this.mask = mask;
        this.interpolate = interpolate;
        this.setJpegImageData(jpegImageData, w, h);
    }

    public PDFImage(Image img, int x, int y, int w, int h, ImageObserver obs) {
        this(img, x, y, w, h, obs, null, false);
    }

    public PDFImage(byte[] jpegImageData, int x, int y, int w, int h, ImageObserver obs) {
        this(jpegImageData, x, y, w, h, obs, null, false);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int v) {
        this.width = v;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int v) {
        this.height = v;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setImage(Image img, int x, int y, int w, int h, ImageObserver obs) {
        this.img = img;
        this.jpegImageData = null;
        this.width = w;
        this.height = h;
    }

    public void setJpegImageData(byte[] jpegImageData, int w, int h) {
        this.jpegImageData = jpegImageData;
        this.img = null;
        this.width = w;
        this.height = h;
    }

    private String base85Encoding(String stringToEncode) throws NumberFormatException {
        long number;
        if (stringToEncode == null || stringToEncode.length() == 0) {
            return "";
        }
        if (stringToEncode.length() > 8 || stringToEncode.length() % 2 != 0) {
            System.out.println("PDFImage.base85Encoding, Incorrect tuple length: " + stringToEncode.length());
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int numHexDigits = stringToEncode.length() / 2;
        int numAppendBytes = 4 - numHexDigits;
        for (int i = 0; i < numAppendBytes; ++i) {
            stringToEncode = stringToEncode + "00";
        }
        Vector<Integer> digitVector = new Vector<Integer>();
        int remainder = 0;
        for (number = Long.parseLong(stringToEncode, 16); number >= 85L; number /= 85L) {
            remainder = (int)(number % 85L);
            digitVector.add(0, new Integer(remainder));
        }
        digitVector.add(0, new Integer((int)number));
        for (int i = 0; i < digitVector.size(); ++i) {
            char c = (char)((Integer)digitVector.elementAt(i) + 33);
            sb.append(c);
        }
        String tuple = sb.toString();
        int len = tuple.length();
        switch (len) {
            case 1: {
                tuple = "!!!!" + tuple;
                break;
            }
            case 2: {
                tuple = "!!!" + tuple;
                break;
            }
            case 3: {
                tuple = "!!" + tuple;
                break;
            }
            case 4: {
                tuple = "!" + tuple;
                break;
            }
        }
        return tuple;
    }

    @Override
    public void writeStream(OutputStream os) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        if (this.jpegImageData == null) {
            DeflaterOutputStream dos = new DeflaterOutputStream(b);
            this.buf.writeTo(dos);
            dos.finish();
            dos.close();
        } else {
            this.buf.writeTo(b);
        }
        if (this.jpegImageData != null) {
            os.write("/Filter /DCTDecode\n".getBytes("UTF-8"));
        } else {
            os.write("/Filter [/FlateDecode /ASCII85Decode]\n".getBytes("UTF-8"));
        }
        os.write("/Length ".getBytes("UTF-8"));
        os.write(Integer.toString(b.size()).getBytes("UTF-8"));
        os.write("\n>>\nstream\n".getBytes("UTF-8"));
        b.writeTo(os);
        os.write("\nendstream\nendobj\n".getBytes("UTF-8"));
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.writeStart(os);
        os.write("/Subtype /Image\n/Name ".getBytes("UTF-8"));
        os.write(this.name.getBytes("UTF-8"));
        os.write("\n/Width ".getBytes("UTF-8"));
        os.write(Integer.toString(this.width).getBytes("UTF-8"));
        os.write("\n/Height ".getBytes("UTF-8"));
        os.write(Integer.toString(this.height).getBytes("UTF-8"));
        os.write("\n/BitsPerComponent 8\n/ColorSpace /DeviceRGB\n".getBytes("UTF-8"));
        if (this.mask != null) {
            os.write(("/SMask " + this.mask + "\n").getBytes("UTF-8"));
        }
        if (this.interpolate) {
            os.write("/Interpolate true\n".getBytes("UTF-8"));
        }
        ByteArrayOutputStream bos = this.getStream();
        if (this.jpegImageData != null) {
            bos.write(this.jpegImageData);
        } else {
            int w = this.width;
            int h = this.height;
            int x = 0;
            int y = 0;
            int[] pixels = new int[w * h];
            PixelGrabber pg = new PixelGrabber(this.img, x, y, w, h, pixels, 0, w);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                System.err.println("interrupted waiting for pixels!");
                return;
            }
            if ((pg.getStatus() & 0x80) != 0) {
                System.err.println("image fetch aborted or errored");
                return;
            }
            StringBuffer out = new StringBuffer();
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    out.append(PDFImage.handlePixel(x + i, y + j, pixels[j * w + i]));
                    if (out.toString().length() < 8) continue;
                    String tuple = out.substring(0, 8);
                    out.delete(0, 8);
                    String encTuple = this.base85Encoding(tuple);
                    if (encTuple.equals("!!!!!")) {
                        encTuple = "z";
                    }
                    bos.write(encTuple.getBytes("UTF-8"));
                }
            }
            String lastTuple = this.base85Encoding(out.toString());
            bos.write(lastTuple.getBytes("UTF-8"));
            bos.write("~".getBytes("UTF-8"));
        }
        this.setDeflate(false);
        this.writeStream(os);
    }

    public static String handlePixel(int x, int y, int p) {
        int alpha = p >> 24 & 0xFF;
        int red = p >> 16 & 0xFF;
        int green = p >> 8 & 0xFF;
        int blue = p & 0xFF;
        String redHex = Integer.toHexString(red);
        String greenHex = Integer.toHexString(green);
        String blueHex = Integer.toHexString(blue);
        if (redHex.length() == 1) {
            redHex = "0" + redHex;
        }
        if (greenHex.length() == 1) {
            greenHex = "0" + greenHex;
        }
        if (blueHex.length() == 1) {
            blueHex = "0" + blueHex;
        }
        return redHex + greenHex + blueHex;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        System.err.println("img=" + img + "\ninfoflags=" + infoflags + "\nx=" + x + " y=" + y + " w=" + w + " h=" + h);
        if (infoflags == 1) {
            this.width = w;
        }
        if (infoflags == 2) {
            this.height = h;
        }
        return false;
    }
}

