/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PDFStringHelper {
    public static String makePDFString(String s) {
        if (s.indexOf("(") > -1) {
            s = PDFStringHelper.replace(s, "(", "\\(");
        }
        if (s.indexOf(")") > -1) {
            s = PDFStringHelper.replace(s, ")", "\\)");
        }
        return "(" + s + ")";
    }

    public static byte[] makeRawPDFString(String s) {
        try {
            byte[] utf16be = s.getBytes("UTF-16BE");
            ArrayList<Byte> bytes = new ArrayList<Byte>();
            block6: for (int i = 0; i < utf16be.length; ++i) {
                switch (utf16be[i]) {
                    case 13: {
                        bytes.add((byte)92);
                        bytes.add((byte)114);
                        continue block6;
                    }
                    case 40: 
                    case 41: 
                    case 92: {
                        bytes.add((byte)92);
                    }
                    default: {
                        bytes.add(utf16be[i]);
                    }
                }
            }
            byte[] ret = new byte[bytes.size()];
            for (int i = 0; i < bytes.size(); ++i) {
                ret[i] = (Byte)bytes.get(i);
            }
            return ret;
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(PDFStringHelper.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static String replace(String source, String removeThis, String replaceWith) {
        StringBuffer b = new StringBuffer();
        int p = 0;
        int c = 0;
        while (c > -1) {
            c = source.indexOf(removeThis, p);
            if (c <= -1) continue;
            b.append(source.substring(p, c));
            b.append(replaceWith);
            p = c + 1;
        }
        if (p < source.length()) {
            b.append(source.substring(p));
        }
        return b.toString();
    }
}

