/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.cfb;

import com.jpexs.cfb.DirectoryEntry;
import com.jpexs.cfb.RedBlackTree;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompoundFileBinary
implements AutoCloseable {
    private static final byte[] SIGNATURE = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final byte[] CLSID_NULL = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private RandomAccessFile raf;
    private static final long MAXREGSECT = 0xFFFFFFFAL;
    private static final long NOT_APPLICABLE = 0xFFFFFFFBL;
    private static final long DIFSECT = 0xFFFFFFFCL;
    private static final long FATSECT = 0xFFFFFFFDL;
    private static final long ENDOFCHAIN = 0xFFFFFFFEL;
    private static final long FREESECT = 0xFFFFFFFFL;
    public static final long MAXREGSID = 0xFFFFFFFAL;
    public static final long NOSTREAM = 0xFFFFFFFFL;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_STORAGE_OBJECT = 1;
    public static final int TYPE_STREAM_OBJECT = 2;
    public static final int TYPE_ROOT_STORAGE_OBJECT = 5;
    public static final int COLOR_RED = 0;
    public static final int COLOR_BLACK = 1;
    private List<Long> difat;
    private Map<Long, Long> fat;
    private Map<Long, Long> minifat;
    private List<DirectoryEntry> directoryEntries;
    private long miniStreamStartingSector;
    private long miniStreamSizeFileOffset;
    private long firstDirectorySectorLocation;
    private long numFatSectors;
    private long miniStreamCutoffSize;
    private long miniStreamSize;
    private int sectorLength;
    private long firstMiniFatSectorLocation;
    private long numMiniFatSectors;
    private long numDifatSectors;
    private long firstDifatSectorLocation;
    private Map<Long, Long> entryParents = new HashMap<Long, Long>();
    public boolean USE_DIRENTRY = true;

    public CompoundFileBinary(File file) throws IOException {
        this(file, false);
    }

    public CompoundFileBinary(File file, boolean createNew) throws IOException {
        if (createNew) {
            this.initNew(file);
        } else {
            this.initExisting(file);
        }
    }

    private static byte[] fromStringToByteArray(String clsid) {
        Pattern pattern = Pattern.compile("^([0-9A-Fa-f]{8})-([0-9A-Fa-f]{4})-([0-9A-Fa-f]{4})-([0-9A-Fa-f]{4})-([0-9A-Fa-f]{12})$");
        Matcher matcher = pattern.matcher(clsid);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid CLSID format");
        }
        String part1 = matcher.group(1);
        String part2 = matcher.group(2);
        String part3 = matcher.group(3);
        String part4 = matcher.group(4);
        String part5 = matcher.group(5);
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putInt(Integer.reverseBytes((int)Long.parseLong(part1, 16)));
        buffer.putShort(Short.reverseBytes((short)Integer.parseInt(part2, 16)));
        buffer.putShort(Short.reverseBytes((short)Integer.parseInt(part3, 16)));
        buffer.put(CompoundFileBinary.hexStringToByteArray(part4));
        buffer.put(CompoundFileBinary.hexStringToByteArray(part5));
        return buffer.array();
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public void setRootClsId(String value) throws IOException {
        DirectoryEntry root = this.getRootDirEntry();
        root.clsId = CompoundFileBinary.fromStringToByteArray(value);
        this.raf.seek(root.fileOffset + 80L);
        this.raf.write(root.clsId);
    }

    private byte[] readBytes(int count) throws IOException {
        byte[] ret = new byte[count];
        this.raf.readFully(ret);
        return ret;
    }

    private Date readDate() throws IOException {
        long filetime = this.readUI64();
        if (filetime == 0L) {
            return null;
        }
        return new Date(filetime / 10000L - 11644473600000L);
    }

    private int readEx() throws IOException {
        int ret = this.raf.read();
        if (ret == -1) {
            throw new IOException("Premature end of the file reached");
        }
        return ret;
    }

    private void skipZeroBytes(int count, String errorMsg) throws IOException {
        for (int i = 0; i < count; ++i) {
            if (this.readEx() == 0) continue;
            throw new IOException(errorMsg);
        }
    }

    private void writeZeroBytes(int num) throws IOException {
        this.raf.write(new byte[num]);
    }

    private void write(int value) throws IOException {
        this.raf.write(value);
    }

    private void writeUI16(int value) throws IOException {
        this.write(value & 0xFF);
        this.write(value >> 8 & 0xFF);
    }

    private void writeUI32(long value) throws IOException {
        this.write((int)(value & 0xFFL));
        this.write((int)(value >> 8 & 0xFFL));
        this.write((int)(value >> 16 & 0xFFL));
        this.write((int)(value >> 24 & 0xFFL));
    }

    private void writeUI64(long value) throws IOException {
        this.write((int)(value & 0xFFL));
        this.write((int)(value >> 8 & 0xFFL));
        this.write((int)(value >> 16 & 0xFFL));
        this.write((int)(value >> 24 & 0xFFL));
        this.write((int)(value >> 32 & 0xFFL));
        this.write((int)(value >> 40 & 0xFFL));
        this.write((int)(value >> 48 & 0xFFL));
        this.write((int)(value >> 56 & 0xFFL));
    }

    private void writeDate(Date value) throws IOException {
        if (value == null) {
            this.writeUI64(0L);
            return;
        }
        long date = (value.getTime() + 11644473600000L) * 10000L;
        this.writeUI64(date);
    }

    private int readUI16() throws IOException {
        return this.readEx() + (this.readEx() << 8);
    }

    private long readUI32() throws IOException {
        return (long)(this.readEx() + (this.readEx() << 8) + (this.readEx() << 16) + (this.readEx() << 24)) & 0xFFFFFFFFL;
    }

    private long readUI64() throws IOException {
        return this.readUI32() + (this.readUI32() << 32);
    }

    private void initNew(File file) throws IOException {
        int i;
        int i2;
        if (file.exists()) {
            file.delete();
        }
        this.raf = new RandomAccessFile(file, "rw");
        this.raf.write(SIGNATURE);
        this.raf.write(CLSID_NULL);
        this.writeUI16(62);
        this.writeUI16(3);
        this.writeUI16(65534);
        this.writeUI16(9);
        this.writeUI16(6);
        this.writeZeroBytes(6);
        this.writeUI32(0L);
        this.sectorLength = 512;
        this.numFatSectors = 1L;
        this.firstDirectorySectorLocation = 1L;
        long transactionSignatureNumber = 0L;
        this.miniStreamCutoffSize = 4096L;
        this.firstMiniFatSectorLocation = 2L;
        this.numMiniFatSectors = 1L;
        this.firstDifatSectorLocation = 0xFFFFFFFEL;
        this.numDifatSectors = 0L;
        this.writeUI32(this.numFatSectors);
        this.writeUI32(this.firstDirectorySectorLocation);
        this.writeUI32(transactionSignatureNumber);
        this.writeUI32(this.miniStreamCutoffSize);
        this.writeUI32(this.firstMiniFatSectorLocation);
        this.writeUI32(this.numMiniFatSectors);
        this.writeUI32(this.firstDifatSectorLocation);
        this.writeUI32(this.numDifatSectors);
        this.writeUI32(0L);
        for (i2 = 0; i2 < 108; ++i2) {
            this.writeUI32(0xFFFFFFFFL);
        }
        this.writeUI32(0xFFFFFFFDL);
        this.writeUI32(0xFFFFFFFEL);
        this.writeUI32(0xFFFFFFFEL);
        this.writeUI32(0xFFFFFFFEL);
        for (i2 = 4; i2 <= 127; ++i2) {
            this.writeUI32(0xFFFFFFFFL);
        }
        Random rnd = new Random();
        byte[] dirClsId = new byte[16];
        rnd.nextBytes(dirClsId);
        this.miniStreamStartingSector = 3L;
        Date d = new Date();
        this.miniStreamSizeFileOffset = this.raf.getFilePointer() + 120L;
        this.writeDirectoryEntry("Root Entry", 5, 1, 0xFFFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFL, dirClsId, 0L, d, d, this.miniStreamStartingSector, 64L);
        for (i = 128; i < this.sectorLength; i += 128) {
            this.writeEmptyDirectoryEntry();
        }
        this.writeUI32(0xFFFFFFFEL);
        for (i = 4; i < this.sectorLength; i += 4) {
            this.writeUI32(0xFFFFFFFFL);
        }
        for (i = 0; i < this.sectorLength; ++i) {
            this.writeUI32(0L);
        }
        this.readFile();
    }

    private void seekToMiniStream(long miniSectorId) throws IOException {
        long miniStreamSector = this.miniStreamStartingSector;
        long sId = 0L;
        while (miniStreamSector != 0xFFFFFFFEL) {
            for (int i = 0; i < this.sectorLength; i += 64) {
                if (sId == miniSectorId) {
                    this.raf.seek((1L + miniStreamSector) * (long)this.sectorLength + (long)i);
                    return;
                }
                ++sId;
            }
            miniStreamSector = this.fat.get(miniStreamSector);
        }
        throw new IOException("No such miniSectorId exists");
    }

    public DirectoryEntry addFile(String path, File file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        try (FileInputStream fis = new FileInputStream(file);){
            int cnt;
            while ((cnt = fis.read(buf)) > 0) {
                baos.write(buf, 0, cnt);
            }
        }
        return this.addFile(path, baos.toByteArray());
    }

    public DirectoryEntry getRootDirEntry() {
        for (DirectoryEntry entry : this.directoryEntries) {
            if (entry.objectType != 5) continue;
            return entry;
        }
        return null;
    }

    public List<DirectoryEntry> getEntriesInRootDir() {
        return this.getEntriesInDir(this.getRootDirEntry());
    }

    public DirectoryEntry getEntryByPath(String path) {
        boolean trailingSlash;
        DirectoryEntry dir = this.getRootDirEntry();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (trailingSlash = path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty()) {
            return dir;
        }
        String[] parts = path.split("/", -1);
        for (int i = 0; i < parts.length; ++i) {
            DirectoryEntry entry2;
            block8: {
                String part = parts[i];
                List<DirectoryEntry> entries = this.getEntriesInDir(dir);
                for (DirectoryEntry entry2 : entries) {
                    if (!entry2.name.equals(part)) continue;
                    if (entry2.objectType != 1) {
                        if (entry2.objectType == 2 && i == parts.length - 1) {
                            if (trailingSlash) {
                                return null;
                            }
                            return entry2;
                        }
                        return null;
                    }
                    break block8;
                }
                return null;
            }
            dir = entry2;
        }
        return dir;
    }

    public List<DirectoryEntry> getEntriesInDir(DirectoryEntry dir) {
        ArrayList<DirectoryEntry> ret = new ArrayList<DirectoryEntry>();
        if (dir.childId != 0xFFFFFFFFL) {
            DirectoryEntry child = this.getDirEntryById(dir.childId);
            ret.add(child);
            this.walkEntry(child, ret);
        }
        return ret;
    }

    public List<DirectoryEntry> getEntriesInDir(int streamId) {
        DirectoryEntry dir = this.getDirEntryById(streamId);
        return this.getEntriesInDir(dir);
    }

    private void walkEntry(DirectoryEntry entry, List<DirectoryEntry> result) {
        if (entry.leftSiblingId != 0xFFFFFFFFL) {
            DirectoryEntry left = this.getDirEntryById(entry.leftSiblingId);
            result.add(left);
            this.walkEntry(left, result);
        }
        if (entry.rightSiblingId != 0xFFFFFFFFL) {
            DirectoryEntry right = this.getDirEntryById(entry.rightSiblingId);
            result.add(right);
            this.walkEntry(right, result);
        }
    }

    public DirectoryEntry getDirEntryById(long streamId) {
        for (DirectoryEntry de : this.directoryEntries) {
            if (de.streamId != streamId) continue;
            return de;
        }
        return null;
    }

    public DirectoryEntry addDirectory(String path) throws IOException {
        DirectoryEntry existing = this.getEntryByPath(path);
        if (existing != null) {
            return existing;
        }
        Logger.getLogger(CompoundFileBinary.class.getName()).log(Level.FINE, "adding directory {0}", path);
        DirectoryEntry parent = this.getRootDirEntry();
        if (path.contains("/")) {
            String parentPath = path.substring(0, path.lastIndexOf("/"));
            path = path.substring(path.lastIndexOf("/") + 1);
            parent = this.getEntryByPath(parentPath);
            if (parent == null) {
                parent = this.addDirectory(parentPath);
            }
        }
        Date d = new Date();
        DirectoryEntry entry = new DirectoryEntry(-1L, -1L, -1L, path, 1, 1, 0xFFFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFL, CLSID_NULL, 0L, d, d, 0L, 0L);
        this.addDirectoryEntry(parent, entry);
        return entry;
    }

    private void addToTree(RedBlackTree<DirectoryEntry> tree, DirectoryEntry entry) {
        if (entry == null) {
            return;
        }
        tree.insert(entry);
        DirectoryEntry left = entry.leftSiblingId == 0xFFFFFFFFL ? null : this.getDirEntryById(entry.leftSiblingId);
        this.addToTree(tree, left);
        DirectoryEntry right = entry.rightSiblingId == 0xFFFFFFFFL ? null : this.getDirEntryById(entry.rightSiblingId);
        this.addToTree(tree, right);
    }

    private void writeColors(RedBlackTree.Node<DirectoryEntry> node) throws IOException {
        long newRightSibling;
        long newLeftSibling;
        int newColorFlag;
        if (node == null || node.data == null) {
            return;
        }
        int n = newColorFlag = node.color == RedBlackTree.Color.RED ? 0 : 1;
        if (((DirectoryEntry)node.data).colorFlag != newColorFlag) {
            ((DirectoryEntry)node.data).colorFlag = newColorFlag;
            this.raf.seek(((DirectoryEntry)node.data).fileOffset + 67L);
            this.write(((DirectoryEntry)node.data).colorFlag);
        }
        long l = newLeftSibling = node.left == null || node.left.data == null ? 0xFFFFFFFFL : ((DirectoryEntry)node.left.data).streamId;
        if (((DirectoryEntry)node.data).leftSiblingId != newLeftSibling) {
            ((DirectoryEntry)node.data).leftSiblingId = newLeftSibling;
            this.raf.seek(((DirectoryEntry)node.data).fileOffset + 68L);
            this.writeUI32(newLeftSibling);
        }
        long l2 = newRightSibling = node.right == null || node.right.data == null ? 0xFFFFFFFFL : ((DirectoryEntry)node.right.data).streamId;
        if (((DirectoryEntry)node.data).rightSiblingId != newRightSibling) {
            ((DirectoryEntry)node.data).rightSiblingId = newRightSibling;
            this.raf.seek(((DirectoryEntry)node.data).fileOffset + 72L);
            this.writeUI32(newRightSibling);
        }
        this.writeColors(node.left);
        this.writeColors(node.right);
    }

    private void markTreeColors(DirectoryEntry child, DirectoryEntry parent) throws IOException {
        RedBlackTree<DirectoryEntry> tree = new RedBlackTree<DirectoryEntry>();
        this.addToTree(tree, child);
        RedBlackTree.Node<DirectoryEntry> rootNode = tree.getRoot();
        if (child.streamId != ((DirectoryEntry)rootNode.data).streamId) {
            parent.childId = ((DirectoryEntry)rootNode.data).streamId;
            this.raf.seek(parent.fileOffset + 76L);
            this.writeUI32(parent.childId);
        }
        this.writeColors(rootNode);
    }

    private void markTreeBlack(DirectoryEntry entry) throws IOException {
        if (entry == null) {
            return;
        }
        entry.colorFlag = 1;
        this.raf.seek(entry.fileOffset + 67L);
        this.write(entry.colorFlag);
        DirectoryEntry left = entry.leftSiblingId == 0xFFFFFFFFL ? null : this.getDirEntryById(entry.leftSiblingId);
        this.markTreeBlack(left);
        DirectoryEntry right = entry.rightSiblingId == 0xFFFFFFFFL ? null : this.getDirEntryById(entry.rightSiblingId);
        this.markTreeBlack(right);
    }

    private void addDirectoryEntry(DirectoryEntry parent, DirectoryEntry newEntry) throws IOException {
        DirectoryEntry entry;
        long directorySector;
        boolean asChild = false;
        boolean asLeft = false;
        Long targetId = null;
        if (parent.childId == 0xFFFFFFFFL) {
            asChild = true;
        } else {
            DirectoryEntry e;
            block17: {
                DirectoryEntry child;
                e = child = this.getDirEntryById(parent.childId);
                while (true) {
                    int cmp;
                    if ((cmp = newEntry.compareTo(e)) < 0) {
                        if (e.leftSiblingId != 0xFFFFFFFFL) {
                            e = this.getDirEntryById(e.leftSiblingId);
                            continue;
                        }
                        asLeft = true;
                        break block17;
                    }
                    if (e.rightSiblingId == 0xFFFFFFFFL) break;
                    e = this.getDirEntryById(e.rightSiblingId);
                }
                asLeft = false;
            }
            targetId = e.streamId;
        }
        long sectorBefore = directorySector = this.firstDirectorySectorLocation;
        int newStreamId = 0;
        int entriesPerSector = this.sectorLength / 128;
        for (int i = 0; i < this.directoryEntries.size(); ++i) {
            DirectoryEntry en = this.directoryEntries.get(i);
            if ((en.name == null || en.name.isEmpty()) && en.objectType == 0 && en.colorFlag == 0 && en.leftSiblingId == 0xFFFFFFFFL && en.rightSiblingId == 0xFFFFFFFFL && en.childId == 0xFFFFFFFFL && Arrays.equals(en.clsId, CLSID_NULL) && en.stateBits == 0L && en.creationTime == null && en.modifiedTime == null && en.startingSectorLocation == 0L && en.streamSize == 0L) {
                this.raf.seek(en.fileOffset);
                entry = newEntry;
                entry.fileOffset = en.fileOffset;
                entry.directorySector = directorySector;
                entry.streamId = newStreamId;
                this.writeDirectoryEntry(entry);
                this.directoryEntries.set(newStreamId, entry);
                if (i % entriesPerSector == entriesPerSector - 1) {
                    directorySector = this.allocateNewSector(directorySector);
                    long sid = newStreamId;
                    this.raf.seek((1L + directorySector) * (long)this.sectorLength);
                    for (int j = 0; j < this.sectorLength; j += 128) {
                        en = new DirectoryEntry(this.raf.getFilePointer(), directorySector, ++sid, null, 0, 0, 0xFFFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFL, CLSID_NULL, 0L, null, null, 0L, 0L);
                        this.directoryEntries.add(en);
                        this.writeDirectoryEntry(en);
                    }
                    break;
                }
                en = new DirectoryEntry(this.raf.getFilePointer(), directorySector, newStreamId + 1, null, 0, 0, 0xFFFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFL, CLSID_NULL, 0L, null, null, 0L, 0L);
                this.directoryEntries.set(i + 1, en);
                this.writeDirectoryEntry(en);
                break;
            }
            ++newStreamId;
            if (i % entriesPerSector != entriesPerSector - 1) continue;
            sectorBefore = directorySector;
            directorySector = this.fat.get(directorySector);
        }
        if (directorySector == 0xFFFFFFFEL) {
            directorySector = this.allocateNewSector(sectorBefore);
            this.raf.seek((1L + directorySector) * (long)this.sectorLength);
            entry = newEntry;
            entry.fileOffset = (1L + directorySector) * (long)this.sectorLength;
            entry.directorySector = directorySector;
            entry.streamId = newStreamId;
            this.directoryEntries.add(entry);
            this.writeDirectoryEntry(entry);
            long sid = newStreamId;
            for (int i = 128; i < this.sectorLength; i += 128) {
                DirectoryEntry en = new DirectoryEntry(this.raf.getFilePointer(), directorySector, ++sid, null, 0, 0, 0xFFFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFL, CLSID_NULL, 0L, null, null, 0L, 0L);
                this.directoryEntries.add(en);
                this.writeDirectoryEntry(en);
            }
        }
        directorySector = this.firstDirectorySectorLocation;
        long streamId = 0L;
        while (directorySector != 0xFFFFFFFEL) {
            for (int i = 0; i < this.sectorLength; i += 128) {
                if (asChild && streamId == parent.streamId) {
                    this.raf.seek((1L + directorySector) * (long)this.sectorLength + (long)i + 76L);
                    this.writeUI32(newStreamId);
                    parent.childId = newStreamId;
                }
                if (!asChild && streamId == targetId) {
                    if (!asLeft) {
                        this.raf.seek((1L + directorySector) * (long)this.sectorLength + (long)i + 72L);
                        this.writeUI32(newStreamId);
                        this.getDirEntryById((long)streamId).rightSiblingId = newStreamId;
                    } else {
                        this.raf.seek((1L + directorySector) * (long)this.sectorLength + (long)i + 68L);
                        this.writeUI32(newStreamId);
                        this.getDirEntryById((long)streamId).leftSiblingId = newStreamId;
                    }
                }
                ++streamId;
            }
            directorySector = this.fat.get(directorySector);
        }
        this.markTreeColors(this.getDirEntryById(parent.childId), parent);
    }

    private void walkFiles(String localPath, String absPath, List<DirectoryEntry> ret) throws IOException {
        File root = new File(absPath);
        File[] list = root.listFiles();
        if (list == null) {
            return;
        }
        for (File f : list) {
            String localSubPath;
            String name = f.getName();
            String string = localSubPath = localPath.isEmpty() ? name : localPath + "/" + name;
            if (f.isDirectory()) {
                this.walkFiles(localSubPath, f.getAbsolutePath(), ret);
                ret.add(this.addDirectory(localSubPath));
                continue;
            }
            ret.add(this.addFile(localSubPath, f));
        }
    }

    public List<DirectoryEntry> addDirectoryContents(String path, File dir) throws IOException {
        ArrayList<DirectoryEntry> ret = new ArrayList<DirectoryEntry>();
        this.walkFiles(path, dir.getAbsolutePath(), ret);
        return ret;
    }

    public DirectoryEntry addFile(String path, byte[] data) throws IOException {
        DirectoryEntry existing = this.getEntryByPath(path);
        if (existing != null) {
            throw new IOException("File with path " + path + " already exists");
        }
        Logger.getLogger(CompoundFileBinary.class.getName()).log(Level.FINE, "adding file {0}", path);
        DirectoryEntry parent = this.getRootDirEntry();
        if (path.contains("/")) {
            String parentPath = path.substring(0, path.lastIndexOf("/"));
            path = path.substring(path.lastIndexOf("/") + 1);
            parent = this.getEntryByPath(parentPath);
            if (parent == null) {
                parent = this.addDirectory(parentPath);
            }
        }
        Long firstSectorId = null;
        if ((long)data.length < this.miniStreamCutoffSize) {
            int len;
            Long sectorId = null;
            for (int pos = 0; pos < data.length; pos += len) {
                int sectorSize = 64;
                sectorId = this.allocateNewMiniSector(sectorId);
                this.seekToMiniStream(sectorId);
                if (firstSectorId == null) {
                    firstSectorId = sectorId;
                }
                if (pos + (len = sectorSize) > data.length) {
                    len = data.length - pos;
                }
                this.raf.write(data, pos, len);
            }
        } else {
            List<Long> sectors = this.allocateNewLength(data.length);
            int sectorSize = this.sectorLength;
            int pos = 0;
            for (Long sectorId : sectors) {
                this.raf.seek((1L + sectorId) * (long)this.sectorLength);
                int len = sectorSize;
                if (pos + len > data.length) {
                    len = data.length - pos;
                }
                this.raf.write(data, pos, len);
                pos += len;
            }
            firstSectorId = sectors.get(0);
        }
        if (data.length == 0) {
            firstSectorId = this.allocateNewMiniSector(null);
        }
        if (!this.USE_DIRENTRY) {
            return null;
        }
        Date d = new Date();
        DirectoryEntry entry = new DirectoryEntry(-1L, -1L, -1L, path, 2, 1, 0xFFFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFL, CLSID_NULL, 0L, d, d, firstSectorId, data.length);
        this.addDirectoryEntry(parent, entry);
        return entry;
    }

    private long allocateNewMiniSector(Long prevSector) throws IOException {
        int i;
        int i2;
        long minifatSector;
        if (this.miniStreamStartingSector == 0xFFFFFFFEL) {
            long directorySector = this.firstDirectorySectorLocation;
            this.miniStreamStartingSector = 0xFFFFFFFEL;
            this.miniStreamSize = 0L;
            block0: while (directorySector != 0xFFFFFFFEL) {
                for (int i3 = 0; i3 < this.sectorLength; i3 += 128) {
                    this.raf.seek((1L + directorySector) * (long)this.sectorLength + (long)(i3 * 128) + 66L);
                    int objectType = this.readEx();
                    if (objectType != 5) continue;
                    this.raf.seek((1L + directorySector) * (long)this.sectorLength + (long)(i3 * 128) + 116L);
                    this.miniStreamStartingSector = this.readUI32();
                    this.miniStreamSizeFileOffset = this.raf.getFilePointer();
                    this.miniStreamSize = this.readUI32();
                    if (this.miniStreamStartingSector != 0xFFFFFFFEL) break block0;
                    this.miniStreamStartingSector = this.allocateNewSector(null);
                    this.raf.seek((1L + directorySector) * (long)this.sectorLength + (long)(i3 * 128) + 116L);
                    this.writeUI32(this.miniStreamStartingSector);
                    this.raf.seek((1L + this.miniStreamStartingSector) * (long)this.sectorLength);
                    for (int j = 0; j < this.sectorLength; ++j) {
                        this.write(0);
                    }
                    break block0;
                }
                directorySector = this.fat.get(directorySector);
            }
        }
        if (this.firstMiniFatSectorLocation == 0xFFFFFFFEL) {
            this.firstMiniFatSectorLocation = this.allocateNewSector(null);
            this.raf.seek(60L);
            this.writeUI32(this.firstMiniFatSectorLocation);
            this.raf.seek((1L + this.firstMiniFatSectorLocation) * (long)this.sectorLength);
            for (int i4 = 0; i4 < this.sectorLength; i4 += 4) {
                this.writeUI32(0xFFFFFFFFL);
            }
        }
        long sectorBefore = minifatSector = this.firstMiniFatSectorLocation;
        Long foundMiniSectorId = 0L;
        long sectorId = 0L;
        block4: while (minifatSector != 0xFFFFFFFEL) {
            this.raf.seek((1L + minifatSector) * (long)this.sectorLength);
            for (i2 = 0; i2 < this.sectorLength; i2 += 4) {
                long val = this.minifat.get(sectorId);
                if (val == 0xFFFFFFFFL) {
                    this.raf.seek((1L + minifatSector) * (long)this.sectorLength + (long)i2);
                    this.writeUI32(0xFFFFFFFEL);
                    foundMiniSectorId = sectorId;
                    this.minifat.put(sectorId, 0xFFFFFFFEL);
                    break block4;
                }
                ++sectorId;
            }
            sectorBefore = minifatSector;
            minifatSector = this.fat.get(minifatSector);
        }
        if (minifatSector == 0xFFFFFFFEL) {
            minifatSector = this.allocateNewSector(sectorBefore);
            this.raf.seek((1L + minifatSector) * (long)this.sectorLength);
            this.writeUI32(0xFFFFFFFEL);
            this.minifat.put(Long.valueOf(this.minifat.size()), 0xFFFFFFFEL);
            for (i2 = 4; i2 < this.sectorLength; i2 += 4) {
                this.writeUI32(0xFFFFFFFFL);
                this.minifat.put(Long.valueOf(this.minifat.size()), 0xFFFFFFFFL);
            }
            foundMiniSectorId = sectorId;
            ++this.numMiniFatSectors;
            this.raf.seek(64L);
            this.writeUI32(this.numMiniFatSectors);
        }
        long miniStreamSector = this.miniStreamStartingSector;
        long miniSectorAddr = 64L * foundMiniSectorId;
        long addr = 0L;
        sectorBefore = miniStreamSector;
        long offset = 0L;
        while (miniStreamSector != 0xFFFFFFFEL) {
            if (miniSectorAddr < addr + (long)this.sectorLength) {
                offset = miniSectorAddr - addr;
                this.raf.seek((1L + miniStreamSector) * (long)this.sectorLength + offset);
                for (i = 0; i < 64; ++i) {
                    this.write(0);
                }
                this.miniStreamSize += 64L;
                this.raf.seek(this.miniStreamSizeFileOffset);
                this.writeUI32(this.miniStreamSize);
                break;
            }
            addr += (long)this.sectorLength;
            sectorBefore = miniStreamSector;
            miniStreamSector = this.fat.get(miniStreamSector);
        }
        if (miniStreamSector == 0xFFFFFFFEL) {
            miniStreamSector = this.allocateNewSector(sectorBefore);
            this.miniStreamSize += 64L;
            this.raf.seek(this.miniStreamSizeFileOffset);
            this.writeUI32(this.miniStreamSize);
        }
        if (prevSector != null) {
            minifatSector = this.firstMiniFatSectorLocation;
            sectorId = 0L;
            block9: while (minifatSector != 0xFFFFFFFEL) {
                for (i = 0; i < this.sectorLength; i += 4) {
                    if (sectorId == prevSector) {
                        this.raf.seek((1L + minifatSector) * (long)this.sectorLength + (long)i);
                        this.writeUI32(foundMiniSectorId);
                        this.minifat.put(prevSector, foundMiniSectorId);
                        break block9;
                    }
                    ++sectorId;
                }
                minifatSector = this.fat.get(minifatSector);
            }
        }
        Logger.getLogger(CompoundFileBinary.class.getName()).log(Level.FINE, "allocated new mini sector {0}({1}) after sector {2}", new Object[]{foundMiniSectorId, String.format("%1$04X", (1L + miniStreamSector) * (long)this.sectorLength + offset), prevSector});
        return foundMiniSectorId;
    }

    private long allocateNewSector(Long prevSector) throws IOException {
        List<Long> newSectors = this.allocateNewLength(this.sectorLength);
        long newSectorId = newSectors.get(0);
        if (prevSector != null) {
            long sectorId = 0L;
            block0: for (int d = 0; d < this.difat.size(); ++d) {
                long fatSect = this.difat.get(d);
                for (int i = 0; i < this.sectorLength; i += 4) {
                    if (sectorId == prevSector) {
                        this.raf.seek((1L + fatSect) * (long)this.sectorLength + (long)i);
                        this.writeUI32(newSectorId);
                        break block0;
                    }
                    ++sectorId;
                }
            }
            this.fat.put(prevSector, newSectorId);
        }
        Logger.getLogger(CompoundFileBinary.class.getName()).log(Level.FINE, "allocated new long sector {0,number,#}({1}) after sector {2,number,#}", new Object[]{newSectorId, String.format("%1$04X", (1L + newSectorId) * (long)this.sectorLength), prevSector});
        return newSectorId;
    }

    private List<Long> allocateNewLength(long length) throws IOException {
        int numSectors = (int)Math.ceil((float)length / (float)this.sectorLength);
        ArrayList<Long> newSectorIds = new ArrayList<Long>();
        long sectorId2 = 0L;
        Long lastSectorFatFileOffset = null;
        long lastSectorId = -1L;
        Set<Long> sectors = this.fat.keySet();
        for (long sectorId2 : sectors) {
            long sectVal = this.fat.get(sectorId2);
            if (sectVal != 0xFFFFFFFFL) continue;
            newSectorIds.add(sectorId2);
            int sectPerFat = this.sectorLength / 4;
            int fatSectInOrder = (int)(sectorId2 / (long)sectPerFat);
            long fatSectInOrderMod = sectorId2 % (long)sectPerFat;
            long fatSect = this.difat.get(fatSectInOrder);
            this.raf.seek((1L + fatSect) * (long)this.sectorLength + fatSectInOrderMod * 4L);
            this.writeUI32(0xFFFFFFFEL);
            this.fat.put(sectorId2, 0xFFFFFFFEL);
            if (lastSectorFatFileOffset != null) {
                this.raf.seek(lastSectorFatFileOffset);
                this.writeUI32(sectorId2);
                this.fat.put(lastSectorId, sectorId2);
            }
            lastSectorFatFileOffset = (1L + fatSect) * (long)this.sectorLength + fatSectInOrderMod * 4L;
            lastSectorId = sectorId2;
            if (newSectorIds.size() != numSectors) continue;
            break;
        }
        if (newSectorIds.size() < numSectors) {
            ++sectorId2;
        }
        while (newSectorIds.size() < numSectors) {
            int numNewSectors = 1;
            Long newFatSectorId = sectorId2;
            this.raf.seek(76L);
            boolean inMainDiFat = false;
            int diFatIndex = 0;
            for (int i = 0; i < 109; ++i) {
                long difatval = this.difat.get(diFatIndex);
                if (difatval == 0xFFFFFFFFL) {
                    this.raf.seek(76 + i * 4);
                    this.writeUI32(sectorId2);
                    inMainDiFat = true;
                    this.difat.set(diFatIndex, sectorId2);
                    break;
                }
                ++diFatIndex;
            }
            boolean diFatSectorAdded = false;
            if (!inMainDiFat) {
                this.raf.seek((1L + newFatSectorId) * (long)this.sectorLength);
                this.raf.write(new byte[this.sectorLength]);
                boolean inSecondaryDiFat = false;
                long difatSectorLocation = this.firstDifatSectorLocation;
                block3: while (difatSectorLocation <= 0xFFFFFFFAL) {
                    for (int i = 0; i < this.sectorLength - 4; i += 4) {
                        long fatSector = this.difat.get(diFatIndex);
                        if (fatSector == 0xFFFFFFFFL) {
                            this.raf.seek((1L + difatSectorLocation) * (long)this.sectorLength + (long)i);
                            this.writeUI32(newFatSectorId);
                            inSecondaryDiFat = true;
                            this.difat.set(diFatIndex, newFatSectorId);
                            break block3;
                        }
                        ++diFatIndex;
                    }
                    this.raf.seek((1L + difatSectorLocation) * (long)this.sectorLength + (long)this.sectorLength - 4L);
                    difatSectorLocation = this.readUI32();
                }
                if (!inSecondaryDiFat) {
                    ++numNewSectors;
                    diFatSectorAdded = true;
                    long newDiFatSectorId = sectorId2;
                    newFatSectorId = newDiFatSectorId++;
                    if (this.firstDifatSectorLocation == 0xFFFFFFFEL) {
                        this.raf.seek(68L);
                        this.writeUI32(newDiFatSectorId);
                        this.firstDifatSectorLocation = newDiFatSectorId;
                    } else {
                        difatSectorLocation = this.firstDifatSectorLocation;
                        while (difatSectorLocation <= 0xFFFFFFFAL) {
                            this.raf.seek((1L + difatSectorLocation) * (long)this.sectorLength + (long)this.sectorLength - 4L);
                            long newDifatSectorLocation = this.readUI32();
                            if (newDifatSectorLocation == 0xFFFFFFFEL) {
                                this.raf.seek((1L + difatSectorLocation) * (long)this.sectorLength + (long)this.sectorLength - 4L);
                                this.writeUI32(newDiFatSectorId);
                            }
                            difatSectorLocation = newDifatSectorLocation;
                        }
                    }
                    this.raf.seek((1L + newDiFatSectorId) * (long)this.sectorLength);
                    this.writeUI32(newFatSectorId);
                    this.difat.add(newFatSectorId);
                    for (int i = 4; i < this.sectorLength - 4; i += 4) {
                        this.writeUI32(0xFFFFFFFFL);
                        this.difat.add(0xFFFFFFFFL);
                    }
                    this.writeUI32(0xFFFFFFFEL);
                    this.fat.put(newDiFatSectorId, 0xFFFFFFFCL);
                    ++this.numDifatSectors;
                    this.raf.seek(72L);
                    this.writeUI32(this.numDifatSectors);
                }
            }
            this.fat.put(newFatSectorId, 0xFFFFFFFDL);
            this.raf.seek((1L + newFatSectorId) * (long)this.sectorLength);
            if (diFatSectorAdded) {
                this.writeUI32(0xFFFFFFFCL);
            }
            this.writeUI32(0xFFFFFFFDL);
            sectorId2 += (long)numNewSectors;
            for (int i = numNewSectors * 4; i < this.sectorLength; i += 4) {
                this.raf.seek((1L + newFatSectorId) * (long)this.sectorLength + (long)i);
                if (newSectorIds.size() < numSectors) {
                    this.writeUI32(0xFFFFFFFEL);
                    this.fat.put(sectorId2, 0xFFFFFFFEL);
                    if (lastSectorFatFileOffset != null) {
                        this.raf.seek(lastSectorFatFileOffset);
                        this.writeUI32(sectorId2);
                        this.fat.put(lastSectorId, sectorId2);
                    }
                    lastSectorFatFileOffset = (1L + newFatSectorId) * (long)this.sectorLength + (long)i;
                    lastSectorId = sectorId2;
                    newSectorIds.add(sectorId2);
                } else {
                    this.writeUI32(0xFFFFFFFFL);
                    this.fat.put(sectorId2, 0xFFFFFFFFL);
                }
                ++sectorId2;
            }
            ++this.numFatSectors;
            this.raf.seek(44L);
            this.writeUI32(this.numFatSectors);
        }
        Iterator iterator = newSectorIds.iterator();
        while (iterator.hasNext()) {
            long newSectorId = (Long)iterator.next();
            this.raf.seek((1L + newSectorId) * (long)this.sectorLength);
            this.raf.write(new byte[this.sectorLength]);
        }
        Logger.getLogger(CompoundFileBinary.class.getName()).log(Level.FINE, "allocated new sectors of size {0,number,#}", length);
        return newSectorIds;
    }

    private void writeEmptyDirectoryEntry() throws IOException {
        this.writeDirectoryEntry(null, 0, 0, 0xFFFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFL, CLSID_NULL, 0L, null, null, 0L, 0L);
    }

    private void writeDirectoryEntry(DirectoryEntry de) throws IOException {
        this.writeDirectoryEntry(de.name, de.objectType, de.colorFlag, de.leftSiblingId, de.rightSiblingId, de.childId, de.clsId, de.stateBits, de.creationTime, de.modifiedTime, de.startingSectorLocation, de.streamSize);
    }

    private void writeDirectoryEntry(String name, int objectType, int colorFlag, long leftSiblingId, long rightSiblingId, long childId, byte[] clsId, long stateBits, Date creationTime, Date modifiedTime, long startingSectorLocation, long streamSize) throws UnsupportedEncodingException, IOException {
        if (name == null) {
            this.writeZeroBytes(64);
            this.writeUI16(0);
        } else {
            byte[] dirNameBytes = name.getBytes("UTF-16LE");
            if (dirNameBytes.length - 2 > 62) {
                throw new IllegalArgumentException("Name \"" + name + "\" exceeds limit of 32 chars");
            }
            this.raf.write(dirNameBytes);
            int restBytes = 64 - dirNameBytes.length;
            if (restBytes > 0) {
                this.writeZeroBytes(restBytes);
            }
            this.writeUI16(dirNameBytes.length + 2);
        }
        this.write(objectType);
        this.write(colorFlag);
        this.writeUI32(leftSiblingId);
        this.writeUI32(rightSiblingId);
        this.writeUI32(childId);
        this.raf.write(clsId);
        this.writeUI32(stateBits);
        this.writeDate(creationTime);
        this.writeDate(modifiedTime);
        this.writeUI32(startingSectorLocation);
        this.writeUI64(streamSize);
    }

    private void initExisting(File file) throws IOException {
        this.raf = new RandomAccessFile(file, "r");
        this.readFile();
    }

    private void readFile() throws IOException {
        this.raf.seek(0L);
        byte[] signature = this.readBytes(SIGNATURE.length);
        if (!Arrays.equals(signature, SIGNATURE)) {
            throw new IOException("Not a CFB file");
        }
        byte[] clsid = this.readBytes(16);
        if (!Arrays.equals(clsid, CLSID_NULL)) {
            throw new IOException("Invalid clsid - MUST be CLSID_NULL");
        }
        int minorVersion = this.readUI16();
        int majorVersion = this.readUI16();
        if (majorVersion != 3 && majorVersion != 4) {
            throw new IOException("Unknown version of the file " + majorVersion);
        }
        int byteOrder = this.readUI16();
        if (byteOrder != 65534) {
            throw new IOException("Invalid byte order");
        }
        int sectorShift = this.readUI16();
        if (majorVersion == 3 && sectorShift != 9) {
            throw new IOException("Sector shift must be 0x0009 for majorVersion 3");
        }
        if (majorVersion == 4 && sectorShift != 12) {
            throw new IOException("Sector shift must be 0x000C for majorVersion 4");
        }
        int miniSectorShift = this.readUI16();
        if (miniSectorShift != 6) {
            throw new IOException("Mini sector shift must be 0x0006");
        }
        this.skipZeroBytes(6, "Reserved bytes must be zero");
        long numDirectorySectors = this.readUI32();
        if (majorVersion == 3 && numDirectorySectors != 0L) {
            throw new IOException("Number of directory sectors must be zero for majorVersion 3");
        }
        this.numFatSectors = this.readUI32();
        this.firstDirectorySectorLocation = this.readUI32();
        long transactionSignatureNumber = this.readUI32();
        this.miniStreamCutoffSize = this.readUI32();
        this.firstMiniFatSectorLocation = this.readUI32();
        this.numMiniFatSectors = this.readUI32();
        long firstDifatSectorLocation = this.readUI32();
        this.numDifatSectors = this.readUI32();
        this.difat = new ArrayList<Long>();
        for (int i = 0; i < 109; ++i) {
            this.difat.add(this.readUI32());
        }
        if (majorVersion == 4) {
            this.skipZeroBytes(3584, "Rest of header sector should be zero");
        }
        this.sectorLength = 0;
        if (majorVersion == 3) {
            this.sectorLength = 512;
        }
        if (majorVersion == 4) {
            this.sectorLength = 4096;
        }
        long difatSectorLocation = firstDifatSectorLocation;
        while (difatSectorLocation <= 0xFFFFFFFAL) {
            this.raf.seek((1L + difatSectorLocation) * (long)this.sectorLength);
            for (int i = 0; i < this.sectorLength - 4; i += 4) {
                this.difat.add(this.readUI32());
            }
            difatSectorLocation = this.readUI32();
        }
        this.fat = new TreeMap<Long, Long>();
        long fatPos = 0L;
        for (long fatSect : this.difat) {
            if (fatSect > 0xFFFFFFFAL) continue;
            this.raf.seek((1L + fatSect) * (long)this.sectorLength);
            for (int i = 0; i < this.sectorLength; i += 4) {
                this.fat.put(fatPos, this.readUI32());
                ++fatPos;
            }
        }
        this.minifat = new TreeMap<Long, Long>();
        long miniFatSectorLocation = this.firstMiniFatSectorLocation;
        long miniFatPos = 0L;
        while (miniFatSectorLocation != 0xFFFFFFFEL) {
            this.raf.seek((1L + miniFatSectorLocation) * (long)this.sectorLength);
            for (int i = 0; i < this.sectorLength; i += 4) {
                this.minifat.put(miniFatPos, this.readUI32());
                ++miniFatPos;
            }
            miniFatSectorLocation = this.fat.get(miniFatSectorLocation);
        }
        long directorySector = this.firstDirectorySectorLocation;
        this.directoryEntries = new ArrayList<DirectoryEntry>();
        long streamId = 0L;
        while (directorySector != 0xFFFFFFFEL) {
            this.raf.seek((1L + directorySector) * (long)this.sectorLength);
            for (int i = 0; i < this.sectorLength; i += 128) {
                byte[] nameBytes = this.readBytes(64);
                int nameLen = this.readUI16();
                String name = nameLen == 0 ? "" : new String(nameBytes, 0, nameLen - 2, "UTF-16LE");
                int objectType = this.readEx();
                if (!Arrays.asList(0, 1, 2, 5).contains(objectType)) {
                    throw new IOException("Invalid object type: " + objectType);
                }
                int colorFlag = this.readEx();
                if (!Arrays.asList(0, 1).contains(colorFlag)) {
                    throw new IOException("Invalid color flag: " + colorFlag);
                }
                long leftSiblingId = this.readUI32();
                long rightSiblingId = this.readUI32();
                if (leftSiblingId != 0xFFFFFFFFL) {
                    this.entryParents.put(leftSiblingId, streamId);
                }
                if (rightSiblingId != 0xFFFFFFFFL) {
                    this.entryParents.put(rightSiblingId, streamId);
                }
                long childId = this.readUI32();
                byte[] dirClsId = this.readBytes(16);
                long stateBits = this.readUI32();
                Date creationTime = this.readDate();
                Date modifiedTime = this.readDate();
                long startingSectorLocation = this.readUI32();
                if (objectType == 5) {
                    this.miniStreamSizeFileOffset = this.raf.getFilePointer();
                }
                long streamSize = this.readUI64();
                if (majorVersion == 3) {
                    streamSize &= 0xFFFFFFFFL;
                }
                DirectoryEntry dirEntry = new DirectoryEntry((1L + directorySector) * (long)this.sectorLength + (long)i, directorySector, streamId, name, objectType, colorFlag, leftSiblingId, rightSiblingId, childId, dirClsId, stateBits, creationTime, modifiedTime, startingSectorLocation, streamSize);
                if (objectType == 5) {
                    this.miniStreamStartingSector = startingSectorLocation;
                    this.miniStreamSize = streamSize;
                }
                this.directoryEntries.add(dirEntry);
                ++streamId;
            }
            directorySector = this.fat.get(directorySector);
        }
    }

    private InputStream getMiniStream(final long sector, final long totalSize) {
        final int miniSectorLength = 64;
        return new InputStream(this){
            int rsectorPos = 0;
            long rsector = sector;
            long readPos = 0L;
            final /* synthetic */ CompoundFileBinary this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int read() throws IOException {
                if (this.readPos >= totalSize) {
                    return -1;
                }
                if (this.rsector == 0xFFFFFFFEL) {
                    return -1;
                }
                if (this.rsectorPos == miniSectorLength) {
                    this.rsector = (Long)this.this$0.minifat.get(this.rsector);
                    this.rsectorPos = 0;
                }
                if (this.rsector == 0xFFFFFFFEL) {
                    return -1;
                }
                InputStream miniIs = this.this$0.getLargeStream(this.this$0.miniStreamStartingSector, this.this$0.miniStreamSize);
                miniIs.skip(this.rsector * (long)miniSectorLength + (long)this.rsectorPos);
                ++this.rsectorPos;
                ++this.readPos;
                return miniIs.read();
            }
        };
    }

    private InputStream getLargeStream(final long sector, final long totalSize) {
        return new InputStream(this){
            int rsectorPos = 0;
            long rsector = sector;
            long readPos = 0L;
            final /* synthetic */ CompoundFileBinary this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public long skip(long n) throws IOException {
                for (long i = 0L; i < n; ++i) {
                    if (this.readPos >= totalSize) {
                        return i;
                    }
                    if (this.rsector == 0xFFFFFFFEL) {
                        return i;
                    }
                    if (this.rsectorPos == this.this$0.sectorLength) {
                        this.rsector = (Long)this.this$0.fat.get(this.rsector);
                        this.rsectorPos = 0;
                    }
                    if (this.rsector == 0xFFFFFFFEL) {
                        return i;
                    }
                    ++this.rsectorPos;
                }
                return n;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (this.readPos >= totalSize) {
                    return -1;
                }
                if (this.rsector == 0xFFFFFFFEL) {
                    return -1;
                }
                if (this.rsectorPos == this.this$0.sectorLength) {
                    this.rsector = (Long)this.this$0.fat.get(this.rsector);
                    this.rsectorPos = 0;
                }
                if (this.rsector == 0xFFFFFFFEL) {
                    return -1;
                }
                int realReadLen = this.this$0.sectorLength - this.rsectorPos;
                if (realReadLen > len) {
                    realReadLen = len;
                }
                boolean readAll = false;
                if (this.readPos + (long)realReadLen > totalSize) {
                    realReadLen = (int)(totalSize - this.readPos);
                    readAll = true;
                }
                this.this$0.raf.seek((1L + this.rsector) * (long)this.this$0.sectorLength + (long)this.rsectorPos);
                this.this$0.raf.readFully(b, off, realReadLen);
                this.rsectorPos += realReadLen;
                this.readPos += (long)realReadLen;
                int ret = realReadLen;
                if (!readAll && realReadLen < len) {
                    ret += this.read(b, off + realReadLen, len - realReadLen);
                }
                return ret;
            }

            @Override
            public int read() throws IOException {
                if (this.readPos >= totalSize) {
                    return -1;
                }
                if (this.rsector == 0xFFFFFFFEL) {
                    return -1;
                }
                if (this.rsectorPos == this.this$0.sectorLength) {
                    this.rsector = (Long)this.this$0.fat.get(this.rsector);
                    this.rsectorPos = 0;
                }
                if (this.rsector == 0xFFFFFFFEL) {
                    return -1;
                }
                this.this$0.raf.seek((1L + this.rsector) * (long)this.this$0.sectorLength + (long)this.rsectorPos);
                ++this.rsectorPos;
                ++this.readPos;
                return this.this$0.raf.read();
            }
        };
    }

    public InputStream getEntryStream(DirectoryEntry entry) {
        if (entry.streamSize < this.miniStreamCutoffSize) {
            return this.getMiniStream(entry.startingSectorLocation, entry.streamSize);
        }
        return this.getLargeStream(entry.startingSectorLocation, entry.streamSize);
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    public List<DirectoryEntry> getDirectoryEntries() {
        return this.directoryEntries;
    }

    public void extractTo(String path, File targetDir) throws IOException {
        DirectoryEntry de = this.getEntryByPath(path);
        this.extractTo(de, targetDir);
    }

    public void extractTo(DirectoryEntry de, File targetPath) throws IOException {
        if (de == null) {
            return;
        }
        Logger.getLogger(CompoundFileBinary.class.getName()).log(Level.FINE, "Extracting {0}", de.name);
        if (de.objectType == 2) {
            InputStream is = this.getEntryStream(de);
            File outFile = targetPath.toPath().toFile();
            try (FileOutputStream fos = new FileOutputStream(outFile);){
                int cnt;
                byte[] buf = new byte[4096];
                while ((cnt = is.read(buf)) > 0) {
                    fos.write(buf, 0, cnt);
                }
            }
        }
        if (de.objectType == 1 || de.objectType == 5) {
            List<DirectoryEntry> entries = this.getEntriesInDir(de);
            for (DirectoryEntry en : entries) {
                this.extractTo(en, targetPath.toPath().resolve(en.getFilename()).toFile());
            }
        }
    }

    public static void main(String[] args) throws IOException {
        new File("out").mkdir();
        File outFile = new File("out/mycbf.fla");
        CompoundFileBinary cd = new CompoundFileBinary(outFile, true);
        cd.setRootClsId("08fcfece-b230-461b-9f84-d72f31db07ae");
        cd.addDirectoryContents("", new File("testdata/cbf"));
    }

    public void dumpSect() {
        int d = 0;
        for (long df : this.difat) {
            System.err.println("difat " + d + ": " + CompoundFileBinary.sectToString(df));
            ++d;
        }
        for (long f : this.fat.keySet()) {
            long v = this.fat.get(f);
            System.err.println("fat " + f + ": " + CompoundFileBinary.sectToString(v));
        }
    }

    public static String sectToString(long v) {
        if (v == 0xFFFFFFFFL) {
            return "FREESECT";
        }
        if (v == 0xFFFFFFFDL) {
            return "FATSECT";
        }
        if (v == 0xFFFFFFFCL) {
            return "DIFSECT";
        }
        if (v == 0xFFFFFFFEL) {
            return "ENDOFCHAIN";
        }
        return "" + v;
    }
}

