/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.sample.sflint;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.sfntly.table.core.NameTable;
import com.google.typography.font.sfntly.table.core.OS2Table;
import com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class SFLint {
    private FontFactory fontFactory = FontFactory.getInstance();
    private int problemCount;

    public static void main(String[] stringArray) throws IOException {
        SFLint sFLint = new SFLint();
        File file = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = null;
            if (stringArray[i].charAt(0) == '-') {
                string = stringArray[i].substring(1);
            }
            if (string != null) {
                if (!string.equals("h") && !string.equals("help") && !string.equals("?")) continue;
                SFLint.printUsage();
                System.exit(0);
                continue;
            }
            file = new File(stringArray[i]);
            break;
        }
        if (file != null) {
            sFLint.lintFontFile(file);
        }
    }

    private static final void printUsage() {
        System.out.println("SFLint [-?|-h|-help] fontfile");
        System.out.println("find problems with the font file");
        System.out.println("\t-?,-h,-help\tprint this help information");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lintFontFile(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            Font[] fontArray;
            fileInputStream = new FileInputStream(file);
            for (Font font : fontArray = this.fontFactory.loadFonts(fileInputStream)) {
                this.lintFont(font);
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void lintNameTable(Font font) {
        NameTable nameTable = (NameTable)font.getTable(Tag.name);
        for (NameTable.NameEntry nameEntry : nameTable) {
            if (nameEntry.nameId() != NameTable.NameId.FontFamilyName.value()) continue;
            for (NameTable.NameEntry nameEntry2 : nameTable) {
                if (nameEntry2.nameId() != NameTable.NameId.FullFontName.value() || nameEntry.platformId() != nameEntry2.platformId() || nameEntry.encodingId() != nameEntry2.encodingId() || nameEntry.languageId() != nameEntry2.languageId() || nameEntry2.name().startsWith(nameEntry.name())) continue;
                this.reportProblem("Full font name doesn't begin with family name: FontFamilyName = " + nameEntry.name() + "; FullFontName = " + nameEntry2.name());
            }
        }
    }

    private void lintWindowsClipping(Font font) {
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        int n = locaTable.numGlyphs();
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            int n6;
            int n7 = locaTable.glyphOffset(i);
            Glyph glyph = glyphTable.glyph(n7, n6 = locaTable.glyphLength(i));
            if (glyph == null || glyph.numberOfContours() == 0) continue;
            int n8 = glyph.xMin();
            int n9 = glyph.yMin();
            int n10 = glyph.xMax();
            int n11 = glyph.yMax();
            if (i == 0 || n8 < n2) {
                n2 = n8;
            }
            if (i == 0 || n9 < n3) {
                n3 = n9;
            }
            if (i == 0 || n10 > n4) {
                n4 = n10;
            }
            if (i != 0 && n11 <= n5) continue;
            n5 = n11;
        }
        OS2Table oS2Table = (OS2Table)font.getTable(Tag.OS_2);
        if (oS2Table.usWinAscent() < n5) {
            this.reportProblem("font is clipped on top by " + (n5 - oS2Table.usWinAscent()) + " units");
        }
        if (oS2Table.usWinDescent() < -n3) {
            this.reportProblem("font is clipped on bottom by " + (-n3 - oS2Table.usWinDescent()) + " units");
        }
    }

    private void lintAdvanceWidths(Font font) {
        int n;
        int n2 = 0;
        HorizontalMetricsTable horizontalMetricsTable = (HorizontalMetricsTable)font.getTable(Tag.hmtx);
        for (int i = 0; i < horizontalMetricsTable.numberOfHMetrics(); ++i) {
            n = horizontalMetricsTable.hMetricAdvanceWidth(i);
            if (i != 0 && n <= n2) continue;
            n2 = n;
        }
        HorizontalHeaderTable horizontalHeaderTable = (HorizontalHeaderTable)font.getTable(Tag.hhea);
        n = horizontalHeaderTable.advanceWidthMax();
        if (n2 != horizontalHeaderTable.advanceWidthMax()) {
            this.reportProblem("advanceWidthMax mismatch, expected " + n2 + " got " + n);
        }
    }

    private void lintCompositeGlyph(Font font, CompositeGlyph compositeGlyph, int n) {
        for (int i = 0; i < compositeGlyph.numGlyphs(); ++i) {
            if ((compositeGlyph.flags(i) & 0xC8) != 0) continue;
            for (int j = 0; j < i; ++j) {
                if ((compositeGlyph.flags(i) & 0xFFFFFCDF) != (compositeGlyph.flags(j) & 0xFFFFFCDF) || compositeGlyph.glyphIndex(i) != compositeGlyph.glyphIndex(j) || compositeGlyph.argument1(i) != compositeGlyph.argument1(j) || compositeGlyph.argument2(i) != compositeGlyph.argument2(j)) continue;
                this.reportProblem("glyph " + n + " contains duplicate references");
            }
        }
    }

    private void lintAllGlyphs(Font font) {
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        int n = locaTable.numGlyphs();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = locaTable.glyphOffset(i);
            Glyph glyph = glyphTable.glyph(n3, n2 = locaTable.glyphLength(i));
            if (glyph == null || glyph.glyphType() != Glyph.GlyphType.Composite) continue;
            this.lintCompositeGlyph(font, (CompositeGlyph)glyph, i);
        }
    }

    private void lintOS2Misc(Font font) {
        int n;
        OS2Table oS2Table = (OS2Table)font.getTable(Tag.OS_2);
        int n2 = oS2Table.usWidthClass();
        if (n2 < 1 || n2 > 9) {
            this.reportProblem("widthClass must be [1..9] inclusive, was " + n2 + "; IE9 fail");
        }
        if ((n = oS2Table.usWeightClass()) < 100 || n > 900) {
            this.reportProblem("weightClass must be [100..900] inclusive, was " + n);
        } else if (n % 100 != 0) {
            this.reportProblem("weightClass must be multiple of 100, was " + n);
        }
    }

    private void lintFont(Font font) {
        this.problemCount = 0;
        this.lintNameTable(font);
        this.lintWindowsClipping(font);
        this.lintAdvanceWidths(font);
        this.lintAllGlyphs(font);
        this.lintOS2Misc(font);
        if (this.problemCount == 0) {
            System.out.println("No problems found");
        }
    }

    private void reportProblem(String string) {
        ++this.problemCount;
        System.out.println(string);
    }
}

