/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.math.FontMath;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.SubTableContainerTable;
import com.google.typography.font.sfntly.table.bitmap.BigGlyphMetrics;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyph;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import com.google.typography.font.sfntly.table.bitmap.BitmapSizeTable;
import com.google.typography.font.sfntly.table.bitmap.IndexSubTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EblcTable
extends SubTableContainerTable {
    private static final boolean DEBUG = false;
    public static final int NOTDEF = -1;
    private final Object bitmapSizeTableLock = new Object();
    private volatile List<BitmapSizeTable> bitmapSizeTable;

    protected EblcTable(Header header, ReadableFontData readableFontData) {
        super(header, readableFontData);
    }

    public int version() {
        return this.data.readFixed(Offset.version.offset);
    }

    public int numSizes() {
        return this.data.readULongAsInt(Offset.numSizes.offset);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("\nnum sizes = ");
        stringBuilder.append(this.numSizes());
        stringBuilder.append("\n");
        for (int i = 0; i < this.numSizes(); ++i) {
            stringBuilder.append(i);
            stringBuilder.append(": ");
            BitmapSizeTable bitmapSizeTable = this.bitmapSizeTable(i);
            stringBuilder.append(bitmapSizeTable.toString());
        }
        return stringBuilder.toString();
    }

    public BitmapSizeTable bitmapSizeTable(int n) {
        if (n < 0 || n > this.numSizes()) {
            throw new IndexOutOfBoundsException("Size table index is outside of the range of tables.");
        }
        List<BitmapSizeTable> list = this.getBitmapSizeTableList();
        return list.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BitmapSizeTable> getBitmapSizeTableList() {
        if (this.bitmapSizeTable == null) {
            Object object = this.bitmapSizeTableLock;
            synchronized (object) {
                if (this.bitmapSizeTable == null) {
                    this.bitmapSizeTable = EblcTable.createBitmapSizeTable(this.data, this.numSizes());
                }
            }
        }
        return this.bitmapSizeTable;
    }

    private static List<BitmapSizeTable> createBitmapSizeTable(ReadableFontData readableFontData, int n) {
        ArrayList<BitmapSizeTable> arrayList = new ArrayList<BitmapSizeTable>();
        for (int i = 0; i < n; ++i) {
            BitmapSizeTable.Builder builder = BitmapSizeTable.Builder.createBuilder(readableFontData.slice(Offset.bitmapSizeTableArrayStart.offset + i * Offset.bitmapSizeTableLength.offset, Offset.bitmapSizeTableLength.offset), readableFontData);
            BitmapSizeTable bitmapSizeTable = (BitmapSizeTable)builder.build();
            arrayList.add(bitmapSizeTable);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static final class Builder
    extends SubTableContainerTable.Builder<EblcTable> {
        private final int version = 131072;
        private List<BitmapSizeTable.Builder> sizeTableBuilders;

        public static Builder createBuilder(Header header, WritableFontData writableFontData) {
            return new Builder(header, writableFontData);
        }

        public static Builder createBuilder(Header header, ReadableFontData readableFontData) {
            return new Builder(header, readableFontData);
        }

        protected Builder(Header header, WritableFontData writableFontData) {
            super(header, writableFontData);
        }

        protected Builder(Header header, ReadableFontData readableFontData) {
            super(header, readableFontData);
        }

        public List<BitmapSizeTable.Builder> bitmapSizeBuilders() {
            return this.getSizeList();
        }

        protected void revert() {
            this.sizeTableBuilders = null;
            this.setModelChanged(false);
        }

        public List<Map<Integer, BitmapGlyphInfo>> generateLocaList() {
            List<BitmapSizeTable.Builder> list = this.getSizeList();
            ArrayList<Map<Integer, BitmapGlyphInfo>> arrayList = new ArrayList<Map<Integer, BitmapGlyphInfo>>(list.size());
            boolean bl = false;
            for (BitmapSizeTable.Builder builder : list) {
                Map<Integer, BitmapGlyphInfo> map = builder.generateLocaMap();
                arrayList.add(map);
            }
            return arrayList;
        }

        private List<BitmapSizeTable.Builder> getSizeList() {
            if (this.sizeTableBuilders == null) {
                this.sizeTableBuilders = this.initialize(this.internalReadData());
                super.setModelChanged();
            }
            return this.sizeTableBuilders;
        }

        private List<BitmapSizeTable.Builder> initialize(ReadableFontData readableFontData) {
            ArrayList<BitmapSizeTable.Builder> arrayList = new ArrayList<BitmapSizeTable.Builder>();
            if (readableFontData != null) {
                int n = readableFontData.readULongAsInt(Offset.numSizes.offset);
                for (int i = 0; i < n; ++i) {
                    BitmapSizeTable.Builder builder = BitmapSizeTable.Builder.createBuilder(readableFontData.slice(Offset.bitmapSizeTableArrayStart.offset + i * Offset.bitmapSizeTableLength.offset, Offset.bitmapSizeTableLength.offset), readableFontData);
                    arrayList.add(builder);
                }
            }
            return arrayList;
        }

        @Override
        protected EblcTable subBuildTable(ReadableFontData readableFontData) {
            return new EblcTable(this.header(), readableFontData);
        }

        @Override
        protected void subDataSet() {
            this.revert();
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.sizeTableBuilders == null) {
                return 0;
            }
            int n = Offset.headerLength.offset;
            boolean bl = false;
            boolean bl2 = false;
            for (BitmapSizeTable.Builder builder : this.sizeTableBuilders) {
                int n2 = builder.subDataSizeToSerialize();
                bl = n2 > 0 ? bl : true;
                n += Math.abs(n2);
            }
            return bl ? -n : n;
        }

        @Override
        protected boolean subReadyToSerialize() {
            if (this.sizeTableBuilders == null) {
                return false;
            }
            for (BitmapSizeTable.Builder builder : this.sizeTableBuilders) {
                if (builder.subReadyToSerialize()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            int n;
            int n2;
            int n3 = writableFontData.writeFixed(0, this.version);
            n3 += writableFontData.writeULong(n3, this.sizeTableBuilders.size());
            int n4 = n2 = n3;
            int n5 = n = n4 + this.sizeTableBuilders.size() * Offset.bitmapSizeTableLength.offset;
            boolean bl = false;
            for (BitmapSizeTable.Builder builder : this.sizeTableBuilders) {
                builder.setIndexSubTableArrayOffset(n5);
                List<IndexSubTable.Builder<? extends IndexSubTable>> list = builder.indexSubTableBuilders();
                int n6 = n5;
                int n7 = n6 + list.size() * Offset.indexSubHeaderLength.offset;
                boolean bl2 = false;
                for (IndexSubTable.Builder<? extends IndexSubTable> builder2 : list) {
                    n6 += writableFontData.writeUShort(n6, builder2.firstGlyphIndex());
                    n6 += writableFontData.writeUShort(n6, builder2.lastGlyphIndex());
                    n6 += writableFontData.writeULong(n6, n7 - n5);
                    int n8 = builder2.subSerialize(writableFontData.slice(n7));
                    int n9 = FontMath.paddingRequired(n8, FontData.DataSize.ULONG.size());
                    n7 += n8;
                    n7 += writableFontData.writePadding(n7, n9);
                }
                builder.setIndexTableSize(n7 - n5);
                n4 += builder.subSerialize(writableFontData.slice(n4));
                n5 = n7;
            }
            return n3 + n5;
        }
    }

    static enum Offset {
        version(0),
        numSizes(4),
        headerLength(Offset.numSizes.offset + FontData.DataSize.ULONG.size()),
        bitmapSizeTableArrayStart(Offset.headerLength.offset),
        bitmapSizeTableLength(48),
        bitmapSizeTable_indexSubTableArrayOffset(0),
        bitmapSizeTable_indexTableSize(4),
        bitmapSizeTable_numberOfIndexSubTables(8),
        bitmapSizeTable_colorRef(12),
        bitmapSizeTable_hori(16),
        bitmapSizeTable_vert(28),
        bitmapSizeTable_startGlyphIndex(40),
        bitmapSizeTable_endGlyphIndex(42),
        bitmapSizeTable_ppemX(44),
        bitmapSizeTable_ppemY(45),
        bitmapSizeTable_bitDepth(46),
        bitmapSizeTable_flags(47),
        sbitLineMetricsLength(12),
        sbitLineMetrics_ascender(0),
        sbitLineMetrics_descender(1),
        sbitLineMetrics_widthMax(2),
        sbitLineMetrics_caretSlopeNumerator(3),
        sbitLineMetrics__caretSlopeDenominator(4),
        sbitLineMetrics_caretOffset(5),
        sbitLineMetrics_minOriginSB(6),
        sbitLineMetrics_minAdvanceSB(7),
        sbitLineMetrics_maxBeforeBL(8),
        sbitLineMetrics_minAfterBL(9),
        sbitLineMetrics_pad1(10),
        sbitLineMetrics_pad2(11),
        indexSubTableEntryLength(8),
        indexSubTableEntry_firstGlyphIndex(0),
        indexSubTableEntry_lastGlyphIndex(2),
        indexSubTableEntry_additionalOffsetToIndexSubtable(4),
        indexSubHeaderLength(8),
        indexSubHeader_indexFormat(0),
        indexSubHeader_imageFormat(2),
        indexSubHeader_imageDataOffset(4),
        indexSubTable1_offsetArray(Offset.indexSubHeaderLength.offset),
        indexSubTable1_builderDataSize(Offset.indexSubHeaderLength.offset),
        indexSubTable2Length(Offset.indexSubHeaderLength.offset + FontData.DataSize.ULONG.size() + BitmapGlyph.Offset.bigGlyphMetricsLength.offset),
        indexSubTable2_imageSize(Offset.indexSubHeaderLength.offset),
        indexSubTable2_bigGlyphMetrics(Offset.indexSubTable2_imageSize.offset + FontData.DataSize.ULONG.size()),
        indexSubTable2_builderDataSize(Offset.indexSubTable2_bigGlyphMetrics.offset + BigGlyphMetrics.Offset.metricsLength.offset),
        indexSubTable3_offsetArray(Offset.indexSubHeaderLength.offset),
        indexSubTable3_builderDataSize(Offset.indexSubTable3_offsetArray.offset),
        indexSubTable4_numGlyphs(Offset.indexSubHeaderLength.offset),
        indexSubTable4_glyphArray(Offset.indexSubTable4_numGlyphs.offset + FontData.DataSize.ULONG.size()),
        indexSubTable4_codeOffsetPairLength(2 * FontData.DataSize.USHORT.size()),
        indexSubTable4_codeOffsetPair_glyphCode(0),
        indexSubTable4_codeOffsetPair_offset(FontData.DataSize.USHORT.size()),
        indexSubTable4_builderDataSize(Offset.indexSubTable4_glyphArray.offset),
        indexSubTable5_imageSize(Offset.indexSubHeaderLength.offset),
        indexSubTable5_bigGlyphMetrics(Offset.indexSubTable5_imageSize.offset + FontData.DataSize.ULONG.size()),
        indexSubTable5_numGlyphs(Offset.indexSubTable5_bigGlyphMetrics.offset + BitmapGlyph.Offset.bigGlyphMetricsLength.offset),
        indexSubTable5_glyphArray(Offset.indexSubTable5_numGlyphs.offset + FontData.DataSize.ULONG.size()),
        indexSubTable5_builderDataSize(Offset.indexSubTable5_glyphArray.offset),
        codeOffsetPairLength(2 * FontData.DataSize.USHORT.size()),
        codeOffsetPair_glyphCode(0),
        codeOffsetPair_offset(FontData.DataSize.USHORT.size());

        final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

