/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CMapFormat12
extends CMap {
    private final int numberOfGroups;

    protected CMapFormat12(ReadableFontData readableFontData, CMapTable.CMapId cMapId) {
        super(readableFontData, CMap.CMapFormat.Format12.value, cMapId);
        this.numberOfGroups = this.data.readULongAsInt(CMapTable.Offset.format12nGroups.offset);
    }

    private int groupStartChar(int n) {
        return this.data.readULongAsInt(CMapTable.Offset.format12Groups.offset + n * CMapTable.Offset.format12Groups_structLength.offset + CMapTable.Offset.format12_startCharCode.offset);
    }

    private int groupEndChar(int n) {
        return this.data.readULongAsInt(CMapTable.Offset.format12Groups.offset + n * CMapTable.Offset.format12Groups_structLength.offset + CMapTable.Offset.format12_endCharCode.offset);
    }

    private int groupStartGlyph(int n) {
        return this.data.readULongAsInt(CMapTable.Offset.format12Groups.offset + n * CMapTable.Offset.format12Groups_structLength.offset + CMapTable.Offset.format12_startGlyphId.offset);
    }

    @Override
    public int glyphId(int n) {
        int n2 = this.data.searchULong(CMapTable.Offset.format12Groups.offset + CMapTable.Offset.format12_startCharCode.offset, CMapTable.Offset.format12Groups_structLength.offset, CMapTable.Offset.format12Groups.offset + CMapTable.Offset.format12_endCharCode.offset, CMapTable.Offset.format12Groups_structLength.offset, this.numberOfGroups, n);
        if (n2 == -1) {
            return 0;
        }
        return this.groupStartGlyph(n2) + (n - this.groupStartChar(n2));
    }

    @Override
    public int language() {
        return this.data.readULongAsInt(CMapTable.Offset.format12Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CharacterIterator();
    }

    public static class Builder
    extends CMap.Builder<CMapFormat12> {
        protected Builder(WritableFontData writableFontData, int n, CMapTable.CMapId cMapId) {
            super(writableFontData == null ? null : writableFontData.slice(n, writableFontData.readULongAsInt(n + CMapTable.Offset.format12Length.offset)), CMap.CMapFormat.Format12, cMapId);
        }

        protected Builder(ReadableFontData readableFontData, int n, CMapTable.CMapId cMapId) {
            super(readableFontData == null ? null : readableFontData.slice(n, readableFontData.readULongAsInt(n + CMapTable.Offset.format12Length.offset)), CMap.CMapFormat.Format12, cMapId);
        }

        @Override
        protected CMapFormat12 subBuildTable(ReadableFontData readableFontData) {
            return new CMapFormat12(readableFontData, this.cmapId());
        }
    }

    private final class CharacterIterator
    implements Iterator<Integer> {
        private int groupIndex = 0;
        private int groupEndChar;
        private boolean nextSet = false;
        private int nextChar;

        private CharacterIterator() {
            this.nextChar = CMapFormat12.this.groupStartChar(this.groupIndex);
            this.groupEndChar = CMapFormat12.this.groupEndChar(this.groupIndex);
            this.nextSet = true;
        }

        @Override
        public boolean hasNext() {
            if (this.nextSet) {
                return true;
            }
            if (this.groupIndex >= CMapFormat12.this.numberOfGroups) {
                return false;
            }
            if (this.nextChar < this.groupEndChar) {
                ++this.nextChar;
                this.nextSet = true;
                return true;
            }
            ++this.groupIndex;
            if (this.groupIndex < CMapFormat12.this.numberOfGroups) {
                this.nextSet = true;
                this.nextChar = CMapFormat12.this.groupStartChar(this.groupIndex);
                this.groupEndChar = CMapFormat12.this.groupEndChar(this.groupIndex);
                return true;
            }
            return false;
        }

        @Override
        public Integer next() {
            if (!this.nextSet && !this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            this.nextSet = false;
            return this.nextChar;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }
}

