/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.tools.conversion.eot.MtxHeadBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class MtxFontBuilder {
    private static final int OPENTYPE_VERSION_1_0 = 65536;
    private static final int FONT_HEADER_BASE_SIZE = 12;
    private static final int FONT_HEADER_PER_TABLE_SIZE = 16;
    private static final int TABLE_ALIGN = 4;
    private Map<Integer, ReadableFontData> tables = new HashMap<Integer, ReadableFontData>();
    private MtxHeadBuilder headBuilder = new MtxHeadBuilder();

    public MtxHeadBuilder getHeadBuilder() {
        return this.headBuilder;
    }

    public void addTable(int n, ReadableFontData readableFontData) {
        this.tables.put(n, readableFontData);
    }

    public void addTableBytes(int n, byte[] byArray) {
        this.addTable(n, ReadableFontData.createReadableFontData(byArray));
    }

    private static void putUshort(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 8);
        byArray[n + 1] = (byte)n2;
    }

    private static void putUlong(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    public byte[] build() {
        this.addTable(Tag.head, this.headBuilder.build());
        TreeSet<Integer> treeSet = new TreeSet<Integer>(this.tables.keySet());
        int n = this.tables.size();
        int n2 = 12 + 16 * n;
        for (Map.Entry<Integer, ReadableFontData> entry : this.tables.entrySet()) {
            ReadableFontData readableFontData = entry.getValue();
            if (readableFontData == null) continue;
            n2 += entry.getValue().length() + 4 - 1 & 0xFFFFFFFC;
        }
        Object object = new byte[n2];
        MtxFontBuilder.putUlong((byte[])object, 0, 65536);
        MtxFontBuilder.putUshort((byte[])object, 4, n);
        boolean bl = false;
        int n3 = MtxFontBuilder.searchRange(n);
        MtxFontBuilder.putUshort((byte[])object, 6, n3 * 16);
        MtxFontBuilder.putUshort((byte[])object, 8, MtxFontBuilder.log2(n3));
        MtxFontBuilder.putUshort((byte[])object, 10, (n - n3) * 16);
        int n4 = 12;
        int n5 = 12 + 16 * n;
        for (Integer n6 : treeSet) {
            ReadableFontData readableFontData = this.tables.get(n6);
            MtxFontBuilder.putUlong((byte[])object, n4, n6);
            int n7 = 0;
            MtxFontBuilder.putUlong((byte[])object, n4 + 4, n7);
            if (readableFontData == null) {
                MtxFontBuilder.putUlong((byte[])object, n4 + 8, 0);
                MtxFontBuilder.putUlong((byte[])object, n4 + 12, 0);
            } else {
                MtxFontBuilder.putUlong((byte[])object, n4 + 8, n5);
                int n8 = readableFontData.length();
                MtxFontBuilder.putUlong((byte[])object, n4 + 12, n8);
                readableFontData.readBytes(0, (byte[])object, n5, n8);
                n5 += n8 + 4 - 1 & 0xFFFFFFFC;
            }
            n4 += 16;
        }
        return object;
    }

    static int searchRange(int n) {
        return Integer.highestOneBit(n);
    }

    static int log2(int n) {
        return 31 - Integer.numberOfLeadingZeros(n);
    }
}

