/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapFormat4;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.tools.subsetter.CMapTableBuilder;
import com.google.typography.font.tools.subsetter.Subsetter;
import com.google.typography.font.tools.subsetter.TableSubsetterImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RenumberingCMapTableSubsetter
extends TableSubsetterImpl {
    public RenumberingCMapTableSubsetter() {
        super(Tag.cmap);
    }

    private static CMapFormat4 getCMapFormat4(Font font) {
        CMapTable cMapTable = (CMapTable)font.getTable(Tag.cmap);
        for (CMap cMap : cMapTable) {
            if (cMap.format() != CMap.CMapFormat.Format4.value()) continue;
            return (CMapFormat4)cMap;
        }
        return null;
    }

    static Map<Integer, Integer> computeMapping(Subsetter subsetter, Font font) {
        CMapFormat4 cMapFormat4 = RenumberingCMapTableSubsetter.getCMapFormat4(font);
        if (cMapFormat4 == null) {
            throw new RuntimeException("CMap format 4 table in source font not found");
        }
        Map<Integer, Integer> map = subsetter.getInverseMapping();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (Integer n : cMapFormat4) {
            int n2 = cMapFormat4.glyphId(n);
            if (!map.containsKey(n2)) continue;
            hashMap.put(n, map.get(n2));
        }
        return hashMap;
    }

    @Override
    public boolean subset(Subsetter subsetter, Font font, Font.Builder builder) throws IOException {
        CMapTableBuilder cMapTableBuilder = new CMapTableBuilder(builder, RenumberingCMapTableSubsetter.computeMapping(subsetter, font));
        cMapTableBuilder.build();
        return true;
    }
}

