/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.build;

import com.jpexs.helpers.Helper;
import java.io.File;
import java.io.UnsupportedEncodingException;

public class LocaleConverter {
    private static void convertFile(File f) throws UnsupportedEncodingException {
        String data = Helper.readTextFile((String[])new String[]{f.getAbsolutePath()});
        StringBuilder sb = new StringBuilder();
        boolean modified = false;
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c > '\u007f') {
                sb.append("\\u");
                sb.append(String.format("%04x", c & 0xFFFF));
                modified = true;
                continue;
            }
            sb.append(c);
        }
        if (modified) {
            System.err.println("converted: " + f);
            Helper.writeFile((String)f.getAbsolutePath(), (byte[][])new byte[][]{sb.toString().getBytes("UTF-8")});
        }
    }

    private static void walk(String path) throws UnsupportedEncodingException {
        File root = new File(path);
        File[] list = root.listFiles();
        if (list == null) {
            return;
        }
        for (File f : list) {
            if (f.isDirectory()) {
                LocaleConverter.walk(f.getAbsolutePath());
                continue;
            }
            if (!f.getName().endsWith(".properties")) continue;
            LocaleConverter.convertFile(f);
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        LocaleConverter.walk("src");
        LocaleConverter.walk("libsrc/ffdec_lib/src");
    }
}

