/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.console;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import java.util.Locale;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsoleAbortRetryIgnoreHandler
implements AbortRetryIgnoreHandler {
    int errorCount = 0;
    int errorMode;
    int retryCount;

    public ConsoleAbortRetryIgnoreHandler(int errorMode, int retryCount) {
        this.errorMode = errorMode;
        this.retryCount = retryCount;
    }

    public int handle(Throwable thrown) {
        if (thrown instanceof InterruptedException) {
            return 0;
        }
        if (this.errorMode != -1) {
            int result = this.errorMode;
            if (this.errorMode == 1 && this.errorCount < this.retryCount) {
                ++this.errorCount;
            } else {
                result = 2;
            }
            return result;
        }
        Scanner sc = new Scanner(System.in);
        if (thrown != null) {
            Logger.getLogger(ConsoleAbortRetryIgnoreHandler.class.getName()).log(Level.SEVERE, "Error occurred", thrown);
            System.out.println("Error occurred: " + thrown.getLocalizedMessage());
        }
        while (true) {
            System.out.print("Select action: (A)bort, (R)Retry, (I)Ignore:");
            String n = sc.nextLine();
            switch (n.toLowerCase(Locale.ENGLISH)) {
                case "a": {
                    return 0;
                }
                case "r": {
                    return 1;
                }
                case "i": {
                    return 2;
                }
            }
        }
    }

    public AbortRetryIgnoreHandler getNewInstance() {
        return new ConsoleAbortRetryIgnoreHandler(this.errorMode, this.retryCount);
    }
}

