/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.easygui.CharacterTagTransferHandler;
import com.jpexs.decompiler.flash.easygui.EasyStrings;
import com.jpexs.decompiler.flash.easygui.EasySwfPanel;
import com.jpexs.decompiler.flash.easygui.EasyTagNameResolver;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.Helper;
import de.javagl.treetable.JTreeTable;
import de.javagl.treetable.TreeTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class LibraryTreeTable
extends JTreeTable {
    private final EasySwfPanel easySwfPanel;
    private SWF swf;

    public LibraryTreeTable(final EasySwfPanel easySwfPanel) {
        super(new LibraryTreeTableModel(null));
        this.getTree().setCellRenderer(new LibraryTreeCellRenderer());
        this.getTree().setRootVisible(false);
        this.getTree().setShowsRootHandles(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int parentRow;
                TreePath path;
                int selectedRow = LibraryTreeTable.this.getSelectedRow();
                JTree tree = LibraryTreeTable.this.getTree();
                if (e.getKeyCode() == 37) {
                    TreePath parentPath;
                    path = tree.getPathForRow(selectedRow);
                    if (path != null && tree.isExpanded(path)) {
                        tree.collapsePath(path);
                        parentRow = tree.getRowForPath(path);
                        LibraryTreeTable.this.changeSelection(parentRow, 0, false, false);
                    } else if (path != null && (parentPath = path.getParentPath()) != null) {
                        int parentRow2 = tree.getRowForPath(parentPath);
                        LibraryTreeTable.this.changeSelection(parentRow2, 0, false, false);
                    }
                    e.consume();
                }
                if (e.getKeyCode() == 39) {
                    path = tree.getPathForRow(selectedRow);
                    if (path != null && !tree.isExpanded(path)) {
                        tree.expandPath(path);
                        parentRow = tree.getRowForPath(path);
                        LibraryTreeTable.this.changeSelection(parentRow, 0, false, false);
                    } else {
                        TreePath childPath = tree.getPathForRow(selectedRow + 1);
                        if (childPath != null) {
                            int childRow = tree.getRowForPath(childPath);
                            LibraryTreeTable.this.changeSelection(childRow, 0, false, false);
                        }
                    }
                    e.consume();
                }
            }
        });
        this.setTransferHandler(new CharacterTagTransferHandler());
        this.setDragEnabled(true);
        this.setSelectionMode(0);
        this.setUI(new BasicTableUI());
        this.setRowHeight(18);
        this.getTree().setRowHeight(18);
        if (View.isOceanic()) {
            this.setBackground(Color.WHITE);
            this.getTree().setBackground(Color.WHITE);
        }
        this.easySwfPanel = easySwfPanel;
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ LibraryTreeTable this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    int selectedRow = this.this$0.getSelectedRow();
                    if (selectedRow == -1) {
                        return;
                    }
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.this$0.getValueAt(selectedRow, 0);
                    Object obj = node.getUserObject();
                    if (obj instanceof Timelined) {
                        easySwfPanel.setTimelined((Timelined)obj);
                    }
                }
            }
        });
    }

    public void setSwf(SWF swf) {
        if (swf == this.swf) {
            return;
        }
        this.swf = swf;
        this.setTreeTableModel(new LibraryTreeTableModel(swf));
    }

    private static class LibraryTreeTableModel
    implements TreeTableModel {
        private DefaultMutableTreeNode root;

        public LibraryTreeTableModel(SWF swf) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("SWF");
            DefaultMutableTreeNode imagesNode = new DefaultMutableTreeNode(new LibraryFolder("images"));
            DefaultMutableTreeNode graphicsNode = new DefaultMutableTreeNode(new LibraryFolder("graphics"));
            DefaultMutableTreeNode shapeTweensNode = new DefaultMutableTreeNode(new LibraryFolder("shapeTweens"));
            DefaultMutableTreeNode textsNode = new DefaultMutableTreeNode(new LibraryFolder("texts"));
            DefaultMutableTreeNode fontsNode = new DefaultMutableTreeNode(new LibraryFolder("fonts"));
            DefaultMutableTreeNode movieClipsNode = new DefaultMutableTreeNode(new LibraryFolder("movieClips"));
            DefaultMutableTreeNode buttonsNode = new DefaultMutableTreeNode(new LibraryFolder("buttons"));
            DefaultMutableTreeNode soundsNode = new DefaultMutableTreeNode(new LibraryFolder("sounds"));
            DefaultMutableTreeNode videosNode = new DefaultMutableTreeNode(new LibraryFolder("videos"));
            this.root = root;
            if (swf == null) {
                return;
            }
            for (Tag t : swf.getTags()) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(t);
                if (t instanceof ImageTag) {
                    imagesNode.add(node);
                }
                if (t instanceof ShapeTag) {
                    graphicsNode.add(node);
                }
                if (t instanceof MorphShapeTag) {
                    shapeTweensNode.add(node);
                }
                if (t instanceof TextTag) {
                    textsNode.add(node);
                }
                if (t instanceof FontTag) {
                    fontsNode.add(node);
                }
                if (t instanceof DefineSpriteTag) {
                    movieClipsNode.add(node);
                }
                if (t instanceof ButtonTag) {
                    buttonsNode.add(node);
                }
                if (t instanceof SoundTag) {
                    soundsNode.add(node);
                }
                if (!(t instanceof DefineVideoStreamTag)) continue;
                videosNode.add(node);
            }
            if (!imagesNode.isLeaf()) {
                root.add(imagesNode);
            }
            if (!graphicsNode.isLeaf()) {
                root.add(graphicsNode);
            }
            if (!shapeTweensNode.isLeaf()) {
                root.add(shapeTweensNode);
            }
            if (!textsNode.isLeaf()) {
                root.add(textsNode);
            }
            if (!fontsNode.isLeaf()) {
                root.add(fontsNode);
            }
            if (!movieClipsNode.isLeaf()) {
                root.add(movieClipsNode);
            }
            if (!buttonsNode.isLeaf()) {
                root.add(buttonsNode);
            }
            if (!soundsNode.isLeaf()) {
                root.add(soundsNode);
            }
            if (!videosNode.isLeaf()) {
                root.add(videosNode);
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return EasyStrings.translate("library.header.name");
                }
                case 1: {
                    return EasyStrings.translate("library.header.asLinkage");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return TreeTableModel.class;
                }
            }
            return String.class;
        }

        @Override
        public Object getValueAt(Object node, int column) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)node;
            Object o = n.getUserObject();
            switch (column) {
                case 0: {
                    return node;
                }
                case 1: {
                    if (o instanceof CharacterTag) {
                        CharacterTag ct = (CharacterTag)o;
                        String exportName = ct.getExportName();
                        if (exportName != null) {
                            return Helper.escapeExportname((SWF)ct.getSwf(), (String)exportName, (boolean)false);
                        }
                        LinkedHashSet classNames = ct.getClassNames();
                        if (!classNames.isEmpty()) {
                            ArrayList<String> escapedList = new ArrayList<String>();
                            for (String className : classNames) {
                                escapedList.add(DottedChain.parseNoSuffix((String)className).toPrintableString(new LinkedHashSet(), ct.getSwf(), true));
                            }
                            return String.join((CharSequence)", ", escapedList);
                        }
                    }
                    return "";
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(Object node, int column) {
            return column == 0;
        }

        @Override
        public void setValueAt(Object value, Object node, int column) {
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((DefaultMutableTreeNode)parent).getChildAt(index);
        }

        @Override
        public int getChildCount(Object parent) {
            return ((DefaultMutableTreeNode)parent).getChildCount();
        }

        @Override
        public boolean isLeaf(Object node) {
            return ((DefaultMutableTreeNode)node).isLeaf();
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return ((DefaultMutableTreeNode)parent).getIndex((DefaultMutableTreeNode)child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }

    private static class LibraryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private LibraryTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                ShapeTag st;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object object = node.getUserObject();
                if (object instanceof LibraryFolder) {
                    String folderName = ((LibraryFolder)object).getName();
                    String prefix = "folder";
                    switch (folderName) {
                        case "images": {
                            label.setIcon(View.getIcon(prefix + "images16"));
                            break;
                        }
                        case "graphics": {
                            label.setIcon(View.getIcon(prefix + "shapes16"));
                            break;
                        }
                        case "shapeTweens": {
                            label.setIcon(View.getIcon(prefix + "morphshapes16"));
                            break;
                        }
                        case "texts": {
                            label.setIcon(View.getIcon(prefix + "texts16"));
                            break;
                        }
                        case "fonts": {
                            label.setIcon(View.getIcon(prefix + "fonts16"));
                            break;
                        }
                        case "movieClips": {
                            label.setIcon(View.getIcon(prefix + "sprites16"));
                            break;
                        }
                        case "buttons": {
                            label.setIcon(View.getIcon(prefix + "buttons16"));
                            break;
                        }
                        case "sounds": {
                            label.setIcon(View.getIcon(prefix + "sounds16"));
                            break;
                        }
                        case "videos": {
                            label.setIcon(View.getIcon(prefix + "movies16"));
                            break;
                        }
                        default: {
                            label.setIcon(View.getIcon("folder16"));
                        }
                    }
                }
                if (object instanceof ImageTag) {
                    ImageTag it = (ImageTag)object;
                    label.setIcon(View.getIcon("image16"));
                }
                if (object instanceof ShapeTag) {
                    st = (ShapeTag)object;
                    label.setIcon(View.getIcon("shape16"));
                }
                if (object instanceof MorphShapeTag) {
                    MorphShapeTag mst = (MorphShapeTag)object;
                    label.setIcon(View.getIcon("morphshape16"));
                }
                if (object instanceof TextTag) {
                    TextTag t = (TextTag)object;
                    label.setIcon(View.getIcon("text16"));
                }
                if (object instanceof FontTag) {
                    FontTag f = (FontTag)object;
                    label.setIcon(View.getIcon("font16"));
                }
                if (object instanceof DefineSpriteTag) {
                    st = (DefineSpriteTag)object;
                    label.setIcon(View.getIcon("sprite16"));
                }
                if (object instanceof ButtonTag) {
                    ButtonTag bt = (ButtonTag)object;
                    label.setIcon(View.getIcon("button16"));
                }
                if (object instanceof SoundTag) {
                    st = (SoundTag)object;
                    label.setIcon(View.getIcon("sound16"));
                }
                if (object instanceof DefineVideoStreamTag) {
                    DefineVideoStreamTag vt = (DefineVideoStreamTag)object;
                    label.setIcon(View.getIcon("movie16"));
                }
                if (object instanceof Tag) {
                    EasyTagNameResolver tagNameResolver = new EasyTagNameResolver();
                    label.setText(tagNameResolver.getTagName((Tag)object));
                }
            }
            if (View.isOceanic()) {
                if (this.selected) {
                    label.setBackground(this.getBackgroundSelectionColor());
                } else {
                    label.setBackground(Color.white);
                }
                label.setOpaque(true);
            }
            return label;
        }
    }

    private static class LibraryFolder {
        private String name;

        public LibraryFolder(String name) {
            this.name = name;
        }

        public String toString() {
            return EasyStrings.translate("library.folder." + this.name);
        }

        public String getName() {
            return this.name;
        }
    }
}

