/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui;

import com.jpexs.decompiler.flash.easygui.TabSwitchedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabSwitcher<E>
extends JPanel {
    private final JTabbedPane tabbedPane;
    private final List<E> values;
    private final List<String> titles;
    private Component tabComponent;
    private final JPanel centralPanel;
    private final List<TabSwitchedListener<E>> listeners = new ArrayList<TabSwitchedListener<E>>();

    public TabSwitcher(Component tabComponent) {
        this.titles = new ArrayList<String>();
        this.values = new ArrayList();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = TabSwitcher.this.tabbedPane.getSelectedIndex();
                if (index == -1) {
                    TabSwitcher.this.fireTabSwitched(null);
                } else {
                    TabSwitcher.this.fireTabSwitched(TabSwitcher.this.values.get(index));
                }
            }
        });
        this.tabComponent = tabComponent;
        this.centralPanel = new JPanel();
        this.centralPanel.setLayout(null);
        this.centralPanel.add(tabComponent);
        this.centralPanel.add(this.tabbedPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.centralPanel, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TabSwitcher.this.updateSizes();
            }
        });
    }

    public void addTabSwitchedListener(TabSwitchedListener<E> listener) {
        this.listeners.add(listener);
    }

    public void removeTabSwitchedListener(TabSwitchedListener<E> listener) {
        this.listeners.remove(listener);
    }

    private void fireTabSwitched(E value) {
        for (TabSwitchedListener<E> listener : this.listeners) {
            listener.tabSwitched(value);
        }
    }

    private void updateSizes() {
        this.tabbedPane.setBounds(0, 0, this.centralPanel.getWidth(), this.centralPanel.getHeight());
        int maxH = 0;
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Rectangle r = this.tabbedPane.getUI().getTabBounds(this.tabbedPane, i);
            int h = r.y + r.height;
            if (h <= maxH) continue;
            maxH = h;
        }
        this.tabbedPane.setBounds(0, 0, this.centralPanel.getWidth(), (maxH += 2) + 10);
        this.tabComponent.setBounds(0, maxH, this.centralPanel.getWidth(), this.centralPanel.getHeight() - maxH);
    }

    public Component getTabComponent() {
        return this.tabComponent;
    }

    public void setTabComponent(Component component) {
        if (this.tabComponent != null) {
            this.centralPanel.remove(this.tabComponent);
        }
        this.tabComponent = component;
        this.centralPanel.add(component);
        this.revalidate();
    }

    public void addTab(E value, String title, Icon icon) {
        this.titles.add(title);
        this.values.add(value);
        this.tabbedPane.insertTab(title, icon, new JPanel(), null, this.values.size() - 1);
        this.updateSizes();
    }

    public String getTabTitleAtIndex(int index) {
        return this.titles.get(index);
    }

    public E getValueAtIndex(int index) {
        return this.values.get(index);
    }

    public int getValueCount() {
        return this.values.size();
    }

    public void clear() {
        this.values.clear();
        this.titles.clear();
        this.tabbedPane.removeAll();
        this.fireTabSwitched(null);
    }

    public void setSelectedIndex(int index) {
        this.tabbedPane.setSelectedIndex(index);
    }

    public int getSelectedIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public void setValue(E value) {
        if (value == null) {
            this.setSelectedIndex(-1);
            return;
        }
        int index = this.values.indexOf(value);
        this.setSelectedIndex(index);
    }

    public int indexOf(E value) {
        return this.values.indexOf(value);
    }

    public E getSelectedValue() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.values.get(index);
    }
}

