/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui;

import com.jpexs.decompiler.flash.easygui.TimelineBodyPanel;
import com.jpexs.decompiler.flash.timeline.Timeline;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class TimelineDepthPanel
extends JPanel {
    private int maxDepth;
    public static final int PADDING = 5;
    public static final float FONT_SIZE = 10.0f;
    private int scrollOffset = 0;
    public static final Color BORDER_COLOR = Color.lightGray;
    public static final Color FONT_COLOR = Color.black;

    public TimelineDepthPanel() {
        this.setTimeline(null);
    }

    public void setTimeline(Timeline timeline) {
        this.maxDepth = timeline == null ? 0 : timeline.getMaxDepth();
        String maxDepthStr = Integer.toString(this.maxDepth);
        this.setFont(this.getFont().deriveFont(10.0f));
        int yofs = 18 - this.scrollOffset % 18;
        int height = yofs + this.maxDepth * 18 + 1;
        int maxDepthW = this.getFontMetrics(this.getFont()).stringWidth(maxDepthStr);
        Dimension dim = new Dimension(maxDepthW + 10, height);
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.setMinimumSize(new Dimension(maxDepthW + 10, 0));
        this.revalidate();
    }

    public void scroll(int offset) {
        this.scrollOffset = offset;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int yofs = 18 - this.scrollOffset % 18;
        int start_d = (this.scrollOffset + clip.y) / 18;
        int end_d = (this.scrollOffset + clip.y + clip.height) / 18;
        int d_count = end_d - start_d;
        g.setColor(TimelineBodyPanel.getBackgroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int d = 0; d < d_count; ++d) {
            g.setColor(BORDER_COLOR);
            g.drawLine(0, yofs + d * 18 + 1, this.getWidth(), yofs + d * 18 + 1);
            int curr_d = start_d + d;
            g.setColor(FONT_COLOR);
            g.drawString(start_d + d == 0 ? "a" : Integer.toString(curr_d), 5, yofs + d * 18 - 5);
        }
    }
}

