/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui;

import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.easygui.DoableOperation;
import com.jpexs.decompiler.flash.easygui.EasySwfPanel;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import java.util.ArrayList;
import java.util.List;

public abstract class TimelinedTagListDoableOperation
implements DoableOperation {
    private final EasySwfPanel swfPanel;
    private final Timelined timelined;
    protected List<Tag> tags;
    protected List<BUTTONRECORD> buttonRecords;
    protected boolean wasModified = false;
    protected int fframe;
    protected List<Integer> fdepths;

    public TimelinedTagListDoableOperation(EasySwfPanel swfPanel, Timelined timelined) {
        this.swfPanel = swfPanel;
        this.timelined = timelined;
        this.fframe = swfPanel.getFrame();
        this.fdepths = swfPanel.getDepths();
    }

    @Override
    public void doOperation() {
        this.swfPanel.setTimelined(this.timelined);
        this.swfPanel.setFrame(this.fframe, this.fdepths);
        this.saveTagList();
        this.wasModified = this.timelined.isModified();
        this.timelined.setModified(true);
    }

    protected void saveTagList() {
        if (this.timelined instanceof ButtonTag) {
            ArrayList<BUTTONRECORD> recordsCopy = new ArrayList<BUTTONRECORD>();
            for (BUTTONRECORD rec : ((ButtonTag)this.timelined).getRecords()) {
                recordsCopy.add(new BUTTONRECORD(rec));
            }
            this.buttonRecords = recordsCopy;
        } else {
            this.tags = this.timelined.getTags().toArrayList();
        }
    }

    protected void restoreTagList() {
        if (this.buttonRecords != null) {
            if (this.timelined instanceof ButtonTag) {
                ButtonTag button = (ButtonTag)this.timelined;
                button.getRecords().clear();
                button.getRecords().addAll(this.buttonRecords);
            }
            this.timelined.resetTimeline();
        }
        if (this.tags != null) {
            int i;
            ReadOnlyTagList newTags = this.timelined.getTags();
            int size = newTags.size();
            for (i = 0; i < size; ++i) {
                this.timelined.removeTag(0);
            }
            for (i = 0; i < this.tags.size(); ++i) {
                this.timelined.addTag(this.tags.get(i));
            }
            this.timelined.resetTimeline();
            this.timelined.setFrameCount(this.timelined.getTimeline().getFrameCount());
        }
    }

    @Override
    public void undoOperation() {
        this.swfPanel.setTimelined(this.timelined);
        this.swfPanel.setFrame(this.fframe, this.fdepths);
        this.restoreTagList();
        if (!this.wasModified) {
            this.timelined.setModified(false);
        }
    }

    @Override
    public abstract String getDescription();
}

