/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.easygui.DoableOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class UndoManager {
    private final Map<SWF, Integer> historyPosMap = new WeakHashMap<SWF, Integer>();
    private final Map<SWF, List<DoableOperation>> historyMap = new WeakHashMap<SWF, List<DoableOperation>>();
    private final List<Runnable> changeListeners = new ArrayList<Runnable>();

    public void addChangeListener(Runnable listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(Runnable listener) {
        this.changeListeners.remove(listener);
    }

    private void fireChange() {
        for (Runnable listener : this.changeListeners) {
            listener.run();
        }
    }

    public void doOperation(DoableOperation doableOperation, SWF swf) {
        if (!this.historyMap.containsKey(swf)) {
            this.historyMap.put(swf, new ArrayList());
        }
        if (!this.historyPosMap.containsKey(swf)) {
            this.historyPosMap.put(swf, 0);
        }
        int historyPos = this.historyPosMap.get(swf);
        List<DoableOperation> history = this.historyMap.get(swf);
        while (history.size() > historyPos) {
            history.remove(historyPos);
        }
        this.historyMap.get(swf).add(doableOperation);
        this.historyPosMap.put(swf, this.historyPosMap.get(swf) + 1);
        doableOperation.doOperation();
        this.fireChange();
    }

    public boolean canUndo(SWF swf) {
        if (!this.historyPosMap.containsKey(swf)) {
            return false;
        }
        return this.historyPosMap.get(swf) > 0;
    }

    public String getUndoName(SWF swf) {
        if (!this.canUndo(swf)) {
            return null;
        }
        return this.historyMap.get(swf).get(this.historyPosMap.get(swf) - 1).getDescription();
    }

    public void undo(SWF swf) {
        if (!this.canUndo(swf)) {
            return;
        }
        this.historyPosMap.put(swf, this.historyPosMap.get(swf) - 1);
        this.historyMap.get(swf).get(this.historyPosMap.get(swf)).undoOperation();
        this.fireChange();
    }

    public void redo(SWF swf) {
        if (!this.canRedo(swf)) {
            return;
        }
        this.historyMap.get(swf).get(this.historyPosMap.get(swf)).doOperation();
        this.historyPosMap.put(swf, this.historyPosMap.get(swf) + 1);
        this.fireChange();
    }

    public String getRedoName(SWF swf) {
        if (!this.canRedo(swf)) {
            return null;
        }
        return this.historyMap.get(swf).get(this.historyPosMap.get(swf)).getDescription();
    }

    public boolean canRedo(SWF swf) {
        if (!this.historyMap.containsKey(swf)) {
            return false;
        }
        return this.historyMap.get(swf).size() > this.historyPosMap.get(swf);
    }

    public void clear() {
        this.historyMap.clear();
        this.historyPosMap.clear();
        this.fireChange();
    }

    public void clear(SWF swf) {
        if (!this.historyMap.containsKey(swf)) {
            return;
        }
        this.historyMap.get(swf).clear();
        this.historyPosMap.put(swf, 0);
        this.fireChange();
    }
}

