/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui.properties;

import com.jpexs.decompiler.flash.easygui.properties.DottedUnderlineLabel;
import com.jpexs.decompiler.flash.easygui.properties.PropertyValidationInterface;
import java.awt.AWTEvent;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractPropertyField<E>
extends JPanel {
    private static final String CARD_READ = "Read";
    private static final String CARD_WRITE = "Write";
    protected JLabel readLabel;
    protected JTextField writeField;
    private final List<PropertyValidationInterface<E>> validations = new ArrayList<PropertyValidationInterface<E>>();
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private AWTEventListener aeListener;
    private boolean undetermined = false;
    private boolean editing = false;

    public void addValidation(PropertyValidationInterface<E> validation) {
        this.validations.add(validation);
    }

    public void removeValidation(PropertyValidationInterface<E> validation) {
        this.validations.remove(validation);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private void fireChange() {
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    public AbstractPropertyField(String text) {
        this.setLayout(new CardLayout());
        this.readLabel = new DottedUnderlineLabel(text);
        this.readLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.writeField = new JTextField(text);
        this.add((Component)this.readLabel, CARD_READ);
        this.add((Component)this.writeField, CARD_WRITE);
        this.readLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    ((CardLayout)AbstractPropertyField.this.getLayout()).show(AbstractPropertyField.this, AbstractPropertyField.CARD_WRITE);
                    AbstractPropertyField.this.writeField.requestFocus();
                    AbstractPropertyField.this.writeField.selectAll();
                    Toolkit.getDefaultToolkit().addAWTEventListener(AbstractPropertyField.this.aeListener, 16L);
                    AbstractPropertyField.this.editing = true;
                }
            }
        });
        this.writeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractPropertyField.this.finishEdit();
            }
        });
        this.writeField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    AbstractPropertyField.this.finishEdit();
                }
                if (e.getKeyCode() == 27) {
                    e.consume();
                    AbstractPropertyField.this.cancelEdit();
                }
            }
        });
        this.aeListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                MouseEvent me;
                if (event instanceof MouseEvent && !SwingUtilities.isDescendingFrom((me = (MouseEvent)event).getComponent(), AbstractPropertyField.this.writeField) && me.getClickCount() > 0) {
                    AbstractPropertyField.this.finishEdit();
                }
            }
        };
    }

    protected abstract E textToValue(String var1);

    protected abstract String valueToText(E var1);

    private synchronized void finishEdit() {
        String textAfter;
        if (!this.editing) {
            return;
        }
        String textBefore = this.readLabel.getText();
        if (textBefore.equals(textAfter = this.writeField.getText())) {
            this.cancelEdit();
            return;
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.aeListener);
        boolean ok = true;
        E value = this.textToValue(textAfter);
        if (value == null) {
            ok = false;
        } else {
            for (PropertyValidationInterface<E> validation : this.validations) {
                if (validation.validate(value)) continue;
                ok = false;
                break;
            }
        }
        if (!ok) {
            this.cancelEdit();
            return;
        }
        this.undetermined = false;
        this.readLabel.setText(this.valueToText(value));
        ((CardLayout)this.getLayout()).show(this, CARD_READ);
        this.editing = false;
        this.fireChange();
    }

    private void cancelEdit() {
        if (!this.editing) {
            return;
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.aeListener);
        if (this.undetermined) {
            this.writeField.setText("");
        } else {
            this.writeField.setText(this.readLabel.getText());
        }
        ((CardLayout)this.getLayout()).show(this, CARD_READ);
        this.editing = false;
    }

    public E getValue() {
        if (this.undetermined) {
            return null;
        }
        return this.textToValue(this.writeField.getText());
    }

    public void setValue(Set<E> value) {
        this.setValue((E)value, false);
    }

    public void setValue(Set<E> value, boolean silent) {
        if (value.size() != 1) {
            this.setValue((E)null, silent);
        } else {
            this.setValue(value.iterator().next(), silent);
        }
    }

    public void setValue(E value) {
        this.setValue(value, false);
    }

    public void setValue(E value, boolean silent) {
        if (value == null) {
            this.readLabel.setText("-");
            this.writeField.setText("");
            this.undetermined = true;
            if (!silent) {
                this.fireChange();
            }
            return;
        }
        String text = this.valueToText(value);
        this.readLabel.setText(text);
        this.writeField.setText(text);
        if (!silent) {
            this.fireChange();
        }
    }
}

