/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui.properties.panels;

import com.jpexs.decompiler.flash.easygui.ConvolutionPreset;
import com.jpexs.decompiler.flash.easygui.EasyStrings;
import com.jpexs.decompiler.flash.easygui.EasySwfPanel;
import com.jpexs.decompiler.flash.easygui.EasyTagNameResolver;
import com.jpexs.decompiler.flash.easygui.FiltersTreeTable;
import com.jpexs.decompiler.flash.easygui.UndoManager;
import com.jpexs.decompiler.flash.easygui.properties.FloatPropertyField;
import com.jpexs.decompiler.flash.easygui.properties.IntegerPropertyField;
import com.jpexs.decompiler.flash.easygui.properties.JTriStateCheckBox;
import com.jpexs.decompiler.flash.easygui.properties.PropertyChangeDoableOperation;
import com.jpexs.decompiler.flash.easygui.properties.PropertyValidationInterface;
import com.jpexs.decompiler.flash.easygui.properties.panels.AbstractPropertiesPanel;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.gui.BoundsChangeListener;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.PopupButton;
import com.jpexs.decompiler.flash.gui.RegistrationPointPosition;
import com.jpexs.decompiler.flash.gui.TextPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.converters.PlaceObjectTypeConverter;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.filters.BEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.BLURFILTER;
import com.jpexs.decompiler.flash.types.filters.COLORMATRIXFILTER;
import com.jpexs.decompiler.flash.types.filters.CONVOLUTIONFILTER;
import com.jpexs.decompiler.flash.types.filters.DROPSHADOWFILTER;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.GLOWFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTBEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTGLOWFILTER;
import com.jpexs.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class InstancePropertiesPanel
extends AbstractPropertiesPanel {
    private final FloatPropertyField xPropertyField = new FloatPropertyField(0.0f, -8192.0f, 8192.0f);
    private final FloatPropertyField yPropertyField = new FloatPropertyField(0.0f, -8192.0f, 8192.0f);
    private final FloatPropertyField wPropertyField = new FloatPropertyField(0.0f, -8192.0f, 8192.0f);
    private final FloatPropertyField hPropertyField = new FloatPropertyField(0.0f, -8192.0f, 8192.0f);
    private final IntegerPropertyField alphaPercentPropertyField = new IntegerPropertyField(100, -100, 100);
    private final IntegerPropertyField redPercentPropertyField = new IntegerPropertyField(100, -100, 100);
    private final IntegerPropertyField greenPercentPropertyField = new IntegerPropertyField(100, -100, 100);
    private final IntegerPropertyField bluePercentPropertyField = new IntegerPropertyField(100, -100, 100);
    private final IntegerPropertyField alphaAddPropertyField = new IntegerPropertyField(0, -255, 255);
    private final IntegerPropertyField redAddPropertyField = new IntegerPropertyField(0, -255, 255);
    private final IntegerPropertyField greenAddPropertyField = new IntegerPropertyField(0, -255, 255);
    private final IntegerPropertyField blueAddPropertyField = new IntegerPropertyField(0, -255, 255);
    private final EasySwfPanel swfPanel;
    private final IntegerPropertyField ratioPropertyField = new IntegerPropertyField(-1, -1, 65535);
    private final JPanel propertiesPanel;
    private Rectangle2D lastBounds = null;
    private JLabel instanceLabel;
    private final JTriStateCheckBox visibleCheckBox = new JTriStateCheckBox();
    private final JComboBox<String> blendingComboBox = new JComboBox();
    private final JTriStateCheckBox cacheAsBitmapCheckBox = new JTriStateCheckBox();
    private final JComboBox<String> backgroundComboBox = new JComboBox();
    private final JPanel backgroundColorPanel = new JPanel();
    private final JLabel backgroundColorLabel = new JLabel();
    private final TextPanel textPanel;
    private final FiltersTreeTable filtersTable;
    private boolean updating = false;
    private List<FILTER> filterClipboard = new ArrayList<FILTER>();

    public InstancePropertiesPanel(final EasySwfPanel swfPanel, final UndoManager undoManager, boolean withText) {
        super("instance");
        this.setLayout(new BorderLayout());
        this.instanceLabel = new JLabel(EasyStrings.translate("properties.instance.none"));
        this.instanceLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.add((Component)this.instanceLabel, "North");
        JPanel positionSizePanel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        positionSizePanel.setLayout(gridBag);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        positionSizePanel.add((Component)new JLabel(this.formatPropertyName("positionSize.x")), gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        positionSizePanel.add((Component)this.xPropertyField, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        positionSizePanel.add((Component)new JLabel(this.formatPropertyName("positionSize.y")), gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        positionSizePanel.add((Component)this.yPropertyField, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.anchor = 13;
        positionSizePanel.add((Component)new JLabel(this.formatPropertyName("positionSize.width")), gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        positionSizePanel.add((Component)this.wPropertyField, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        positionSizePanel.add((Component)new JLabel(this.formatPropertyName("positionSize.height")), gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        positionSizePanel.add((Component)this.hPropertyField, gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        positionSizePanel.add((Component)new JPanel(), gbc);
        JPanel colorEffectPanel = new JPanel();
        gridBag = new GridBagLayout();
        colorEffectPanel.setLayout(gridBag);
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        colorEffectPanel.add((Component)new JLabel(this.formatPropertyName("colorEffect.alpha")), gbc);
        gbc.anchor = 17;
        ++gbc.gridx;
        colorEffectPanel.add((Component)this.alphaPercentPropertyField, gbc);
        ++gbc.gridx;
        colorEffectPanel.add((Component)new JLabel("%   \u00d7 A + "), gbc);
        ++gbc.gridx;
        colorEffectPanel.add((Component)this.alphaAddPropertyField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 13;
        colorEffectPanel.add((Component)new JLabel(this.formatPropertyName("colorEffect.red")), gbc);
        gbc.anchor = 17;
        ++gbc.gridx;
        colorEffectPanel.add((Component)this.redPercentPropertyField, gbc);
        ++gbc.gridx;
        colorEffectPanel.add((Component)new JLabel("%   \u00d7 R + "), gbc);
        ++gbc.gridx;
        colorEffectPanel.add((Component)this.redAddPropertyField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 13;
        colorEffectPanel.add((Component)new JLabel(this.formatPropertyName("colorEffect.green")), gbc);
        gbc.anchor = 17;
        ++gbc.gridx;
        colorEffectPanel.add((Component)this.greenPercentPropertyField, gbc);
        ++gbc.gridx;
        colorEffectPanel.add((Component)new JLabel("%   \u00d7 G + "), gbc);
        ++gbc.gridx;
        colorEffectPanel.add((Component)this.greenAddPropertyField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 13;
        colorEffectPanel.add((Component)new JLabel(this.formatPropertyName("colorEffect.blue")), gbc);
        gbc.anchor = 17;
        ++gbc.gridx;
        colorEffectPanel.add((Component)this.bluePercentPropertyField, gbc);
        ++gbc.gridx;
        colorEffectPanel.add((Component)new JLabel("%   \u00d7 B + "), gbc);
        ++gbc.gridx;
        colorEffectPanel.add((Component)this.blueAddPropertyField, gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.gridheight = 4;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        colorEffectPanel.add((Component)new JPanel(), gbc);
        JPanel displayPanel = new JPanel();
        gridBag = new GridBagLayout();
        displayPanel.setLayout(gridBag);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        displayPanel.add((Component)new JLabel(this.formatPropertyName("display.visible")), gbc);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        displayPanel.add((Component)this.visibleCheckBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        displayPanel.add((Component)new JLabel(this.formatPropertyName("display.ratio")), gbc);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        displayPanel.add((Component)this.ratioPropertyField, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        displayPanel.add((Component)new JLabel(this.formatPropertyName("display.blending")), gbc);
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.normal"));
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.layer"));
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.multiply"));
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.screen"));
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.lighten"));
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.darken"));
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.difference"));
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.add"));
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.subtract"));
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.invert"));
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.alpha"));
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.erase"));
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.overlay"));
        this.blendingComboBox.addItem(EasyStrings.translate("property.instance.display.blending.hardlight"));
        ++gbc.gridx;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        displayPanel.add(this.blendingComboBox, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        displayPanel.add((Component)new JLabel(this.formatPropertyName("display.cacheAsBitmap")), gbc);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        displayPanel.add((Component)this.cacheAsBitmapCheckBox, gbc);
        this.backgroundComboBox.addItem(EasyStrings.translate("property.instance.display.cacheAsBitmap.transparent"));
        this.backgroundComboBox.addItem(EasyStrings.translate("property.instance.display.cacheAsBitmap.opaque"));
        this.backgroundColorPanel.setLayout(new BorderLayout());
        this.backgroundColorPanel.add((Component)this.backgroundColorLabel, "Center");
        this.backgroundColorPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.backgroundColorPanel.setPreferredSize(new Dimension(16, 16));
        ++gbc.gridy;
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        displayPanel.add(this.backgroundComboBox, gbc);
        ++gbc.gridx;
        displayPanel.add((Component)this.backgroundColorPanel, gbc);
        this.cacheAsBitmapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InstancePropertiesPanel.this.updating) {
                    return;
                }
                InstancePropertiesPanel.this.backgroundComboBox.setVisible(InstancePropertiesPanel.this.cacheAsBitmapCheckBox.isSelected());
                InstancePropertiesPanel.this.backgroundColorPanel.setVisible(InstancePropertiesPanel.this.cacheAsBitmapCheckBox.isSelected() && InstancePropertiesPanel.this.backgroundComboBox.getSelectedIndex() == InstancePropertiesPanel.this.backgroundComboBox.getItemCount() - 1);
                InstancePropertiesPanel.this.revalidate();
            }
        });
        this.backgroundComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InstancePropertiesPanel.this.updating) {
                    return;
                }
                InstancePropertiesPanel.this.backgroundColorPanel.setVisible(InstancePropertiesPanel.this.backgroundComboBox.getSelectedIndex() == InstancePropertiesPanel.this.backgroundComboBox.getItemCount() - 1);
                InstancePropertiesPanel.this.revalidate();
            }
        });
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        displayPanel.add((Component)new JPanel(), gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridheight = 4;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        displayPanel.add((Component)new JPanel(), gbc);
        this.textPanel = new TextPanel(swfPanel.getMainPanel(), undoManager);
        JPanel filtersPanel = new JPanel(new BorderLayout());
        filtersPanel.setPreferredSize(new Dimension(400, 200));
        this.filtersTable = new FiltersTreeTable();
        JPanel filtersToolbar = new JPanel(new FlowLayout(0));
        PopupButton addFilterButton = new PopupButton((Icon)View.getIcon("add16")){

            @Override
            protected JPopupMenu getPopupMenu() {
                Class[] possibleFilters;
                JPopupMenu menu = new JPopupMenu();
                JMenuItem removeAllMenuItem = new JMenuItem(EasyStrings.translate("property.instance.filters.menu.add.removeAll"));
                removeAllMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InstancePropertiesPanel.this.filtersTable.clearFilters();
                    }
                });
                menu.add(removeAllMenuItem);
                menu.addSeparator();
                for (final Class filterClass : possibleFilters = new Class[]{DROPSHADOWFILTER.class, BLURFILTER.class, GLOWFILTER.class, BEVELFILTER.class, GRADIENTGLOWFILTER.class, GRADIENTBEVELFILTER.class, COLORMATRIXFILTER.class, CONVOLUTIONFILTER.class}) {
                    String filterName = filterClass.getSimpleName();
                    filterName = filterName.substring(0, filterName.length() - "FILTER".length());
                    filterName = EasyStrings.translate("filter." + filterName.toLowerCase());
                    if (filterClass == CONVOLUTIONFILTER.class) {
                        JMenu convolutionMenu = new JMenu(filterName);
                        for (final ConvolutionPreset preset : ConvolutionPreset.getAllPresets()) {
                            JMenuItem filterMenuItem = new JMenuItem(preset.toString());
                            filterMenuItem.addActionListener(new ActionListener(){
                                final /* synthetic */ 3 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    CONVOLUTIONFILTER filter = preset.createFilter();
                                    this.this$1.InstancePropertiesPanel.this.filtersTable.addFilter((FILTER)filter);
                                }
                            });
                            convolutionMenu.add(filterMenuItem);
                        }
                        menu.add(convolutionMenu);
                        continue;
                    }
                    JMenuItem filterMenuItem = new JMenuItem(filterName);
                    filterMenuItem.addActionListener(new ActionListener(){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            FILTER filter;
                            try {
                                filter = (FILTER)filterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                                return;
                            }
                            this.this$1.InstancePropertiesPanel.this.filtersTable.addFilter(filter);
                        }
                    });
                    menu.add(filterMenuItem);
                }
                return menu;
            }
        };
        addFilterButton.setToolTipText(EasyStrings.translate("property.instance.filters.menu.add"));
        final JButton removeFilterButton = new JButton(View.getIcon("removeobject16"));
        removeFilterButton.setEnabled(false);
        removeFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstancePropertiesPanel.this.filtersTable.removeSelectedFilter();
            }
        });
        removeFilterButton.setToolTipText(EasyStrings.translate("property.instance.filters.menu.remove"));
        PopupButton clipboardFilterButton = new PopupButton((Icon)View.getIcon("clipboard16")){

            @Override
            protected JPopupMenu getPopupMenu() {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem copySelectedMenuItem = new JMenuItem(EasyStrings.translate("property.instance.filters.menu.clipboard.copySelected"));
                copySelectedMenuItem.addActionListener(this::copySelectedActionPerformed);
                JMenuItem copyAllMenuItem = new JMenuItem(EasyStrings.translate("property.instance.filters.menu.clipboard.copyAll"));
                copyAllMenuItem.addActionListener(this::copyAllActionPerformed);
                JMenuItem pasteMenuItem = new JMenuItem(EasyStrings.translate("property.instance.filters.menu.clipboard.paste"));
                pasteMenuItem.addActionListener(this::pasteActionPerformed);
                if (!InstancePropertiesPanel.this.filtersTable.isFilterSelected()) {
                    copySelectedMenuItem.setEnabled(false);
                }
                menu.add(copySelectedMenuItem);
                menu.add(copyAllMenuItem);
                menu.add(pasteMenuItem);
                return menu;
            }

            private void copySelectedActionPerformed(ActionEvent evt) {
                FILTER filter = InstancePropertiesPanel.this.filtersTable.getSelectedFilter();
                if (filter == null) {
                    return;
                }
                InstancePropertiesPanel.this.filterClipboard.clear();
                InstancePropertiesPanel.this.filterClipboard.add((FILTER)Helper.deepCopy((Object)filter));
            }

            private void copyAllActionPerformed(ActionEvent evt) {
                InstancePropertiesPanel.this.filterClipboard.clear();
                for (FILTER filter : InstancePropertiesPanel.this.filtersTable.getFilters()) {
                    InstancePropertiesPanel.this.filterClipboard.add((FILTER)Helper.deepCopy((Object)filter));
                }
            }

            private void pasteActionPerformed(ActionEvent evt) {
                for (FILTER filter : InstancePropertiesPanel.this.filterClipboard) {
                    InstancePropertiesPanel.this.filtersTable.addFilter((FILTER)Helper.deepCopy((Object)filter));
                }
            }
        };
        clipboardFilterButton.setToolTipText(EasyStrings.translate("property.instance.filters.menu.clipboard"));
        final JButton enableFilterButton = new JButton(View.getIcon("show16"));
        enableFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FILTER filter = InstancePropertiesPanel.this.filtersTable.getSelectedFilter();
                filter.enabled = !filter.enabled;
                InstancePropertiesPanel.this.filtersTable.fireFilterChanged();
                InstancePropertiesPanel.this.filtersTable.repaint();
            }
        });
        enableFilterButton.setToolTipText(EasyStrings.translate("property.instance.filters.menu.enable"));
        enableFilterButton.setEnabled(false);
        this.filtersTable.getTree().addTreeSelectionListener(new TreeSelectionListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                boolean filterSelected = this.this$0.filtersTable.isFilterSelected();
                removeFilterButton.setEnabled(filterSelected);
                enableFilterButton.setEnabled(filterSelected);
            }
        });
        filtersToolbar.add(addFilterButton);
        filtersToolbar.add(removeFilterButton);
        filtersToolbar.add(clipboardFilterButton);
        filtersToolbar.add(enableFilterButton);
        JScrollPane sp = new JScrollPane(this.filtersTable);
        filtersPanel.add((Component)sp, "Center");
        filtersPanel.add((Component)filtersToolbar, "South");
        sp.getViewport().setBackground(this.filtersTable.getBackground());
        this.filtersTable.addFilterChangedListener(new ActionListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                final List<FILTER> newFilters = this.this$0.filtersTable.getFilters();
                if (newFilters != null) {
                    undoManager.doOperation(new PlaceChangeDoableOperation(this, "instance.filters", 3){
                        List<FILTER> applyFilters;
                        final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = this$1;
                            super(propertyIdentifier, minPlace);
                            this.applyFilters = (List)Helper.deepCopy((Object)newFilters);
                        }

                        @Override
                        public void doPlaceOperation(PlaceObjectTypeTag placeObject, DepthState depthState) {
                            placeObject.setFilters(this.applyFilters);
                            depthState.filters = this.applyFilters;
                        }
                    }, swfPanel.getSwf());
                }
            }
        });
        this.propertiesPanel = new JPanel();
        this.propertiesPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.propertiesPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        this.addCard(this.propertiesPanel, "positionSize", null, positionSizePanel, gbc, false);
        this.addCard(this.propertiesPanel, "colorEffect", null, colorEffectPanel, gbc, false);
        this.addCard(this.propertiesPanel, "display", null, displayPanel, gbc, false);
        this.addCard(this.propertiesPanel, "filters", null, filtersPanel, gbc, !withText);
        if (withText) {
            this.addCard(this.propertiesPanel, "text", null, this.textPanel, gbc, true);
        }
        this.setCardOpened("positionSize", true);
        this.swfPanel = swfPanel;
        this.alphaPercentPropertyField.addChangeListener(new ChangeListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                undoManager.doOperation(new ColorEffectChangeDoableOperation("alpha"){
                    int value;
                    {
                        this.value = (Integer)this$0.alphaPercentPropertyField.getValue();
                    }

                    @Override
                    public void doColorEffectOperation(CXFORMWITHALPHA colorTransform) {
                        colorTransform.alphaMultTerm = Math.round((float)(this.value * 256) / 100.0f);
                        colorTransform.hasMultTerms = true;
                    }
                }, swfPanel.getSwf());
            }
        });
        this.alphaAddPropertyField.addChangeListener(new ChangeListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                undoManager.doOperation(new ColorEffectChangeDoableOperation("alpha"){
                    int value;
                    {
                        this.value = (Integer)this$0.alphaAddPropertyField.getValue();
                    }

                    @Override
                    public void doColorEffectOperation(CXFORMWITHALPHA colorTransform) {
                        colorTransform.alphaAddTerm = this.value;
                        colorTransform.hasAddTerms = true;
                    }
                }, swfPanel.getSwf());
            }
        });
        this.redPercentPropertyField.addChangeListener(new ChangeListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                undoManager.doOperation(new ColorEffectChangeDoableOperation("red"){
                    int value;
                    {
                        this.value = (Integer)this$0.redPercentPropertyField.getValue();
                    }

                    @Override
                    public void doColorEffectOperation(CXFORMWITHALPHA colorTransform) {
                        colorTransform.redMultTerm = Math.round((float)(this.value * 256) / 100.0f);
                        colorTransform.hasMultTerms = true;
                    }
                }, swfPanel.getSwf());
            }
        });
        this.redAddPropertyField.addChangeListener(new ChangeListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                undoManager.doOperation(new ColorEffectChangeDoableOperation("red"){
                    int value;
                    {
                        this.value = (Integer)this$0.redAddPropertyField.getValue();
                    }

                    @Override
                    public void doColorEffectOperation(CXFORMWITHALPHA colorTransform) {
                        colorTransform.redAddTerm = this.value;
                        colorTransform.hasAddTerms = true;
                    }
                }, swfPanel.getSwf());
            }
        });
        this.greenPercentPropertyField.addChangeListener(new ChangeListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                undoManager.doOperation(new ColorEffectChangeDoableOperation("green"){
                    int value;
                    {
                        this.value = (Integer)this$0.greenPercentPropertyField.getValue();
                    }

                    @Override
                    public void doColorEffectOperation(CXFORMWITHALPHA colorTransform) {
                        colorTransform.greenMultTerm = Math.round((float)(this.value * 256) / 100.0f);
                        colorTransform.hasMultTerms = true;
                    }
                }, swfPanel.getSwf());
            }
        });
        this.greenAddPropertyField.addChangeListener(new ChangeListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                undoManager.doOperation(new ColorEffectChangeDoableOperation("green"){
                    int value;
                    {
                        this.value = (Integer)this$0.greenAddPropertyField.getValue();
                    }

                    @Override
                    public void doColorEffectOperation(CXFORMWITHALPHA colorTransform) {
                        colorTransform.greenAddTerm = this.value;
                        colorTransform.hasAddTerms = true;
                    }
                }, swfPanel.getSwf());
            }
        });
        this.bluePercentPropertyField.addChangeListener(new ChangeListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                undoManager.doOperation(new ColorEffectChangeDoableOperation("blue"){
                    int value;
                    {
                        this.value = (Integer)this$0.bluePercentPropertyField.getValue();
                    }

                    @Override
                    public void doColorEffectOperation(CXFORMWITHALPHA colorTransform) {
                        colorTransform.blueMultTerm = Math.round((float)(this.value * 256) / 100.0f);
                        colorTransform.hasMultTerms = true;
                    }
                }, swfPanel.getSwf());
            }
        });
        this.blueAddPropertyField.addChangeListener(new ChangeListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                undoManager.doOperation(new ColorEffectChangeDoableOperation("blue"){
                    int value;
                    {
                        this.value = (Integer)this$0.blueAddPropertyField.getValue();
                    }

                    @Override
                    public void doColorEffectOperation(CXFORMWITHALPHA colorTransform) {
                        colorTransform.blueAddTerm = this.value;
                        colorTransform.hasAddTerms = true;
                    }
                }, swfPanel.getSwf());
            }
        });
        this.xPropertyField.addChangeListener(new ChangeListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                double xBefore = this.this$0.lastBounds.getX();
                double xAfter = ((Float)this.this$0.xPropertyField.getValue()).floatValue() * 20.0f;
                double xDelta = Math.round(xAfter - xBefore);
                swfPanel.getStagePanel().applyTransformMatrix(Matrix.getTranslateInstance((double)xDelta, (double)0.0));
            }
        });
        this.yPropertyField.addChangeListener(new ChangeListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                double yBefore = this.this$0.lastBounds.getY();
                double yAfter = ((Float)this.this$0.yPropertyField.getValue()).floatValue() * 20.0f;
                double yDelta = Math.round(yAfter - yBefore);
                swfPanel.getStagePanel().applyTransformMatrix(Matrix.getTranslateInstance((double)0.0, (double)yDelta));
            }
        });
        PropertyValidationInterface<Float> nonZeroFloatValidation = new PropertyValidationInterface<Float>(){

            @Override
            public boolean validate(Float value) {
                return value.floatValue() != 0.0f;
            }
        };
        this.wPropertyField.addChangeListener(new ChangeListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                double wBefore = this.this$0.lastBounds.getWidth();
                if (wBefore == 0.0) {
                    return;
                }
                double wAfter = ((Float)this.this$0.wPropertyField.getValue()).floatValue() * 20.0f;
                double wScale = wAfter / wBefore;
                Matrix m = new Matrix();
                m.translate((double)Math.round(this.this$0.lastBounds.getX()), (double)Math.round(this.this$0.lastBounds.getY()));
                m.scale(wScale, 1.0);
                m.translate((double)(-Math.round(this.this$0.lastBounds.getX())), (double)(-Math.round(this.this$0.lastBounds.getY())));
                swfPanel.getStagePanel().applyTransformMatrix(m);
            }
        });
        this.wPropertyField.addValidation(nonZeroFloatValidation);
        this.hPropertyField.addChangeListener(new ChangeListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                double hBefore = this.this$0.lastBounds.getHeight();
                if (hBefore == 0.0) {
                    return;
                }
                double hAfter = ((Float)this.this$0.hPropertyField.getValue()).floatValue() * 20.0f;
                double hScale = hAfter / hBefore;
                Matrix m = new Matrix();
                m.translate((double)Math.round(this.this$0.lastBounds.getX()), (double)Math.round(this.this$0.lastBounds.getY()));
                m.scale(1.0, hScale);
                m.translate((double)(-Math.round(this.this$0.lastBounds.getX())), (double)(-Math.round(this.this$0.lastBounds.getY())));
                swfPanel.getStagePanel().applyTransformMatrix(m);
            }
        });
        this.hPropertyField.addValidation(nonZeroFloatValidation);
        this.ratioPropertyField.addChangeListener(new ChangeListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                undoManager.doOperation(new PlaceChangeDoableOperation("instance.display.ratio", 2){
                    Integer ratio;
                    {
                        this.ratio = (Integer)this$0.ratioPropertyField.getValue();
                    }

                    @Override
                    public void doPlaceOperation(PlaceObjectTypeTag placeObject, DepthState depthState) {
                        if (this.ratio == null) {
                            placeObject.setPlaceFlagHasRatio(false);
                        } else {
                            placeObject.setRatio(this.ratio.intValue());
                        }
                    }
                }, swfPanel.getSwf());
            }
        });
        this.visibleCheckBox.addActionListener(new ActionListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.this$0.updating) {
                    return;
                }
                undoManager.doOperation(new PlaceChangeDoableOperation("instance.display.visible", 3){
                    int visible;
                    {
                        this.visible = this$0.visibleCheckBox.isSelected() ? 1 : 0;
                    }

                    @Override
                    public void doPlaceOperation(PlaceObjectTypeTag placeObject, DepthState depthState) {
                        placeObject.setVisible(this.visible);
                    }
                }, swfPanel.getSwf());
            }
        });
        this.blendingComboBox.addActionListener(new ActionListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.this$0.updating) {
                    return;
                }
                undoManager.doOperation(new PlaceChangeDoableOperation("instance.display.blending", 3){
                    int blendMode;
                    {
                        this.blendMode = this$0.blendingComboBox.getSelectedIndex() + 1;
                    }

                    @Override
                    public void doPlaceOperation(PlaceObjectTypeTag placeObject, DepthState depthState) {
                        placeObject.setBlendMode(this.blendMode);
                    }
                }, swfPanel.getSwf());
            }
        });
        this.cacheAsBitmapCheckBox.addActionListener(new ActionListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.this$0.updating) {
                    return;
                }
                undoManager.doOperation(new PlaceChangeDoableOperation("instance.display.cacheAsBitmap", 3){
                    int bitmapCache;
                    {
                        this.bitmapCache = this$0.cacheAsBitmapCheckBox.isSelected() ? 1 : 0;
                    }

                    @Override
                    public void doPlaceOperation(PlaceObjectTypeTag placeObject, DepthState depthState) {
                        placeObject.setBitmapCache(this.bitmapCache);
                        placeObject.setPlaceFlagHasCacheAsBitmap(this.bitmapCache == 1);
                        if (this.bitmapCache == 0) {
                            placeObject.setBackgroundColor(null);
                            placeObject.setPlaceFlagOpaqueBackground(false);
                        }
                    }
                }, swfPanel.getSwf());
            }
        });
        this.backgroundComboBox.addActionListener(new ActionListener(){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.this$0.updating) {
                    return;
                }
                final boolean isOpaque = this.this$0.backgroundComboBox.getSelectedIndex() == this.this$0.backgroundComboBox.getItemCount() - 1;
                undoManager.doOperation(new PlaceChangeDoableOperation(this, "instance.display.cacheAsBitmap", 3){
                    RGBA color;
                    final /* synthetic */ 26 this$1;
                    {
                        this.this$1 = this$1;
                        super(propertyIdentifier, minPlace);
                        this.color = isOpaque ? new RGBA(this.this$1.this$0.backgroundColorPanel.getBackground()) : null;
                    }

                    @Override
                    public void doPlaceOperation(PlaceObjectTypeTag placeObject, DepthState depthState) {
                        if (this.color != null) {
                            this.this$1.this$0.backgroundColorLabel.setText("");
                            placeObject.setBackgroundColor(this.color);
                        } else {
                            placeObject.setPlaceFlagOpaqueBackground(false);
                        }
                    }
                }, swfPanel.getSwf());
            }
        });
        this.backgroundColorPanel.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InstancePropertiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Color newColor;
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1 && (newColor = ViewMessages.showColorDialog(this.this$0, this.this$0.backgroundColorPanel.getBackground(), false)) != null) {
                    this.this$0.backgroundColorPanel.setBackground(newColor);
                    this.this$0.backgroundColorLabel.setText("");
                    undoManager.doOperation(new PlaceChangeDoableOperation(this, "instance.display.cacheAsBitmap", 3){
                        RGBA color;
                        final /* synthetic */ 27 this$1;
                        {
                            this.this$1 = this$1;
                            super(propertyIdentifier, minPlace);
                            this.color = new RGBA(newColor);
                        }

                        @Override
                        public void doPlaceOperation(PlaceObjectTypeTag placeObject, DepthState depthState) {
                            placeObject.setBackgroundColor(this.color);
                        }
                    }, swfPanel.getSwf());
                }
            }
        });
        FasterScrollPane sp1 = new FasterScrollPane(this.propertiesPanel);
        sp1.setHorizontalScrollBarPolicy(31);
        this.add((Component)sp1, "Center");
        swfPanel.getStagePanel().addBoundsChangeListener(new BoundsChangeListener(){

            @Override
            public void boundsChanged(Rectangle2D newBounds, Point2D registrationPoint, RegistrationPointPosition registrationPointPosition) {
                InstancePropertiesPanel.this.lastBounds = newBounds;
                InstancePropertiesPanel.this.xPropertyField.setValue(Float.valueOf(InstancePropertiesPanel.twipToPixelValue(newBounds.getX())), true);
                InstancePropertiesPanel.this.yPropertyField.setValue(Float.valueOf(InstancePropertiesPanel.twipToPixelValue(newBounds.getY())), true);
                InstancePropertiesPanel.this.wPropertyField.setValue(Float.valueOf(InstancePropertiesPanel.twipToPixelValue(newBounds.getWidth())), true);
                InstancePropertiesPanel.this.hPropertyField.setValue(Float.valueOf(InstancePropertiesPanel.twipToPixelValue(newBounds.getHeight())), true);
            }
        });
    }

    private static float twipToPixelValue(double val) {
        float ret = (float)val;
        ret = Math.round(ret);
        return ret /= 20.0f;
    }

    public void update() {
        this.updating = true;
        List<DepthState> dss = this.swfPanel.getSelectedDepthStates();
        if (dss == null || dss.isEmpty()) {
            this.instanceLabel.setText(EasyStrings.translate("properties.instance.none"));
            this.propertiesPanel.setVisible(false);
            return;
        }
        this.propertiesPanel.setVisible(true);
        if (dss.size() == 1) {
            EasyTagNameResolver resolver = new EasyTagNameResolver();
            DepthState ds = dss.get(0);
            if (ds == null) {
                this.instanceLabel.setText("");
            } else {
                this.instanceLabel.setText(EasyStrings.translate("properties.instance.single").replace("%item%", resolver.getTagName((Tag)ds.getCharacter())));
            }
        } else {
            this.instanceLabel.setText(EasyStrings.translate("properties.instance.multiple").replace("%count%", "" + dss.size()));
        }
        HashSet<Integer> alphaPercent = new HashSet<Integer>();
        HashSet<Integer> alphaAdd = new HashSet<Integer>();
        HashSet<Integer> redPercent = new HashSet<Integer>();
        HashSet<Integer> redAdd = new HashSet<Integer>();
        HashSet<Integer> greenPercent = new HashSet<Integer>();
        HashSet<Integer> greenAdd = new HashSet<Integer>();
        HashSet<Integer> bluePercent = new HashSet<Integer>();
        HashSet<Integer> blueAdd = new HashSet<Integer>();
        HashSet<Boolean> visible = new HashSet<Boolean>();
        HashSet<Integer> blendMode = new HashSet<Integer>();
        HashSet<Boolean> cacheAsBitmap = new HashSet<Boolean>();
        HashSet<RGBA> backgroundColor = new HashSet<RGBA>();
        HashSet<List> filters = new HashSet<List>();
        HashSet<Integer> ratio = new HashSet<Integer>();
        TextTag text = null;
        for (DepthState ds : dss) {
            if (ds == null) continue;
            ColorTransform colorTransform = ds.colorTransForm;
            if (colorTransform == null) {
                alphaPercent.add(100);
                alphaAdd.add(0);
                redPercent.add(100);
                redAdd.add(0);
                greenPercent.add(100);
                greenAdd.add(0);
                bluePercent.add(100);
                blueAdd.add(0);
            } else {
                alphaPercent.add(colorTransform.getAlphaMulti() * 100 / 256);
                alphaAdd.add(colorTransform.getAlphaAdd());
                redPercent.add(colorTransform.getRedMulti() * 100 / 256);
                redAdd.add(colorTransform.getRedAdd());
                greenPercent.add(colorTransform.getGreenMulti() * 100 / 256);
                greenAdd.add(colorTransform.getGreenAdd());
                bluePercent.add(colorTransform.getBlueMulti() * 100 / 256);
                blueAdd.add(colorTransform.getBlueAdd());
            }
            visible.add(ds.isVisible);
            int bm = ds.blendMode;
            if (bm == 0) {
                bm = 1;
            }
            blendMode.add(bm);
            cacheAsBitmap.add(ds.cacheAsBitmap);
            backgroundColor.add(ds.backGroundColor);
            filters.add(ds.filters);
            ratio.add(ds.ratio == -1 ? 0 : ds.ratio);
            CharacterTag ch = ds.getCharacter();
            if (!(ch instanceof TextTag)) continue;
            text = (TextTag)ch;
        }
        if (dss.size() > 1) {
            text = null;
        }
        if (visible.size() == 0) {
            return;
        }
        this.alphaPercentPropertyField.setValue(alphaPercent, true);
        this.alphaAddPropertyField.setValue(alphaAdd, true);
        this.redPercentPropertyField.setValue(redPercent, true);
        this.redAddPropertyField.setValue(redAdd, true);
        this.greenPercentPropertyField.setValue(greenPercent, true);
        this.greenAddPropertyField.setValue(greenAdd, true);
        this.bluePercentPropertyField.setValue(bluePercent, true);
        this.blueAddPropertyField.setValue(blueAdd, true);
        this.ratioPropertyField.setValue(ratio, true);
        if (visible.size() > 1) {
            this.visibleCheckBox.setSelectionState(1);
        } else {
            this.visibleCheckBox.setSelected((Boolean)visible.iterator().next());
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.blendingComboBox.getModel();
        if (blendMode.size() > 1) {
            if (!((String)model.getElementAt(0)).equals("")) {
                model.insertElementAt("", 0);
            }
            this.blendingComboBox.setSelectedIndex(0);
        } else {
            if (((String)model.getElementAt(0)).equals("")) {
                model.removeElementAt(0);
            }
            int bm = (Integer)blendMode.iterator().next();
            this.blendingComboBox.setSelectedIndex(--bm);
        }
        if (cacheAsBitmap.size() > 1) {
            this.cacheAsBitmapCheckBox.setSelectionState(1);
        } else {
            this.cacheAsBitmapCheckBox.setSelected((Boolean)cacheAsBitmap.iterator().next());
        }
        this.backgroundComboBox.setVisible(this.cacheAsBitmapCheckBox.getSelectionState() == 2);
        DefaultComboBoxModel backgroundModel = (DefaultComboBoxModel)this.backgroundComboBox.getModel();
        if (backgroundColor.size() > 1) {
            if (backgroundColor.contains(null)) {
                if (backgroundModel.getSize() == 2) {
                    backgroundModel.insertElementAt("", 0);
                }
                this.backgroundComboBox.setSelectedIndex(0);
                this.backgroundColorPanel.setVisible(false);
            } else {
                if (backgroundModel.getSize() == 3) {
                    backgroundModel.removeElementAt(0);
                }
                this.backgroundComboBox.setSelectedIndex(1);
                this.backgroundColorPanel.setVisible(true);
                this.backgroundColorLabel.setText("--");
                this.backgroundColorPanel.setBackground(Color.WHITE);
                this.backgroundColorPanel.setOpaque(true);
            }
        } else {
            RGBA bgColor;
            if (backgroundModel.getSize() == 3) {
                backgroundModel.removeElementAt(0);
            }
            this.backgroundComboBox.setSelectedIndex((bgColor = (RGBA)backgroundColor.iterator().next()) == null ? 0 : 1);
            this.backgroundColorLabel.setText("");
            if (bgColor == null) {
                this.backgroundColorPanel.setVisible(false);
            } else {
                this.backgroundColorPanel.setVisible(true);
                this.backgroundColorPanel.setBackground(bgColor.toColor());
                this.backgroundColorPanel.setOpaque(true);
            }
        }
        if (filters.size() == 1) {
            List oneFilters = (List)filters.iterator().next();
            if (oneFilters == null) {
                this.filtersTable.setFilters(new ArrayList<FILTER>());
            } else {
                this.filtersTable.setFilters((List)Helper.deepCopy((Object)oneFilters));
            }
        } else if (filters.isEmpty()) {
            this.filtersTable.setFilters(new ArrayList<FILTER>());
        } else {
            this.filtersTable.setFilters(null);
        }
        this.textPanel.setText(text);
        this.updating = false;
        this.revalidate();
    }

    abstract class ColorEffectChangeDoableOperation
    extends PlaceChangeDoableOperation {
        CXFORMWITHALPHA colorTransformAfter;

        public ColorEffectChangeDoableOperation(String colorProperty) {
            super("instance.colorEffect." + colorProperty, 2);
        }

        @Override
        public final void doPlaceOperation(PlaceObjectTypeTag placeObject, DepthState depthState) {
            this.colorTransformAfter = depthState.colorTransForm == null ? new CXFORMWITHALPHA() : new CXFORMWITHALPHA(depthState.colorTransForm);
            this.doColorEffectOperation(this.colorTransformAfter);
            placeObject.setColorTransform((ColorTransform)this.colorTransformAfter);
        }

        public abstract void doColorEffectOperation(CXFORMWITHALPHA var1);
    }

    abstract class PlaceChangeDoableOperation
    extends PropertyChangeDoableOperation {
        List<Integer> fdepths;
        int fframe;
        List<DepthState> depthStatesBefore;
        List<PlaceObjectTypeTag> placeObjectsBefore;
        List<PlaceObjectTypeTag> placeObjectsAfter;
        private final boolean timelinedModifiedBefore;
        private final Timelined timelined;

        public PlaceChangeDoableOperation(String propertyIdentifier, int minPlace) {
            super(propertyIdentifier);
            this.fdepths = InstancePropertiesPanel.this.swfPanel.getDepths();
            this.fframe = InstancePropertiesPanel.this.swfPanel.getFrame();
            this.depthStatesBefore = InstancePropertiesPanel.this.swfPanel.getSelectedDepthStates();
            this.placeObjectsBefore = InstancePropertiesPanel.this.swfPanel.getSelectedPlaceTags();
            this.placeObjectsAfter = new ArrayList<PlaceObjectTypeTag>();
            this.timelinedModifiedBefore = InstancePropertiesPanel.this.swfPanel.getTimelined().isModified();
            this.timelined = InstancePropertiesPanel.this.swfPanel.getTimelined();
            for (int i = 0; i < this.fdepths.size(); ++i) {
                PlaceObjectTypeTag placeObjectBefore = this.placeObjectsBefore.get(i);
                int convNum = placeObjectBefore.getPlaceObjectNum() < minPlace ? minPlace : placeObjectBefore.getPlaceObjectNum();
                PlaceObjectTypeConverter conv = new PlaceObjectTypeConverter();
                PlaceObjectTypeTag placeObjectAfter = conv.convertTagType(placeObjectBefore, this.timelined.getSwf(), convNum, false);
                placeObjectAfter.setTimelined(this.timelined);
                this.placeObjectsAfter.add(placeObjectAfter);
            }
        }

        @Override
        public final void doOperation() {
            InstancePropertiesPanel.this.swfPanel.getStagePanel().gotoFrame(this.fframe + 1);
            InstancePropertiesPanel.this.swfPanel.getStagePanel().selectDepths(this.fdepths);
            for (int i = 0; i < this.fdepths.size(); ++i) {
                PlaceObjectTypeTag placeObjectBefore = this.placeObjectsBefore.get(i);
                PlaceObjectTypeTag placeObjectAfter = this.placeObjectsAfter.get(i);
                if (!(this.timelined instanceof ButtonTag)) {
                    int index = this.timelined.indexOfTag((Tag)placeObjectBefore);
                    this.timelined.removeTag(index);
                    this.timelined.addTag(index, (Tag)placeObjectAfter);
                    this.timelined.setModified(true);
                }
                DepthState depthStateBefore = this.depthStatesBefore.get(i);
                this.doPlaceOperation(placeObjectAfter, depthStateBefore);
                if (!(this.timelined instanceof ButtonTag)) continue;
                ButtonTag button = (ButtonTag)this.timelined;
                button.setRecordFromPlaceObject(this.fframe, placeObjectAfter);
            }
            this.timelined.resetTimeline();
            InstancePropertiesPanel.this.update();
        }

        @Override
        public final void undoOperation() {
            InstancePropertiesPanel.this.swfPanel.getStagePanel().gotoFrame(this.fframe + 1);
            InstancePropertiesPanel.this.swfPanel.getStagePanel().selectDepths(this.fdepths);
            for (int i = 0; i < this.placeObjectsAfter.size(); ++i) {
                PlaceObjectTypeTag placeObjectAfter = this.placeObjectsAfter.get(i);
                PlaceObjectTypeTag placeObjectBefore = this.placeObjectsBefore.get(i);
                if (this.timelined instanceof ButtonTag) {
                    ButtonTag button = (ButtonTag)this.timelined;
                    button.setRecordFromPlaceObject(this.fframe, placeObjectBefore);
                    continue;
                }
                int index = this.timelined.indexOfTag((Tag)placeObjectAfter);
                this.timelined.removeTag(index);
                this.timelined.addTag(index, (Tag)placeObjectBefore);
            }
            if (!this.timelinedModifiedBefore) {
                this.timelined.setModified(false);
            }
            this.timelined.resetTimeline();
            InstancePropertiesPanel.this.update();
        }

        public abstract void doPlaceOperation(PlaceObjectTypeTag var1, DepthState var2);
    }
}

